/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.FolderTable;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;
import org.apache.chemistry.opencmis.workbench.model.FolderListener;
import org.apache.chemistry.opencmis.workbench.model.ObjectListener;

public class FolderPanel
extends JPanel
implements FolderListener,
ObjectListener {
    private static final long serialVersionUID = 1L;
    private final ClientModel model;
    private String parentId;
    private JButton upButton;
    private JTextField pathField;
    private JButton goButton;
    private FolderTable folderTable;

    public FolderPanel(ClientModel model) {
        this.model = model;
        model.addFolderListener(this);
        model.addObjectListener(this);
        this.createGUI();
    }

    @Override
    public void folderLoaded(final ClientModelEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Folder currentFolder = event.getClientModel().getCurrentFolder();
                if (currentFolder != null) {
                    String path = currentFolder.getPath();
                    FolderPanel.this.pathField.setText(path);
                    Folder parent = currentFolder.getFolderParent();
                    if (parent == null) {
                        FolderPanel.this.parentId = null;
                        FolderPanel.this.upButton.setEnabled(false);
                    } else {
                        FolderPanel.this.parentId = parent.getId();
                        FolderPanel.this.upButton.setEnabled(true);
                    }
                } else {
                    FolderPanel.this.pathField.setText("???");
                    FolderPanel.this.parentId = null;
                    FolderPanel.this.upButton.setEnabled(false);
                }
            }
        });
    }

    @Override
    public void objectLoaded(ClientModelEvent event) {
        int selectedRow = this.folderTable.getSelectedRow();
        if (selectedRow > -1 && event.getClientModel().getCurrentObject() != null) {
            if (selectedRow < this.folderTable.getRowCount()) {
                String selId = this.folderTable.getValueAt(this.folderTable.getSelectedRow(), 9).toString();
                String curId = event.getClientModel().getCurrentObject().getId();
                if (!curId.equals(selId)) {
                    this.folderTable.clearSelection();
                }
            } else {
                this.folderTable.clearSelection();
            }
        }
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0)));
        this.upButton = new JButton("up");
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FolderPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    ObjectId objectId = FolderPanel.this.model.loadFolder(FolderPanel.this.parentId, false);
                    FolderPanel.this.model.loadObject(objectId.getId());
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                    return;
                }
                finally {
                    FolderPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        panel.add(this.upButton);
        this.pathField = new JTextField("");
        this.pathField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FolderPanel.this.loadFolder();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        panel.add(this.pathField);
        this.goButton = new JButton("go");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderPanel.this.loadFolder();
            }
        });
        panel.add(this.goButton);
        this.add((Component)panel, "First");
        this.folderTable = new FolderTable(this.model);
        this.folderTable.setFillsViewportHeight(true);
        this.model.addFolderListener(this.folderTable);
        this.add((Component)new JScrollPane(this.folderTable), "Center");
    }

    private void loadFolder() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FolderPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    String id = FolderPanel.this.pathField.getText().trim();
                    if (id.length() == 0) {
                        id = "/";
                    }
                    ObjectId objectId = FolderPanel.this.model.loadFolder(id, id.charAt(0) == '/');
                    FolderPanel.this.model.loadObject(objectId.getId());
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                    return;
                }
                finally {
                    FolderPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }
}

