/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.CreateDocumentDialog;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.icons.CheckedOutIcon;
import org.apache.chemistry.opencmis.workbench.icons.DocumentIcon;
import org.apache.chemistry.opencmis.workbench.icons.FolderIcon;
import org.apache.chemistry.opencmis.workbench.icons.ItemIcon;
import org.apache.chemistry.opencmis.workbench.icons.PolicyIcon;
import org.apache.chemistry.opencmis.workbench.icons.PwcIcon;
import org.apache.chemistry.opencmis.workbench.icons.RelationshipIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;
import org.apache.chemistry.opencmis.workbench.model.FolderListener;
import org.apache.chemistry.opencmis.workbench.swing.GregorianCalendarRenderer;

public class FolderTable
extends JTable
implements FolderListener {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"", "Name", "Type", "Content Type", "Size", "Creation Date", "Created by", "Modification Date", "Modified by", "Id"};
    private static final int[] COLUMN_WIDTHS = new int[]{20, 200, 150, 150, 80, 180, 100, 180, 100, 300};
    public static final int ID_COLUMN = 9;
    private final ClientModel model;
    private Map<BaseTypeId, Icon> icons;
    private Icon checkedOutIcon;
    private Icon pwcIcon;

    public FolderTable(final ClientModel model) {
        this.model = model;
        this.setModel(new FolderTableModel());
        this.setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.setAutoCreateRowSorter(true);
        this.setDefaultRenderer(GregorianCalendar.class, new GregorianCalendarRenderer());
        this.setTransferHandler(new FolderTransferHandler());
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        for (int i = 0; i < COLUMN_WIDTHS.length; ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth(WorkbenchScale.scaleInt(COLUMN_WIDTHS[i]));
        }
        this.setRowHeight((int)((double)this.getFontMetrics(this.getFont()).getHeight() * 1.1));
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Copy to clipboard");
        popup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientHelper.copyTableToClipboard(FolderTable.this);
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = FolderTable.this.getSelectedRow();
                if (row > -1) {
                    String id = FolderTable.this.getModel().getValueAt(FolderTable.this.getRowSorter().convertRowIndexToModel(row), 9).toString();
                    try {
                        FolderTable.this.setCursor(Cursor.getPredefinedCursor(3));
                        model.loadObject(id);
                    }
                    catch (Exception ex) {
                        ClientHelper.showError(null, ex);
                        return;
                    }
                    finally {
                        FolderTable.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FolderTable.this.doAction(e.isShiftDown());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    FolderTable.this.doAction(e.isShiftDown());
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.loadIcons();
        this.getColumnModel().getColumn(0).setPreferredWidth((int)((double)this.icons.get(BaseTypeId.CMIS_DOCUMENT).getIconWidth() * 1.1));
    }

    private void loadIcons() {
        this.icons = new EnumMap<BaseTypeId, Icon>(BaseTypeId.class);
        this.icons.put(BaseTypeId.CMIS_DOCUMENT, new DocumentIcon(16, 16));
        this.icons.put(BaseTypeId.CMIS_FOLDER, new FolderIcon(16, 16));
        this.icons.put(BaseTypeId.CMIS_RELATIONSHIP, new RelationshipIcon(16, 16));
        this.icons.put(BaseTypeId.CMIS_POLICY, new PolicyIcon(16, 16));
        this.icons.put(BaseTypeId.CMIS_ITEM, new ItemIcon(16, 16));
        this.checkedOutIcon = new CheckedOutIcon(16, 16);
        this.pwcIcon = new PwcIcon(16, 16);
    }

    @Override
    public void folderLoaded(final ClientModelEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                event.getClientModel().getCurrentChildren();
                ((FolderTableModel)FolderTable.this.getModel()).fireTableDataChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(boolean alternate) {
        int row = this.getSelectedRow();
        if (row > -1 && row < this.model.getCurrentChildren().size()) {
            String id = this.getModel().getValueAt(this.getRowSorter().convertRowIndexToModel(row), 9).toString();
            CmisObject object = this.model.getFromCurrentChildren(id);
            if (object instanceof Document) {
                if (alternate) {
                    ClientHelper.download(this.getParent(), object, null);
                } else {
                    ClientHelper.open(this.getParent(), object, null);
                }
            } else if (object instanceof Folder) {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.model.loadFolder(object.getId(), false);
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                    return;
                }
                finally {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    class FolderTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            return support.isDrop();
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            File file = null;
            try {
                List fileList = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                if (fileList == null || fileList.size() != 1 || fileList.get(0) == null || !((File)fileList.get(0)).isFile()) {
                    return false;
                }
                file = (File)fileList.get(0);
            }
            catch (Exception ex) {
                ClientHelper.showError(null, ex);
                return false;
            }
            new CreateDocumentDialog(null, FolderTable.this.model, file);
            return true;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            int row = FolderTable.this.getSelectedRow();
            if (row > -1 && row < FolderTable.this.model.getCurrentChildren().size()) {
                String id = FolderTable.this.getValueAt(row, 9).toString();
                CmisObject object = FolderTable.this.model.getFromCurrentChildren(id);
                if (object instanceof Document) {
                    Document doc = (Document)object;
                    File tempFile = null;
                    try {
                        tempFile = ClientHelper.createTempFileFromDocument((CmisObject)doc, null);
                    }
                    catch (Exception e) {
                        ClientHelper.showError(null, e);
                    }
                    final File tempTransFile = tempFile;
                    return new Transferable(){

                        @Override
                        public boolean isDataFlavorSupported(DataFlavor flavor) {
                            return flavor == DataFlavor.javaFileListFlavor;
                        }

                        @Override
                        public DataFlavor[] getTransferDataFlavors() {
                            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
                        }

                        @Override
                        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                            return Collections.singletonList(tempTransFile);
                        }
                    };
                }
            }
            return null;
        }
    }

    class FolderTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        FolderTableModel() {
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return FolderTable.this.model.getCurrentChildren().size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CmisObject obj = FolderTable.this.model.getCurrentChildren().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (obj instanceof Document) {
                        Document doc = (Document)obj;
                        if (Boolean.TRUE.equals(doc.isVersionSeriesCheckedOut())) {
                            if (doc.getId().equals(doc.getVersionSeriesCheckedOutId())) {
                                return FolderTable.this.pwcIcon;
                            }
                            return FolderTable.this.checkedOutIcon;
                        }
                        return FolderTable.this.icons.get(BaseTypeId.CMIS_DOCUMENT);
                    }
                    return FolderTable.this.icons.get(obj.getBaseTypeId());
                }
                case 1: {
                    return obj.getName();
                }
                case 2: {
                    return obj.getType().getId();
                }
                case 3: {
                    if (obj instanceof Document) {
                        return ((Document)obj).getContentStreamMimeType();
                    }
                    return null;
                }
                case 4: {
                    if (obj instanceof Document) {
                        return ((Document)obj).getContentStreamLength();
                    }
                    return null;
                }
                case 5: {
                    return obj.getCreationDate();
                }
                case 6: {
                    return obj.getCreatedBy();
                }
                case 7: {
                    return obj.getLastModificationDate();
                }
                case 8: {
                    return obj.getLastModifiedBy();
                }
                case 9: {
                    return obj.getId();
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ImageIcon.class;
                }
                case 4: {
                    return Long.class;
                }
                case 5: 
                case 7: {
                    return GregorianCalendar.class;
                }
            }
            return String.class;
        }
    }
}

