/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.icons.CmisLogoIcon;

public class InfoDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public InfoDialog(Frame owner) {
        super(owner, "Info", true);
        this.createGUI();
    }

    private void createGUI() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension((int)(screenSize.getWidth() / 2.0), (int)(screenSize.getHeight() / 2.0)));
        this.setMinimumSize(new Dimension(600, 400));
        this.setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel topPanel = new JPanel(new FlowLayout());
        JLabel cmisLogo = new JLabel(new CmisLogoIcon(128, 128));
        topPanel.add(cmisLogo);
        Font labelFont = UIManager.getFont("Label.font");
        Font titleFont = labelFont.deriveFont(1, labelFont.getSize2D() * 2.0f);
        JLabel titleLabel = new JLabel("CMIS Workbench");
        titleLabel.setFont(titleFont);
        topPanel.add(titleLabel);
        this.add(topPanel);
        StringBuilder readme = new StringBuilder(1024);
        readme.append(this.loadText("/META-INF/README-cmis-workbench.txt", "CMIS Workbench"));
        readme.append("\n---------------------------------------------------------\n");
        readme.append("\nCurrent System Properties:\n\n");
        Properties sysProps = System.getProperties();
        for (Object key : new TreeSet<Object>(sysProps.keySet())) {
            readme.append(key).append(" = ").append(sysProps.get(key)).append('\n');
        }
        readme.append("\n---------------------------------------------------------\n");
        readme.append(this.loadText("/META-INF/build-timestamp.txt", ""));
        JTextArea ta = new JTextArea(readme.toString());
        ta.setEditable(false);
        ta.setFont(new Font("Monospaced", 0, ta.getFont().getSize()));
        JScrollPane readmePane = new JScrollPane(ta);
        readmePane.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.add(readmePane);
        ClientHelper.installEscapeBinding(this, this.getRootPane(), false);
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public void hideDialog() {
        this.setVisible(false);
    }

    private String loadText(String file, String defaultText) {
        InputStream stream = this.getClass().getResourceAsStream(file);
        if (stream != null) {
            try {
                return IOUtils.readAllLines((InputStream)stream, (int)10000);
            }
            catch (IOException e) {
                return defaultText;
            }
        }
        return defaultText;
    }
}

