/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingInputStream.class);
    private final InputStream stream;
    private final String desc;
    private long marked;
    private long count = 0L;
    private long startTimestamp = -1L;
    private long endTimestamp = -1L;

    public LoggingInputStream(InputStream stream, String desc) {
        this.stream = stream;
        this.desc = desc;
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.stream.mark(readlimit);
        this.marked = this.count;
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: mark", (Object)this.desc);
        }
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
        this.count = this.marked;
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: reset", (Object)this.desc);
        }
    }

    protected void count(long len) {
        if (this.startTimestamp < 0L) {
            this.startTimestamp = System.currentTimeMillis();
            LOG.info("{}: started streaming", (Object)this.desc);
        }
        if (len == -1L && this.endTimestamp == -1L) {
            this.endTimestamp = System.currentTimeMillis();
            long time = this.endTimestamp - this.startTimestamp;
            long kibPerSec = time < 1L ? -1L : (long)((double)this.count / 1024.0 / ((double)time / 1000.0));
            NumberFormat nf = NumberFormat.getInstance();
            LOG.info("{}: streamed {} bytes in {} ms, {} KiB/sec", new Object[]{this.desc, nf.format(this.count), nf.format(time), nf.format(kibPerSec)});
        } else {
            this.count += len;
        }
    }

    @Override
    public int read() throws IOException {
        int b = this.stream.read();
        this.count(b == -1 ? -1L : 1L);
        if (b != -1 && LOG.isTraceEnabled()) {
            LOG.trace("{}: read {} bytes", (Object)this.desc, (Object)this.count);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int rb = this.stream.read(b, off, len);
        this.count(rb);
        if (rb != -1 && LOG.isTraceEnabled()) {
            LOG.trace("{}: read {} bytes", (Object)this.desc, (Object)this.count);
        }
        return rb;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int rb = this.stream.read(b);
        this.count(rb);
        if (rb != -1 && LOG.isTraceEnabled()) {
            LOG.trace("{}: read {} bytes", (Object)this.desc, (Object)this.count);
        }
        return rb;
    }

    @Override
    public long skip(long n) throws IOException {
        long len = super.skip(n);
        this.count(len);
        if (len > 0L && LOG.isTraceEnabled()) {
            LOG.trace("{}: read {} bytes", (Object)this.desc, (Object)this.count);
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (LOG.isDebugEnabled()) {
            LOG.info("{}: stream closed", (Object)this.desc);
        }
    }
}

