/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.workbench.AbstractLoginTab;
import org.apache.chemistry.opencmis.workbench.BasicLoginTab;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.ConnectionErrorDialog;
import org.apache.chemistry.opencmis.workbench.DiscoverLoginTab;
import org.apache.chemistry.opencmis.workbench.ExpertLoginTab;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.model.ClientSession;

public class LoginDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final String SYSPROP_LOGIN_TAB = "cmis.workbench.logintab";
    private static final ServiceLoader<AbstractLoginTab> TAB_SERVICE_LOADER = ServiceLoader.load(AbstractLoginTab.class);
    private JTabbedPane loginTabs;
    private BasicLoginTab basicLoginTab;
    private ExpertLoginTab expertLoginTab;
    private DiscoverLoginTab discoverLoginTab;
    private JButton loadRepositoryButton;
    private JButton loginButton;
    private JComboBox<Repository> repositoryBox;
    private AbstractLoginTab currentTab;
    private boolean canceled = true;
    private ClientSession clientSession;

    public LoginDialog(Frame owner) {
        super(owner, "Login", true);
        this.createGUI();
    }

    private void createGUI() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension((int)(screenSize.getWidth() / 2.0), (int)(screenSize.getHeight() / 3.0)));
        this.setMinimumSize(new Dimension(700, 500));
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.loginTabs = new JTabbedPane();
        this.add((Component)this.loginTabs, "Center");
        this.addLoginTabs(this.loginTabs);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        buttonPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.add((Component)buttonPanel, "Last");
        this.loadRepositoryButton = this.createButton("Load Repositories");
        buttonPanel.add(this.loadRepositoryButton);
        this.getRootPane().setDefaultButton(this.loadRepositoryButton);
        this.createRepositoryBox(buttonPanel);
        this.loginButton = this.createButton("Login");
        buttonPanel.add(this.loginButton);
        this.loginButton.setEnabled(false);
        this.loadRepositoryButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.repositoryBox.removeAllItems();
                try {
                    LoginDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    LoginDialog.this.currentTab.beforeLoadRepositories();
                    LoginDialog.this.createClientSession();
                    List<Repository> repositories = LoginDialog.this.clientSession.getRepositories();
                    Collections.sort(repositories, new Comparator<Repository>(){

                        @Override
                        public int compare(Repository r1, Repository r2) {
                            if (r1 == null || r1.getName() == null) {
                                return 1;
                            }
                            if (r2 == null || r2.getName() == null) {
                                return -1;
                            }
                            return r1.getName().compareTo(r2.getName());
                        }
                    });
                    if (repositories.isEmpty()) {
                        LoginDialog.this.repositoryBox.setEnabled(false);
                        LoginDialog.this.loginButton.setEnabled(false);
                        LoginDialog.this.getRootPane().setDefaultButton(LoginDialog.this.loadRepositoryButton);
                        JOptionPane.showMessageDialog(LoginDialog.this.getOwner(), "The CMIS endpoint retruned an empty list of repositories.", "No repositories!", 2);
                    } else {
                        for (Repository repository : repositories) {
                            LoginDialog.this.repositoryBox.addItem(repository);
                        }
                        LoginDialog.this.repositoryBox.setEnabled(true);
                        LoginDialog.this.loginButton.setEnabled(true);
                        LoginDialog.this.getRootPane().setDefaultButton(LoginDialog.this.loginButton);
                    }
                    LoginDialog.this.currentTab.afterLoadRepositories(repositories);
                }
                catch (Exception ex) {
                    LoginDialog.this.repositoryBox.setEnabled(false);
                    LoginDialog.this.loginButton.setEnabled(false);
                    LoginDialog.this.getRootPane().setDefaultButton(LoginDialog.this.loadRepositoryButton);
                    new ConnectionErrorDialog(LoginDialog.this, ex);
                }
                finally {
                    LoginDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LoginDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    LoginDialog.this.currentTab.beforeLogin(LoginDialog.this.clientSession.getRepositories().get(LoginDialog.this.repositoryBox.getSelectedIndex()));
                    LoginDialog.this.clientSession.createSession(LoginDialog.this.repositoryBox.getSelectedIndex());
                    LoginDialog.this.currentTab.afterLogin(LoginDialog.this.clientSession.getSession());
                    LoginDialog.this.clientSession.setStartFolderId(LoginDialog.this.currentTab.getStartFolderId());
                    LoginDialog.this.canceled = false;
                    LoginDialog.this.hideDialog();
                }
                catch (Exception ex) {
                    LoginDialog.this.repositoryBox.setEnabled(false);
                    LoginDialog.this.loginButton.setEnabled(false);
                    LoginDialog.this.getRootPane().setDefaultButton(LoginDialog.this.loadRepositoryButton);
                    new ConnectionErrorDialog(LoginDialog.this, ex);
                }
                finally {
                    LoginDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    LoginDialog.this.getRootPane().setDefaultButton(LoginDialog.this.loadRepositoryButton);
                }
            }
        });
        ClientHelper.installEscapeBinding(this, this.getRootPane(), false);
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void addLoginTabs(final JTabbedPane loginTabs) {
        for (AbstractLoginTab tab : TAB_SERVICE_LOADER) {
            loginTabs.add(tab.getTabTitle(), tab);
        }
        this.basicLoginTab = new BasicLoginTab();
        loginTabs.addTab(this.basicLoginTab.getTabTitle(), this.basicLoginTab);
        this.expertLoginTab = new ExpertLoginTab();
        loginTabs.addTab(this.expertLoginTab.getTabTitle(), this.expertLoginTab);
        this.discoverLoginTab = new DiscoverLoginTab();
        loginTabs.addTab(this.discoverLoginTab.getTabTitle(), this.discoverLoginTab);
        loginTabs.setSelectedIndex(0);
        String startTab = System.getProperty(SYSPROP_LOGIN_TAB, "0");
        try {
            int tab = Integer.parseInt(startTab);
            if (tab >= 0 && tab < loginTabs.getTabCount()) {
                loginTabs.setSelectedIndex(tab);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.currentTab = (AbstractLoginTab)loginTabs.getSelectedComponent();
        loginTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (loginTabs.getSelectedComponent() == LoginDialog.this.expertLoginTab && LoginDialog.this.currentTab.transferSessionParametersToExpertTab()) {
                    LoginDialog.this.expertLoginTab.setSessionParameters(LoginDialog.this.currentTab.getSessionParameters());
                }
                if (loginTabs.getSelectedComponent() == LoginDialog.this.discoverLoginTab) {
                    LoginDialog.this.loadRepositoryButton.setEnabled(false);
                } else {
                    LoginDialog.this.loadRepositoryButton.setEnabled(true);
                }
                LoginDialog.this.currentTab = (AbstractLoginTab)loginTabs.getSelectedComponent();
            }
        });
    }

    private JButton createButton(String title) {
        JButton button = new JButton(title);
        int height = 30;
        height = Math.max(height, this.getFontMetrics(button.getFont()).getHeight() + button.getInsets().top + button.getInsets().bottom);
        button.setPreferredSize(new Dimension(Short.MAX_VALUE, height));
        button.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        button.setAlignmentX(0.5f);
        return button;
    }

    private void createRepositoryBox(Container pane) {
        this.repositoryBox = new JComboBox();
        RepositoryRenderer renderer = new RepositoryRenderer();
        int height = (int)((double)renderer.getPreferredSize().height * 1.1);
        this.repositoryBox.setEnabled(false);
        this.repositoryBox.setRenderer(renderer);
        this.repositoryBox.setPreferredSize(new Dimension(Short.MAX_VALUE, height));
        this.repositoryBox.setAlignmentX(0.5f);
        pane.add(this.repositoryBox);
    }

    protected void setClientSession(ClientSession clientSession) {
        this.clientSession = clientSession;
    }

    public void createClientSession() {
        this.setClientSession(new ClientSession(this.currentTab.getSessionParameters(), this.currentTab.getObjectFactory(), this.currentTab.getAuthenticationProvider(), this.currentTab.getCache(), this.currentTab.getTypeDefinitionCache()));
    }

    public void showDialog() {
        this.clientSession = null;
        this.canceled = true;
        this.repositoryBox.removeAllItems();
        this.repositoryBox.setEnabled(false);
        this.loginButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.loadRepositoryButton);
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    public void hideDialog() {
        this.setVisible(false);
    }

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    public void switchToBasicTab() {
        this.loginTabs.setSelectedComponent(this.basicLoginTab);
    }

    public void switchToExpertTab() {
        if (this.currentTab.transferSessionParametersToExpertTab()) {
            this.expertLoginTab.setSessionParameters(this.currentTab.getSessionParameters());
        }
        this.loginTabs.setSelectedComponent(this.expertLoginTab);
    }

    public void switchToDiscoverTab() {
        this.loginTabs.setSelectedComponent(this.discoverLoginTab);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    static class RepositoryRenderer
    extends JPanel
    implements ListCellRenderer<Repository> {
        private static final long serialVersionUID = 1L;
        private final JLabel nameLabel;
        private final JLabel idLabel;
        private final JLabel descriptionLabel;

        public RepositoryRenderer() {
            this.setLayout(new BoxLayout(this, 3));
            this.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            Font labelFont = UIManager.getFont("Label.font");
            this.nameLabel = new JLabel();
            this.nameLabel.setFont(labelFont.deriveFont(1));
            this.add(this.nameLabel);
            this.idLabel = new JLabel();
            this.add(this.idLabel);
            this.descriptionLabel = new JLabel();
            this.add(this.descriptionLabel);
            this.setPreferredSize(new Dimension(16, this.getFontMetrics(labelFont).getHeight() * 3 + WorkbenchScale.scaleInt(6)));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Repository> list, Repository value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value == null) {
                this.nameLabel.setText("");
                this.idLabel.setText("");
                this.descriptionLabel.setText("");
            } else {
                this.nameLabel.setText(value.getName());
                this.idLabel.setText(value.getId());
                this.descriptionLabel.setText(value.getDescription());
            }
            return this;
        }
    }
}

