/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.icons.AddIcon;
import org.apache.chemistry.opencmis.workbench.icons.DownIcon;
import org.apache.chemistry.opencmis.workbench.icons.RemoveIcon;
import org.apache.chemistry.opencmis.workbench.icons.UpIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class PropertyEditorFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_TITLE = "Property Editor";
    private static final Icon ICON_ADD = new AddIcon(16, 16);
    private final ClientModel model;
    private final CmisObject object;
    private List<PropertyInputPanel> propertyPanels;

    public PropertyEditorFrame(ClientModel model, CmisObject object) {
        this.model = model;
        this.object = object;
        this.createGUI();
    }

    private void createGUI() {
        this.setTitle(WINDOW_TITLE);
        this.setIconImages(ClientHelper.getCmisIconImages());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension((int)(screenSize.getWidth() / 2.0), (int)(screenSize.getHeight() / 1.5)));
        this.setMinimumSize(new Dimension(300, 120));
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        Font labelFont = UIManager.getFont("Label.font");
        Font boldFont = labelFont.deriveFont(1, labelFont.getSize2D() * 1.2f);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel nameLabel = new JLabel(this.object.getName());
        nameLabel.setFont(boldFont);
        topPanel.add(nameLabel);
        topPanel.add(new JLabel(this.object.getId()));
        this.add((Component)topPanel, "First");
        JScrollPane scrollPane = new JScrollPane(panel);
        this.add((Component)scrollPane, "Center");
        this.propertyPanels = new ArrayList<PropertyInputPanel>();
        int position = 0;
        for (PropertyDefinition propDef : this.object.getType().getPropertyDefinitions().values()) {
            boolean isUpdatable = propDef.getUpdatability() == Updatability.READWRITE || propDef.getUpdatability() == Updatability.WHENCHECKEDOUT && this.object.hasAllowableAction(Action.CAN_CHECK_IN);
            if (!isUpdatable) continue;
            PropertyInputPanel propertyPanel = new PropertyInputPanel(propDef, this.object.getPropertyValue(propDef.getId()), position++);
            this.propertyPanels.add(propertyPanel);
            panel.add(propertyPanel);
        }
        if (this.object.getSecondaryTypes() != null) {
            for (ObjectType secType : this.object.getSecondaryTypes()) {
                if (secType.getPropertyDefinitions() == null) continue;
                for (PropertyDefinition propDef : secType.getPropertyDefinitions().values()) {
                    boolean isUpdatable = propDef.getUpdatability() == Updatability.READWRITE || propDef.getUpdatability() == Updatability.WHENCHECKEDOUT && this.object.hasAllowableAction(Action.CAN_CHECK_IN);
                    if (!isUpdatable) continue;
                    PropertyInputPanel propertyPanel = new PropertyInputPanel(propDef, this.object.getPropertyValue(propDef.getId()), position++);
                    this.propertyPanels.add(propertyPanel);
                    panel.add(propertyPanel);
                }
            }
        }
        JButton updateButton = new JButton("Update");
        updateButton.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        updateButton.setDefaultCapable(true);
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PropertyEditorFrame.this.doUpdate()) {
                    PropertyEditorFrame.this.dispose();
                }
            }
        });
        this.add((Component)updateButton, "Last");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUpdate() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (PropertyInputPanel propertyPanel : this.propertyPanels) {
                if (!propertyPanel.includeInUpdate()) continue;
                properties.put(propertyPanel.getId(), propertyPanel.getValue());
            }
            if (properties.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            ObjectId newId = this.object.updateProperties(properties, false);
            if (newId != null && newId.getId().equals(this.model.getCurrentObject().getId())) {
                try {
                    this.model.reloadObject();
                    this.model.reloadFolder();
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ClientHelper.showError(this, ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static class MultiValuePropertyInputField
    extends JPanel
    implements PropertyValue {
        private static final long serialVersionUID = 1L;
        private static final Icon ICON_UP = new UpIcon(16, 16);
        private static final Icon ICON_UP_DISABLED = new UpIcon(16, 16, false);
        private static final Icon ICON_DOWN = new DownIcon(16, 16);
        private static final Icon ICON_DOWN_DISABLED = new DownIcon(16, 16, false);
        private static final Icon ICON_REMOVE = new RemoveIcon(16, 16);
        private static final Icon ICON_REMOVE_DISABLED = new RemoveIcon(16, 16, false);
        private final JComponent component;
        private int position;
        private JButton upButton;
        private JButton downButton;

        public MultiValuePropertyInputField(JComponent component, final MultivalueManager mutlivalueManager, Color bgColor) {
            this.component = component;
            this.setLayout(new BorderLayout());
            this.setBackground(bgColor);
            this.add((Component)component, "Center");
            JPanel buttonPanel = new JPanel(new FlowLayout(2, 0, 0));
            buttonPanel.setBackground(bgColor);
            this.upButton = new JButton(ICON_UP);
            this.upButton.setDisabledIcon(ICON_UP_DISABLED);
            this.upButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mutlivalueManager.moveUp(MultiValuePropertyInputField.this.position);
                }
            });
            buttonPanel.add(this.upButton);
            this.downButton = new JButton(ICON_DOWN);
            this.downButton.setDisabledIcon(ICON_DOWN_DISABLED);
            this.downButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mutlivalueManager.moveDown(MultiValuePropertyInputField.this.position);
                }
            });
            buttonPanel.add(this.downButton);
            JButton removeButton = new JButton(ICON_REMOVE);
            removeButton.setDisabledIcon(ICON_REMOVE_DISABLED);
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mutlivalueManager.removeValue(MultiValuePropertyInputField.this.position);
                }
            });
            buttonPanel.add(removeButton);
            this.add((Component)buttonPanel, "After");
        }

        private void updatePosition(int position, boolean isLast) {
            this.position = position;
            this.upButton.setEnabled(position > 0);
            this.downButton.setEnabled(!isLast);
        }

        @Override
        public Object getPropertyValue() throws Exception {
            return ((PropertyValue)((Object)this.component)).getPropertyValue();
        }
    }

    public static class DateTimePropertyInputField
    extends JPanel
    implements PropertyValue {
        private static final long serialVersionUID = 1L;
        private static final String[] MONTH_STRINGS;
        private final SpinnerNumberModel day;
        private final SpinnerListModel month;
        private final SpinnerNumberModel year;
        private final SpinnerNumberModel hour;
        private final SpinnerNumberModel min;
        private final SpinnerNumberModel sec;
        private final TimeZone timezone;

        public DateTimePropertyInputField(Object value, UpdateStatus status, Color bgColor) {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBackground(bgColor);
            GregorianCalendar cal = value == null ? new GregorianCalendar() : (GregorianCalendar)value;
            this.timezone = cal.getTimeZone();
            this.day = new SpinnerNumberModel(cal.get(5), 1, 31, 1);
            this.addSpinner(new JSpinner(this.day), status);
            this.month = new SpinnerListModel(MONTH_STRINGS);
            this.month.setValue(MONTH_STRINGS[cal.get(2)]);
            JSpinner monthSpinner = new JSpinner(this.month);
            JComponent editor = monthSpinner.getEditor();
            if (editor instanceof JSpinner.DefaultEditor) {
                JFormattedTextField tf = ((JSpinner.DefaultEditor)editor).getTextField();
                tf.setColumns(6);
                tf.setHorizontalAlignment(4);
            }
            this.addSpinner(monthSpinner, status);
            this.year = new SpinnerNumberModel(cal.get(1), 0, 9999, 1);
            JSpinner yearSpinner = new JSpinner(this.year);
            yearSpinner.setEditor(new JSpinner.NumberEditor(yearSpinner, "#"));
            yearSpinner.getEditor().setBackground(bgColor);
            this.addSpinner(yearSpinner, status);
            this.add(new JLabel("  "));
            this.hour = new SpinnerNumberModel(cal.get(11), 0, 23, 1);
            JSpinner hourSpinner = new JSpinner(this.hour);
            this.addSpinner(hourSpinner, status);
            this.add(new JLabel(":"));
            this.min = new SpinnerNumberModel(cal.get(12), 0, 59, 1);
            JSpinner minSpinner = new JSpinner(this.min);
            this.addSpinner(minSpinner, status);
            this.add(new JLabel(":"));
            this.sec = new SpinnerNumberModel(cal.get(13), 0, 59, 1);
            JSpinner secSpinner = new JSpinner(this.sec);
            this.addSpinner(secSpinner, status);
            this.add(new JLabel(" " + this.timezone.getDisplayName(true, 0)));
        }

        private void addSpinner(JSpinner spinner, final UpdateStatus status) {
            spinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    status.setStatus(UpdateStatus.StatusFlag.UPDATE);
                }
            });
            this.add(spinner);
        }

        @Override
        public Object getPropertyValue() {
            GregorianCalendar result = new GregorianCalendar();
            result.setTimeZone(this.timezone);
            result.set(1, this.year.getNumber().intValue());
            int mi = 0;
            String ms = this.month.getValue().toString();
            for (int i = 0; i < MONTH_STRINGS.length; ++i) {
                if (!MONTH_STRINGS[i].equals(ms)) continue;
                mi = i;
                break;
            }
            result.set(2, mi);
            result.set(5, this.day.getNumber().intValue());
            result.set(11, this.hour.getNumber().intValue());
            result.set(12, this.min.getNumber().intValue());
            result.set(13, this.sec.getNumber().intValue());
            return result;
        }

        static {
            int lastIndex;
            String[] months = new DateFormatSymbols().getMonths();
            if (months[lastIndex = months.length - 1] == null || months[lastIndex].length() <= 0) {
                String[] monthStrings = new String[lastIndex];
                System.arraycopy(months, 0, monthStrings, 0, lastIndex);
                MONTH_STRINGS = monthStrings;
            } else {
                MONTH_STRINGS = months;
            }
        }
    }

    public static class BooleanPropertyInputField
    extends JComboBox<Boolean>
    implements PropertyValue {
        private static final long serialVersionUID = 1L;

        public BooleanPropertyInputField(Object value, final UpdateStatus status, Color bgColor) {
            super(new Boolean[]{Boolean.TRUE, Boolean.FALSE});
            this.setSelectedItem(value == null ? Boolean.valueOf(true) : value);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    status.setStatus(UpdateStatus.StatusFlag.UPDATE);
                }
            });
        }

        @Override
        public Boolean getPropertyValue() {
            return (Boolean)this.getSelectedItem();
        }
    }

    public static class DecimalPropertyInputField
    extends AbstractFormattedPropertyInputField {
        private static final long serialVersionUID = 1L;

        public DecimalPropertyInputField(Object value, UpdateStatus status, Color bgColor) {
            super(value, DecimalPropertyInputField.createFormat(), status, bgColor);
            this.setHorizontalAlignment(4);
        }

        private static DecimalFormat createFormat() {
            DecimalFormat result = new DecimalFormat("#,##0.#############################");
            result.setParseBigDecimal(true);
            return result;
        }
    }

    public static class IntegerPropertyInputField
    extends AbstractFormattedPropertyInputField {
        private static final long serialVersionUID = 1L;

        public IntegerPropertyInputField(Object value, UpdateStatus status, Color bgColor) {
            super(value, IntegerPropertyInputField.createFormat(), status, bgColor);
            this.setHorizontalAlignment(4);
        }

        private static DecimalFormat createFormat() {
            DecimalFormat result = new DecimalFormat("#,##0");
            result.setParseBigDecimal(true);
            result.setParseIntegerOnly(true);
            return result;
        }

        @Override
        public Object getPropertyValue() {
            return ((BigDecimal)super.getValue()).toBigIntegerExact();
        }
    }

    public static class AbstractFormattedPropertyInputField
    extends JFormattedTextField
    implements PropertyValue {
        private static final long serialVersionUID = 1L;

        public AbstractFormattedPropertyInputField(Object value, Format format, final UpdateStatus status, Color bgColor) {
            super(format);
            if (value != null) {
                this.setValue(value);
            }
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    status.setStatus(UpdateStatus.StatusFlag.UPDATE);
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
        }

        @Override
        public Object getPropertyValue() throws ParseException {
            this.commitEdit();
            return this.getValue();
        }
    }

    public static class StringPropertyInputField
    extends JTextField
    implements PropertyValue {
        private static final long serialVersionUID = 1L;

        public StringPropertyInputField(Object value, final UpdateStatus status, Color bgColor) {
            super(value == null ? "" : value.toString());
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    status.setStatus(UpdateStatus.StatusFlag.UPDATE);
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
        }

        @Override
        public Object getPropertyValue() {
            return this.getText();
        }
    }

    public static interface PropertyValue {
        public Object getPropertyValue() throws Exception;
    }

    public static class PropertyInputPanel
    extends JPanel
    implements UpdateStatus,
    MultivalueManager {
        private static final long serialVersionUID = 1L;
        private static final Color BACKGROUND1 = UIManager.getColor("Table:\"Table.cellRenderer\".background");
        private static final Color BACKGROUND2 = UIManager.getColor("Table.alternateRowColor");
        private static final Color LINE = new Color(184, 184, 184);
        private final PropertyDefinition<?> propDef;
        private final Object value;
        private final Color bgColor;
        private JComboBox<String> changeBox;
        private List<JComponent> valueComponents;

        public PropertyInputPanel(PropertyDefinition<?> propDef, Object value, int position) {
            this.propDef = propDef;
            this.value = value;
            this.bgColor = position % 2 == 0 ? BACKGROUND1 : BACKGROUND2;
            this.createGUI();
        }

        private void createGUI() {
            this.setLayout(new BoxLayout(this, 3));
            this.setBackground(this.bgColor);
            this.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createCompoundBorder(WorkbenchScale.scaleBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, LINE)), WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5)))));
            Font labelFont = UIManager.getFont("Label.font");
            Font boldFont = labelFont.deriveFont(1, labelFont.getSize2D() * 1.2f);
            JPanel titlePanel = new JPanel();
            titlePanel.setLayout(new BorderLayout());
            titlePanel.setBackground(this.bgColor);
            titlePanel.setToolTipText("<html><b>" + this.propDef.getPropertyType().value() + "</b> (" + this.propDef.getCardinality().value() + " value)" + (this.propDef.getDescription() != null ? "<br>" + ClientHelper.encodeHtml(new StringBuilder(this.propDef.getDescription().length() + 16), this.propDef.getDescription()) : ""));
            this.add(titlePanel);
            JPanel namePanel = new JPanel();
            namePanel.setLayout(new BoxLayout(namePanel, 1));
            namePanel.setBackground(this.bgColor);
            JLabel displayNameLabel = new JLabel(this.propDef.getDisplayName());
            displayNameLabel.setFont(boldFont);
            namePanel.add(displayNameLabel);
            JLabel idLabel = new JLabel(this.propDef.getId());
            namePanel.add(idLabel);
            titlePanel.add((Component)namePanel, "Before");
            this.changeBox = new JComboBox<String>(new String[]{"Don't change     ", "Update    ", "Unset     "});
            titlePanel.add(this.changeBox, "After");
            this.valueComponents = new ArrayList<JComponent>();
            if (this.propDef.getCardinality() == Cardinality.SINGLE) {
                JComponent valueField = this.createInputField(this.value);
                this.valueComponents.add(valueField);
                this.add(valueField);
            } else {
                if (this.value instanceof List) {
                    for (Object v : (List)this.value) {
                        MultiValuePropertyInputField valueField = new MultiValuePropertyInputField(this.createInputField(v), this, this.bgColor);
                        this.valueComponents.add(valueField);
                        this.add(valueField);
                    }
                }
                JPanel addPanel = new JPanel(new BorderLayout());
                addPanel.setBackground(this.bgColor);
                JButton addButton = new JButton(ICON_ADD);
                addButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PropertyInputPanel.this.addNewValue();
                        PropertyInputPanel.this.setStatus(UpdateStatus.StatusFlag.UPDATE);
                    }
                });
                addPanel.add((Component)addButton, "After");
                this.add(addPanel);
                this.updatePositions();
            }
            this.setMaximumSize(new Dimension(Short.MAX_VALUE, this.getPreferredSize().height));
        }

        private JComponent createInputField(Object value) {
            switch (this.propDef.getPropertyType()) {
                case INTEGER: {
                    return new IntegerPropertyInputField(value, this, this.bgColor);
                }
                case DECIMAL: {
                    return new DecimalPropertyInputField(value, this, this.bgColor);
                }
                case DATETIME: {
                    return new DateTimePropertyInputField(value, this, this.bgColor);
                }
                case BOOLEAN: {
                    return new BooleanPropertyInputField(value, this, this.bgColor);
                }
            }
            return new StringPropertyInputField(value, this, this.bgColor);
        }

        private void updatePositions() {
            int n = this.valueComponents.size();
            for (int i = 0; i < n; ++i) {
                MultiValuePropertyInputField comp = (MultiValuePropertyInputField)this.valueComponents.get(i);
                comp.updatePosition(i, i + 1 == n);
            }
        }

        @Override
        public void addNewValue() {
            MultiValuePropertyInputField valueField = new MultiValuePropertyInputField(this.createInputField(null), this, this.bgColor);
            this.valueComponents.add(valueField);
            this.add((Component)valueField, this.getComponentCount() - 1);
            this.updatePositions();
            this.setStatus(UpdateStatus.StatusFlag.UPDATE);
            this.revalidate();
        }

        @Override
        public void removeValue(int pos) {
            this.remove(this.valueComponents.remove(pos));
            this.updatePositions();
            this.setStatus(UpdateStatus.StatusFlag.UPDATE);
            this.revalidate();
        }

        @Override
        public void moveUp(int pos) {
            JComponent comp = this.valueComponents.get(pos);
            Collections.swap(this.valueComponents, pos, pos - 1);
            this.remove(comp);
            this.add((Component)comp, pos);
            this.updatePositions();
            this.setStatus(UpdateStatus.StatusFlag.UPDATE);
            this.revalidate();
        }

        @Override
        public void moveDown(int pos) {
            JComponent comp = this.valueComponents.get(pos);
            Collections.swap(this.valueComponents, pos, pos + 1);
            this.remove(comp);
            this.add((Component)comp, pos + 2);
            this.updatePositions();
            this.setStatus(UpdateStatus.StatusFlag.UPDATE);
            this.revalidate();
        }

        public String getId() {
            return this.propDef.getId();
        }

        public Object getValue() {
            ArrayList<Object> result = null;
            if (this.getStatus() == UpdateStatus.StatusFlag.UPDATE) {
                try {
                    if (this.propDef.getCardinality() == Cardinality.SINGLE) {
                        result = ((PropertyValue)((Object)this.valueComponents.get(0))).getPropertyValue();
                    } else {
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (JComponent comp : this.valueComponents) {
                            list.add(((PropertyValue)((Object)comp)).getPropertyValue());
                        }
                        result = list;
                    }
                }
                catch (Exception ex) {
                    ClientHelper.showError(this, ex);
                }
            }
            return result;
        }

        public boolean includeInUpdate() {
            return this.getStatus() != UpdateStatus.StatusFlag.DONT_CHANGE;
        }

        @Override
        public void setStatus(UpdateStatus.StatusFlag status) {
            switch (status) {
                case UPDATE: {
                    this.changeBox.setSelectedIndex(1);
                    break;
                }
                case UNSET: {
                    this.changeBox.setSelectedIndex(2);
                    break;
                }
                default: {
                    this.changeBox.setSelectedIndex(0);
                }
            }
        }

        @Override
        public UpdateStatus.StatusFlag getStatus() {
            switch (this.changeBox.getSelectedIndex()) {
                case 1: {
                    return UpdateStatus.StatusFlag.UPDATE;
                }
                case 2: {
                    return UpdateStatus.StatusFlag.UNSET;
                }
            }
            return UpdateStatus.StatusFlag.DONT_CHANGE;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension size = this.getPreferredSize();
            size.width = Short.MAX_VALUE;
            return size;
        }
    }

    static interface MultivalueManager {
        public void addNewValue();

        public void removeValue(int var1);

        public void moveUp(int var1);

        public void moveDown(int var1);
    }

    static interface UpdateStatus {
        public void setStatus(StatusFlag var1);

        public StatusFlag getStatus();

        public static enum StatusFlag {
            DONT_CHANGE,
            UPDATE,
            UNSET;

        }
    }
}

