/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;

public class ProxyDetector {
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTPS_PROXY_USER = "https.proxyUser";
    public static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final Pattern PROXY_ENV_VAR1 = Pattern.compile("http.?:\\/\\/(.+):(\\d+).*");
    public static final Pattern PROXY_ENV_VAR2 = Pattern.compile("(.+):(\\d+)");
    public static final Pattern PROXY_WIN_REG = Pattern.compile("\\s+Proxy(.+)\\s+REG.+\\s+(.+)");
    private static boolean debug = false;

    public static ProxySettings getJavaProxySettings() {
        ProxySettings settings = new ProxySettings();
        settings.setHttpProxyHost(System.getProperty(HTTP_PROXY_HOST));
        settings.setHttpProxyPort(ProxyDetector.parsePort(System.getProperty(HTTP_PROXY_PORT)));
        settings.setHttpProxyUser(System.getProperty(HTTP_PROXY_USER));
        settings.setHttpProxyPassword(System.getProperty(HTTP_PROXY_PASSWORD));
        settings.setHttpsProxyHost(System.getProperty(HTTPS_PROXY_HOST));
        settings.setHttpsProxyPort(ProxyDetector.parsePort(System.getProperty(HTTPS_PROXY_PORT)));
        settings.setHttpsProxyUser(System.getProperty(HTTPS_PROXY_USER));
        settings.setHttpsProxyPassword(System.getProperty(HTTPS_PROXY_PASSWORD));
        String nonProxyHosts = System.getProperty(HTTP_NON_PROXY_HOSTS);
        if (nonProxyHosts != null) {
            ArrayList<String> noHosts = new ArrayList<String>();
            String nph = nonProxyHosts;
            int pp = nph.indexOf(124);
            while (pp > -1) {
                String noHost = nph.substring(0, pp).trim();
                if (noHost.length() > 0) {
                    noHosts.add(noHost);
                }
                nph = nph.substring(pp + 1);
                pp = nph.indexOf(124);
            }
            if ((nph = nph.trim()).length() > 0) {
                noHosts.add(nph);
            }
            settings.setNonProxyHosts(noHosts);
        }
        if (settings.getHttpProxyHost() != null || settings.getHttpsProxyHost() != null) {
            return settings;
        }
        return null;
    }

    public static ProxySettings getEnvProxySettings() {
        ProxySettings settings = new ProxySettings();
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> e : env.entrySet()) {
            Matcher m;
            String key = e.getKey().trim().toLowerCase(Locale.ENGLISH);
            if ("http_proxy".equals(key)) {
                m = PROXY_ENV_VAR1.matcher(e.getValue());
                if (m.matches()) {
                    settings.setHttpProxyHost(ProxyDetector.parseHost(m.group(1)));
                    settings.setHttpProxyPort(ProxyDetector.parsePort(m.group(2)));
                    settings.setHttpProxyUser(ProxyDetector.parseProxyUser(m.group(1)));
                    settings.setHttpProxyPassword(ProxyDetector.parseProxyPassword(m.group(1)));
                    continue;
                }
                m = PROXY_ENV_VAR2.matcher(e.getValue());
                if (!m.matches()) continue;
                settings.setHttpProxyHost(ProxyDetector.parseHost(m.group(1)));
                settings.setHttpProxyPort(ProxyDetector.parsePort(m.group(2)));
                settings.setHttpProxyUser(ProxyDetector.parseProxyUser(m.group(1)));
                settings.setHttpProxyPassword(ProxyDetector.parseProxyPassword(m.group(1)));
                continue;
            }
            if ("https_proxy".equals(key)) {
                m = PROXY_ENV_VAR1.matcher(e.getValue());
                if (m.matches()) {
                    settings.setHttpsProxyHost(ProxyDetector.parseHost(m.group(1)));
                    settings.setHttpsProxyPort(ProxyDetector.parsePort(m.group(2)));
                    settings.setHttpsProxyUser(ProxyDetector.parseProxyUser(m.group(1)));
                    settings.setHttpsProxyPassword(ProxyDetector.parseProxyPassword(m.group(1)));
                    continue;
                }
                m = PROXY_ENV_VAR2.matcher(e.getValue());
                if (!m.matches()) continue;
                settings.setHttpProxyHost(ProxyDetector.parseHost(m.group(1)));
                settings.setHttpProxyPort(ProxyDetector.parsePort(m.group(2)));
                settings.setHttpsProxyUser(ProxyDetector.parseProxyUser(m.group(1)));
                settings.setHttpsProxyPassword(ProxyDetector.parseProxyPassword(m.group(1)));
                continue;
            }
            if (!"no_proxy".equals(key)) continue;
            ArrayList<String> noHosts = new ArrayList<String>();
            for (String noHost : e.getValue().split(",")) {
                if ((noHost = noHost.trim()).length() == 0) continue;
                if (noHost.charAt(0) == '.') {
                    noHost = "*" + noHost;
                }
                if (noHost.charAt(noHost.length() - 1) == '.') {
                    noHost = noHost + "*";
                }
                noHosts.add(noHost);
            }
            settings.setNonProxyHosts(noHosts);
        }
        if (settings.getHttpProxyHost() != null || settings.getHttpsProxyHost() != null) {
            return settings;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProxySettings getRegistryProxySettings() {
        if (!ProxyDetector.isWindows()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            ProxySettings settings = new ProxySettings();
            Process process = Runtime.getRuntime().exec("reg query \"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\" /v Proxy*");
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                Matcher m = PROXY_WIN_REG.matcher(line);
                if (!m.matches()) continue;
                String key = m.group(1).trim().toLowerCase(Locale.ENGLISH);
                String value = m.group(2).trim();
                if ("enable".equals(key)) {
                    if (value.equals("0x1")) continue;
                    ProxySettings proxySettings = null;
                    IOUtils.closeQuietly((Closeable)reader);
                    return proxySettings;
                }
                if ("server".equals(key)) {
                    String host = value;
                    int port = 80;
                    int x = value.indexOf(58);
                    if (x > 0) {
                        host = value.substring(0, x);
                        port = ProxyDetector.parsePort(value.substring(x + 1));
                    }
                    settings.setHttpProxyHost(host);
                    settings.setHttpProxyPort(port);
                    settings.setHttpsProxyHost(host);
                    settings.setHttpsProxyPort(port);
                    continue;
                }
                if (!"override".equals(key)) continue;
                ArrayList<String> noHosts = new ArrayList<String>();
                for (String noHost : value.split(";")) {
                    if ((noHost = noHost.trim()).length() == 0) continue;
                    noHosts.add(noHost);
                }
                settings.setNonProxyHosts(noHosts);
            }
            if (settings.getHttpProxyHost() != null || settings.getHttpsProxyHost() != null) {
                ProxySettings proxySettings = settings;
                IOUtils.closeQuietly((Closeable)reader);
                return proxySettings;
            }
            IOUtils.closeQuietly((Closeable)reader);
            return null;
        }
        catch (IOException e) {
            if (!debug) return null;
            e.printStackTrace();
            return null;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    private static String parseHost(String host) {
        if (host == null) {
            return null;
        }
        int at = host.lastIndexOf(64);
        if (at > -1) {
            return host.substring(at + 1);
        }
        return host;
    }

    private static int parsePort(String port) {
        if (port == null) {
            return 80;
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid port: " + port);
        }
    }

    private static String parseProxyUser(String host) {
        if (host == null) {
            return null;
        }
        int at = host.lastIndexOf(64);
        if (at == -1) {
            return null;
        }
        int colon = host.indexOf(58);
        if (colon == -1 || colon > at) {
            return host.substring(0, at);
        }
        return host.substring(0, colon);
    }

    private static String parseProxyPassword(String host) {
        if (host == null) {
            return null;
        }
        int at = host.lastIndexOf(64);
        if (at == -1) {
            return null;
        }
        int colon = host.indexOf(58);
        if (colon == -1 || colon > at) {
            return null;
        }
        return host.substring(colon + 1, at);
    }

    private static boolean isWindows() {
        String osname = System.getProperty("os.name");
        return osname == null ? false : osname.startsWith("Windows");
    }

    public static void main(String[] args) {
        boolean javaParams = false;
        boolean useSystemProxy = false;
        for (String arg : args) {
            if (arg.equalsIgnoreCase("-j")) {
                javaParams = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-s")) {
                useSystemProxy = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-d")) {
                debug = true;
                continue;
            }
            if (!arg.equalsIgnoreCase("-h") && !arg.equalsIgnoreCase("-?")) continue;
            System.out.println("Parameters:");
            System.out.println("-j  print Java system properties");
            System.out.println("-s  add java.net.useSystemProxies property");
            return;
        }
        ProxySettings settings = null;
        settings = ProxyDetector.getJavaProxySettings();
        if (settings == null) {
            settings = ProxyDetector.getEnvProxySettings();
        }
        if (settings == null) {
            settings = ProxyDetector.getRegistryProxySettings();
        }
        if (javaParams) {
            String proxyStr = "";
            if (settings != null) {
                proxyStr = settings.toJavaConfigString();
            }
            if (useSystemProxy) {
                if (proxyStr.length() > 0) {
                    proxyStr = proxyStr + " ";
                }
                proxyStr = proxyStr + "-Djava.net.useSystemProxies=true";
            }
            System.out.println(proxyStr);
        } else if (settings != null) {
            System.out.println(settings.toString());
        } else {
            System.out.println("DIRECT");
        }
    }

    public static class ProxySettings {
        private String httpProxyHost;
        private int httpProxyPort;
        private String httpProxyUser;
        private String httpProxyPassword;
        private String httpsProxyHost;
        private int httpsProxyPort;
        private String httpsProxyUser;
        private String httpsProxyPassword;
        private List<String> nonProxyHosts;

        public String getHttpProxyHost() {
            return this.httpProxyHost;
        }

        public void setHttpProxyHost(String httpProxyHost) {
            this.httpProxyHost = httpProxyHost;
        }

        public int getHttpProxyPort() {
            return this.httpProxyPort;
        }

        public void setHttpProxyPort(int httpProxyPort) {
            this.httpProxyPort = httpProxyPort;
        }

        public String getHttpProxyUser() {
            return this.httpProxyUser;
        }

        public void setHttpProxyUser(String httpProxyUser) {
            this.httpProxyUser = httpProxyUser;
        }

        public String getHttpProxyPassword() {
            return this.httpProxyPassword;
        }

        public void setHttpProxyPassword(String httpProxyPassword) {
            this.httpProxyPassword = httpProxyPassword;
        }

        public String getHttpsProxyHost() {
            return this.httpsProxyHost;
        }

        public void setHttpsProxyHost(String httpsProxyHost) {
            this.httpsProxyHost = httpsProxyHost;
        }

        public int getHttpsProxyPort() {
            return this.httpsProxyPort;
        }

        public void setHttpsProxyPort(int httpsProxyPort) {
            this.httpsProxyPort = httpsProxyPort;
        }

        public String getHttpsProxyUser() {
            return this.httpsProxyUser;
        }

        public void setHttpsProxyUser(String httpsProxyUser) {
            this.httpsProxyUser = httpsProxyUser;
        }

        public String getHttpsProxyPassword() {
            return this.httpsProxyPassword;
        }

        public void setHttpsProxyPassword(String httpsProxyPassword) {
            this.httpsProxyPassword = httpsProxyPassword;
        }

        public List<String> getNonProxyHosts() {
            return this.nonProxyHosts;
        }

        public void setNonProxyHosts(List<String> nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
        }

        public String toJavaConfigString() {
            StringBuilder sb = new StringBuilder(128);
            if (this.httpProxyHost != null) {
                sb.append("-Dhttp.proxyHost=" + this.httpProxyHost + " -D" + ProxyDetector.HTTP_PROXY_PORT + "=" + this.httpProxyPort);
            }
            if (this.httpProxyUser != null) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append("-Dhttp.proxyUser=" + this.httpProxyUser);
            }
            if (this.httpProxyPassword != null) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append("-Dhttp.proxyPassword=" + this.httpProxyPassword);
            }
            if (this.httpsProxyHost != null) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append("-Dhttps.proxyHost=" + this.httpsProxyHost + " -D" + ProxyDetector.HTTPS_PROXY_PORT + "=" + this.httpsProxyPort);
            }
            if (this.httpsProxyUser != null) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append("-Dhttps.proxyUser=" + this.httpsProxyUser);
            }
            if (this.httpsProxyPassword != null) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append("-Dhttps.proxyPassword=" + this.httpsProxyPassword);
            }
            if (this.nonProxyHosts != null && !this.nonProxyHosts.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                if (ProxyDetector.isWindows()) {
                    sb.append('\"');
                }
                sb.append("-Dhttp.nonProxyHosts=");
                boolean first = true;
                for (String host : this.nonProxyHosts) {
                    if (!first) {
                        sb.append('|');
                    } else {
                        first = false;
                    }
                    sb.append(host);
                }
                if (ProxyDetector.isWindows()) {
                    sb.append('\"');
                }
            }
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            if (this.httpProxyHost != null) {
                sb.append("HTTP proxy: " + this.httpProxyHost + ":" + this.httpProxyPort);
            }
            if (this.httpProxyUser != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append("HTTP proxy user: " + this.httpProxyUser);
            }
            if (this.httpProxyPassword != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append("HTTP proxy password: " + this.httpProxyPassword);
            }
            if (this.httpsProxyHost != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append("HTTPS proxy: " + this.httpsProxyHost + ":" + this.httpsProxyPort);
            }
            if (this.httpsProxyUser != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append("HTTPS proxy user: " + this.httpsProxyUser);
            }
            if (this.httpsProxyPassword != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append("HTTPS proxy password: " + this.httpsProxyPassword);
            }
            if (this.nonProxyHosts != null && !this.nonProxyHosts.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append("Non proxy hosts: ");
                boolean first = true;
                for (String host : this.nonProxyHosts) {
                    if (!first) {
                        sb.append(",");
                    } else {
                        first = false;
                    }
                    sb.append(host);
                }
            }
            return sb.toString();
        }
    }
}

