/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.NumberFormatter;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.icons.CopyIcon;
import org.apache.chemistry.opencmis.workbench.icons.QueryIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.IdRenderer;

public class QueryFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    private static final String WINDOW_TITLE = "CMIS Query";
    private static final String DEFAULT_QUERY = "SELECT * FROM cmis:document";
    private static final String[] QUERY_SNIPPETS = new String[]{"SELECT * FROM cmis:document", "SELECT * FROM cmis:folder", "SELECT cmis:objectId, cmis:name, SCORE() AS score FROM cmis:document WHERE CONTAINS('?')", "WHERE cmis:name LIKE '%'", "WHERE ? IN (?, ?, ?)", "WHERE IN_FOLDER('?')", "WHERE IN_TREE('?')", "WHERE ? = TIMESTAMP 'YYYY-MM-DDThh:mm:ss.sss[Z|+hh:mm|-hh:mm]'", "WHERE '?' = ANY ?", "ORDER BY cmis:name", "ORDER BY cmis:creationDate"};
    private final ClientModel model;
    private JTextArea queryText;
    private JFormattedTextField maxHitsField;
    private JCheckBox searchAllVersionsCheckBox;
    private ResultTable resultsTable;
    private JLabel queryTimeLabel;

    public QueryFrame(ClientModel model) {
        this.model = model;
        this.createGUI();
    }

    private void createGUI() {
        this.setTitle("CMIS Query - " + this.model.getRepositoryName());
        this.setIconImages(ClientHelper.getCmisIconImages());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension((int)(screenSize.getWidth() / 2.0), (int)(screenSize.getHeight() / 2.0)));
        this.setMinimumSize(new Dimension(200, 60));
        this.setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 3));
        this.queryText = new JTextArea(DEFAULT_QUERY, 5, 60);
        this.queryText.setLineWrap(true);
        this.queryText.setPreferredSize(new Dimension(Short.MAX_VALUE, this.queryText.getPreferredSize().height));
        inputPanel.add(this.queryText);
        JPanel inputPanel2 = new JPanel();
        inputPanel2.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        this.maxHitsField = new JFormattedTextField(new NumberFormatter());
        this.maxHitsField.setValue(100);
        this.maxHitsField.setColumns(5);
        JLabel maxHitsLabel = new JLabel("Max hits:");
        maxHitsLabel.setLabelFor(this.maxHitsField);
        buttonPanel.add(maxHitsLabel);
        buttonPanel.add(this.maxHitsField);
        this.searchAllVersionsCheckBox = new JCheckBox("search all versions", false);
        buttonPanel.add(this.searchAllVersionsCheckBox);
        JButton queryButton = new JButton("Query", new QueryIcon(11, 11));
        queryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryFrame.this.doQuery();
            }
        });
        buttonPanel.add(queryButton);
        inputPanel2.add((Component)buttonPanel, "After");
        final JPopupMenu snippetsPopup = new JPopupMenu();
        for (final String s : QUERY_SNIPPETS) {
            JMenuItem menuItem = new JMenuItem(s);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryFrame.this.queryText.insert(s, QueryFrame.this.queryText.getCaretPosition());
                }
            });
            snippetsPopup.add(menuItem);
        }
        final JButton snippetButton = new JButton("Query Snippets", new CopyIcon(20, 20));
        snippetButton.setFocusPainted(true);
        snippetButton.setBorderPainted(false);
        snippetButton.setContentAreaFilled(false);
        snippetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                snippetsPopup.show(snippetButton, 0, snippetButton.getHeight());
            }
        });
        inputPanel2.add((Component)snippetButton, "Before");
        this.queryTimeLabel = new JLabel("");
        this.queryTimeLabel.setHorizontalAlignment(0);
        inputPanel2.add((Component)this.queryTimeLabel, "Center");
        inputPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, inputPanel2.getPreferredSize().height));
        inputPanel.add(inputPanel2);
        this.resultsTable = new ResultTable();
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Copy to clipboard");
        popup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientHelper.copyTableToClipboard(QueryFrame.this.resultsTable);
            }
        });
        this.resultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = QueryFrame.this.resultsTable.rowAtPoint(e.getPoint());
                int column = QueryFrame.this.resultsTable.columnAtPoint(e.getPoint());
                if (row > -1 && QueryFrame.this.resultsTable.getColumnClass(column) == ObjectIdImpl.class) {
                    try {
                        QueryFrame.this.model.loadObject(((ObjectId)QueryFrame.this.resultsTable.getValueAt(row, column)).getId());
                    }
                    catch (Exception ex) {
                        ClientHelper.showError(QueryFrame.this, ex);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.resultsTable.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = QueryFrame.this.resultsTable.rowAtPoint(e.getPoint());
                int column = QueryFrame.this.resultsTable.columnAtPoint(e.getPoint());
                if (row > -1 && QueryFrame.this.resultsTable.getColumnClass(column) == ObjectIdImpl.class) {
                    QueryFrame.this.resultsTable.setCursor(HAND_CURSOR);
                } else {
                    QueryFrame.this.resultsTable.setCursor(DEFAULT_CURSOR);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        this.add(new JSplitPane(0, inputPanel, new JScrollPane(this.resultsTable)));
        this.getRootPane().setDefaultButton(queryButton);
        ClientHelper.installEscapeBinding(this, this.getRootPane(), true);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doQuery() {
        String text = this.queryText.getText();
        text = text.replace('\n', ' ');
        ItemIterable<QueryResult> results = null;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int maxHits = 1000;
            try {
                this.maxHitsField.commitEdit();
                maxHits = ((Number)this.maxHitsField.getValue()).intValue();
                if (maxHits < 0) {
                    maxHits = 0;
                    this.maxHitsField.setValue(0);
                }
            }
            catch (Exception e) {
                ClientHelper.showError(this, e);
            }
            results = this.model.query(text, this.searchAllVersionsCheckBox.isSelected(), maxHits);
            ResultTableModel rtm = new ResultTableModel();
            long startTime = System.currentTimeMillis();
            int row = 0;
            ItemIterable page = results.getPage(maxHits);
            for (QueryResult qr : page) {
                rtm.setColumnCount(Math.max(rtm.getColumnCount(), qr.getProperties().size()));
                for (PropertyData prop : qr.getProperties()) {
                    if ("cmis:objectId".equals(prop.getId()) && prop.getFirstValue() != null) {
                        rtm.setValue(row, prop.getQueryName(), new ObjectIdImpl(prop.getFirstValue().toString()));
                        continue;
                    }
                    rtm.setValue(row, prop.getQueryName(), prop.getValues());
                }
                ++row;
            }
            rtm.setRowCount(row);
            long stopTime = System.currentTimeMillis();
            float time = (float)(stopTime - startTime) / 1000.0f;
            String total = "<unknown>";
            if (page.getTotalNumItems() >= 0L) {
                total = String.valueOf(page.getTotalNumItems());
            }
            this.queryTimeLabel.setText(" " + row + " hits, " + total + " total (" + time + " sec)");
            this.resultsTable.setModel(rtm);
        }
        catch (Exception ex) {
            ClientHelper.showError(null, ex);
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    static class ResultTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public ResultTable() {
            this.setDefaultRenderer(ObjectIdImpl.class, new IdRenderer());
            this.setFillsViewportHeight(true);
            this.setAutoResizeMode(0);
            this.setRowHeight((int)((double)this.getFontMetrics(this.getFont()).getHeight() * 1.1));
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            String result = null;
            Point p = e.getPoint();
            int rowIndex = this.rowAtPoint(p);
            int columnIndex = this.convertColumnIndexToModel(this.columnAtPoint(p));
            ResultTableModel model = (ResultTableModel)this.getModel();
            List<?> values = model.getMultiValueAt(rowIndex, columnIndex);
            if (values != null) {
                StringBuilder sb = new StringBuilder(128);
                for (Object value : values) {
                    if (sb.length() == 0) {
                        sb.append("<html>");
                    } else {
                        sb.append("<br>");
                    }
                    if (value == null) {
                        sb.append("<i>null</i>");
                        continue;
                    }
                    ClientHelper.encodeHtml(sb, value.toString());
                }
                result = sb.toString();
            } else {
                Object value = model.getValueAt(rowIndex, columnIndex);
                if (value != null) {
                    result = value.toString();
                }
            }
            return result;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int columnIndex) {
            int width;
            Component prepareRenderer = super.prepareRenderer(renderer, rowIndex, columnIndex);
            TableColumn column = this.getColumnModel().getColumn(columnIndex);
            int currentWidth = column.getPreferredWidth();
            if (currentWidth < 200 && currentWidth < (width = prepareRenderer.getPreferredSize().width)) {
                if (width < 50) {
                    width = 50;
                } else if (width > 200) {
                    width = 200;
                }
                if (width != currentWidth) {
                    column.setPreferredWidth(width);
                }
            }
            return prepareRenderer;
        }
    }

    static class ResultTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private int columnCount = 0;
        private int rowCount = 0;
        private final Map<String, Integer> columnMapping = new HashMap<String, Integer>();
        private final Map<Integer, Map<Integer, Object>> data = new HashMap<Integer, Map<Integer, Object>>();
        private final Map<Integer, Map<Integer, List<?>>> multivalue = new HashMap();
        private final Map<Integer, Class<?>> columnClass = new HashMap();

        public void setColumnCount(int columnCount) {
            this.columnCount = columnCount;
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        public void setRowCount(int rowCount) {
            this.rowCount = rowCount;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        public void setValue(int rowIndex, String queryName, Object value) {
            Integer col = this.columnMapping.get(queryName);
            if (col == null) {
                col = this.columnMapping.size();
                this.columnMapping.put(queryName, this.columnMapping.size());
            }
            if (value == null) {
                return;
            }
            if (value instanceof List) {
                List values = (List)value;
                if (values.isEmpty()) {
                    return;
                }
                value = values.get(0);
                if (values.size() > 1) {
                    Map<Integer, List<?>> mvrow = this.multivalue.get(rowIndex);
                    if (mvrow == null) {
                        mvrow = new HashMap();
                        this.multivalue.put(rowIndex, mvrow);
                    }
                    mvrow.put(col, values);
                }
            }
            if (value instanceof GregorianCalendar) {
                value = ClientHelper.getDateString((GregorianCalendar)value);
            }
            this.columnClass.put(col, value.getClass());
            Map<Integer, Object> row = this.data.get(rowIndex);
            if (row == null) {
                row = new HashMap<Integer, Object>();
                this.data.put(rowIndex, row);
            }
            row.put(col, value);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Map<Integer, Object> row = this.data.get(rowIndex);
            if (row == null) {
                return null;
            }
            return row.get(columnIndex);
        }

        public List<?> getMultiValueAt(int rowIndex, int columnIndex) {
            Map<Integer, List<?>> row = this.multivalue.get(rowIndex);
            if (row == null) {
                return null;
            }
            return row.get(columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            for (Map.Entry<String, Integer> e : this.columnMapping.entrySet()) {
                if (!e.getValue().equals(column)) continue;
                return e.getKey();
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<?> clazz = this.columnClass.get(columnIndex);
            if (clazz != null) {
                return clazz;
            }
            return String.class;
        }
    }
}

