/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public class RandomInputStream
extends InputStream {
    private final Random random;
    private final long length;
    private long pos;

    public RandomInputStream(long length) {
        this(length, System.currentTimeMillis());
    }

    public RandomInputStream(long length, long seed) {
        this.random = new Random(seed);
        this.length = length;
        this.pos = 0L;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(Integer.MAX_VALUE, this.length - this.pos);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        for (long l = 0L; l < n; ++l) {
            if (this.read() != -1) continue;
            return l;
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        if (this.pos == this.length) {
            return -1;
        }
        ++this.pos;
        return this.random.nextInt(256);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            int r = this.read();
            if (r == -1) {
                return i == 0 ? -1 : i;
            }
            b[off + i] = (byte)r;
        }
        return len;
    }
}

