/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ExtensionFeature;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.icons.ExtensionIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.InfoPanel;

public class RepositoryInfoFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_TITLE = "CMIS Repository Info";
    private final ClientModel model;

    public RepositoryInfoFrame(ClientModel model) {
        this.model = model;
        this.createGUI();
    }

    private void createGUI() {
        this.setTitle("CMIS Repository Info - " + this.model.getRepositoryName());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension((int)(screenSize.getWidth() / 3.0), (int)(screenSize.getHeight() / 1.5)));
        this.setMinimumSize(new Dimension(200, 60));
        RepositoryInfo repInfo = null;
        try {
            repInfo = this.model.getRepositoryInfo();
        }
        catch (Exception e) {
            ClientHelper.showError(this, e);
            this.dispose();
            return;
        }
        this.add(new JScrollPane(new RepositoryInfoPanel(this.model, repInfo)));
        ClientHelper.installEscapeBinding(this, this.getRootPane(), true);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    static class RepositoryInfoPanel
    extends InfoPanel {
        private static final long serialVersionUID = 1L;
        private final RepositoryInfo repInfo;

        public RepositoryInfoPanel(ClientModel model, RepositoryInfo repInfo) {
            super(model);
            this.repInfo = repInfo;
            this.createGUI();
        }

        private void createGUI() {
            RepositoryCapabilities cap;
            this.setupGUI();
            this.addLine("Name:", true).setText(this.repInfo.getName());
            this.addLine("Id:").setText(this.repInfo.getId());
            this.addLine("Description:").setText(this.repInfo.getDescription());
            this.addLine("Vendor:").setText(this.repInfo.getVendorName());
            this.addLine("Product:").setText(this.repInfo.getProductName() + " " + this.repInfo.getProductVersion());
            this.addLine("CMIS Version:").setText(this.repInfo.getCmisVersionSupported());
            this.addId("Root folder Id:").setText(this.repInfo.getRootFolderId());
            this.addLine("Latest change token:").setText(this.repInfo.getLatestChangeLogToken());
            this.addLink("Thin client URI:").setText(this.repInfo.getThinClientUri());
            this.addLine("Principal id anonymous:").setText(this.repInfo.getPrincipalIdAnonymous());
            this.addLine("Principal id anyone:").setText(this.repInfo.getPrincipalIdAnyone());
            this.addYesNoLabel("Changes incomplete:").setValue(this.is(this.repInfo.getChangesIncomplete()));
            StringBuilder sb = new StringBuilder(64);
            if (this.repInfo.getChangesOnType() != null) {
                for (Object bt : this.repInfo.getChangesOnType()) {
                    this.appendToString(sb, bt.value());
                }
            }
            this.addLine("Changes on type:").setText(sb.toString());
            if (this.repInfo.getCapabilities() != null) {
                cap = this.repInfo.getCapabilities();
                this.addLine("Capabilities:", true).setText("");
                this.addYesNoLabel("Get descendants supported:").setValue(this.is(cap.isGetDescendantsSupported()));
                this.addYesNoLabel("Get folder tree supported:").setValue(this.is(cap.isGetFolderTreeSupported()));
                this.addYesNoLabel("Unfiling supported:").setValue(this.is(cap.isUnfilingSupported()));
                this.addYesNoLabel("Multifiling supported:").setValue(this.is(cap.isMultifilingSupported()));
                this.addYesNoLabel("Version specific filing supported:").setValue(this.is(cap.isVersionSpecificFilingSupported()));
                this.addLine("Order by:").setText(this.str(cap.getOrderByCapability()));
                this.addLine("Query:").setText(this.str(cap.getQueryCapability()));
                this.addLine("Joins:").setText(this.str(cap.getJoinCapability()));
                this.addYesNoLabel("All versions searchable:").setValue(this.is(cap.isAllVersionsSearchableSupported()));
                this.addYesNoLabel("PWC searchable:").setValue(this.is(cap.isPwcSearchableSupported()));
                this.addYesNoLabel("PWC updatable:").setValue(this.is(cap.isPwcUpdatableSupported()));
                this.addLine("Content stream updates:").setText(this.str(cap.getContentStreamUpdatesCapability()));
                this.addLine("Renditions:").setText(this.str(cap.getRenditionsCapability()));
                this.addLine("Changes:").setText(this.str(cap.getChangesCapability()));
                this.addLine("ACLs:").setText(this.str(cap.getAclCapability()));
                sb = new StringBuilder(128);
                if (cap.getNewTypeSettableAttributes() != null) {
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetId())) {
                        this.appendToString(sb, "id");
                    }
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetLocalName())) {
                        this.appendToString(sb, "localName");
                    }
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetLocalNamespace())) {
                        this.appendToString(sb, "localNamespace");
                    }
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetDisplayName())) {
                        this.appendToString(sb, "displayName");
                    }
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetQueryName())) {
                        this.appendToString(sb, "queryName");
                    }
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetDescription())) {
                        this.appendToString(sb, "description");
                    }
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetCreatable())) {
                        this.appendToString(sb, "creatable");
                    }
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetFileable())) {
                        this.appendToString(sb, "fileable");
                    }
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetQueryable())) {
                        this.appendToString(sb, "queryable");
                    }
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetFulltextIndexed())) {
                        this.appendToString(sb, "fulltextIndexed");
                    }
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetIncludedInSupertypeQuery())) {
                        this.appendToString(sb, "includedInSupertypeQuery");
                    }
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetControllablePolicy())) {
                        this.appendToString(sb, "controllablePolicy");
                    }
                    if (Boolean.TRUE.equals(cap.getNewTypeSettableAttributes().canSetControllableAcl())) {
                        this.appendToString(sb, "controllableACL");
                    }
                }
                this.addLine("New type settable attributes:").setText(sb.toString());
                sb = new StringBuilder(64);
                if (cap.getCreatablePropertyTypes() != null && cap.getCreatablePropertyTypes().canCreate() != null) {
                    for (PropertyType pt : cap.getCreatablePropertyTypes().canCreate()) {
                        this.appendToString(sb, pt.value());
                    }
                }
                this.addLine("Creatable property types:").setText(sb.toString());
            }
            if (this.repInfo.getAclCapabilities() != null) {
                Object[][] data;
                cap = this.repInfo.getAclCapabilities();
                this.addLine("ACL Capabilities:", true).setText("");
                this.addLine("Supported permissions:").setText(this.str(cap.getSupportedPermissions()));
                this.addLine("ACL propagation:").setText(this.str(cap.getAclPropagation()));
                if (cap.getPermissions() != null) {
                    data = new String[cap.getPermissions().size()][2];
                    int i = 0;
                    for (PermissionDefinition pd : cap.getPermissions()) {
                        data[i][0] = pd.getId();
                        data[i][1] = pd.getDescription();
                        ++i;
                    }
                    JTable permTable = new JTable(data, new String[]{"Permission", "Description"});
                    permTable.setFillsViewportHeight(true);
                    permTable.setRowHeight((int)((double)this.getFontMetrics(this.getFont()).getHeight() * 1.1));
                    this.addComponent("Permissions:", new JScrollPane(permTable));
                }
                if (cap.getPermissionMapping() != null) {
                    data = new String[cap.getPermissionMapping().size()][2];
                    int i = 0;
                    for (PermissionMapping pm : cap.getPermissionMapping().values()) {
                        data[i][0] = pm.getKey();
                        data[i][1] = pm.getPermissions() == null ? "" : pm.getPermissions().toString();
                        ++i;
                    }
                    JTable permMapTable = new JTable(data, new String[]{"Key", "Permissions"});
                    permMapTable.setFillsViewportHeight(true);
                    permMapTable.setRowHeight((int)((double)this.getFontMetrics(this.getFont()).getHeight() * 1.1));
                    this.addComponent("Permission mapping:", new JScrollPane(permMapTable));
                }
            }
            if (CollectionsHelper.isNotEmpty((Collection)this.repInfo.getExtensionFeatures())) {
                JTree extensionFeaturesTree = new JTree();
                extensionFeaturesTree.setRootVisible(false);
                extensionFeaturesTree.setCellRenderer(new ExtensionFeatureCellRenderer());
                extensionFeaturesTree.getSelectionModel().setSelectionMode(1);
                DefaultMutableTreeNode extFeatRootNode = new DefaultMutableTreeNode("Extensions");
                for (ExtensionFeature ef : this.repInfo.getExtensionFeatures()) {
                    DefaultMutableTreeNode efNode = new DefaultMutableTreeNode(ef);
                    extFeatRootNode.add(efNode);
                    if (ef.getCommonName() != null) {
                        efNode.add(new DefaultMutableTreeNode("Common Name: " + ef.getCommonName()));
                    }
                    if (ef.getVersionLabel() != null) {
                        efNode.add(new DefaultMutableTreeNode("Version Label: " + ef.getVersionLabel()));
                    }
                    if (ef.getDescription() != null) {
                        efNode.add(new DefaultMutableTreeNode("Description: " + ef.getDescription()));
                    }
                    if (ef.getUrl() != null) {
                        efNode.add(new DefaultMutableTreeNode("URL: " + ef.getUrl()));
                    }
                    if (!CollectionsHelper.isNotEmpty((Map)ef.getFeatureData())) continue;
                    DefaultMutableTreeNode dataNode = new DefaultMutableTreeNode("Feature Data");
                    efNode.add(dataNode);
                    for (Map.Entry e : ef.getFeatureData().entrySet()) {
                        dataNode.add(new DefaultMutableTreeNode((String)e.getKey() + ": " + (String)e.getValue()));
                    }
                }
                extensionFeaturesTree.setModel(new DefaultTreeModel(extFeatRootNode));
                this.addComponent("Extension Features:", new JScrollPane(extensionFeaturesTree));
            }
            if (CollectionsHelper.isNotEmpty((Collection)this.repInfo.getExtensions())) {
                JTree extensionsTree = new JTree();
                extensionsTree.setRootVisible(false);
                extensionsTree.setCellRenderer(new ExtensionTreeCellRenderer());
                extensionsTree.getSelectionModel().setSelectionMode(1);
                DefaultMutableTreeNode extRootNode = new DefaultMutableTreeNode("Extensions");
                this.addExtension(extRootNode, this.repInfo.getExtensions());
                extensionsTree.setModel(new DefaultTreeModel(extRootNode));
                this.addComponent("Extensions:", new JScrollPane(extensionsTree));
            }
        }

        private void addExtension(DefaultMutableTreeNode parent, List<CmisExtensionElement> extensions) {
            if (CollectionsHelper.isNullOrEmpty(extensions)) {
                return;
            }
            for (CmisExtensionElement ext : extensions) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ExtensionNode(ext));
                parent.add(node);
                if (!CollectionsHelper.isNotEmpty((Collection)ext.getChildren())) continue;
                this.addExtension(node, ext.getChildren());
            }
        }

        private void appendToString(StringBuilder sb, String str) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(str);
        }

        private boolean is(Boolean b) {
            if (b == null) {
                return false;
            }
            return b;
        }

        private String str(Object o) {
            if (o == null) {
                return "?";
            }
            return o.toString();
        }

        static class ExtensionTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private static final long serialVersionUID = 1L;
            private static final Icon EXTENSION_ICON = new ExtensionIcon(16, 16);

            ExtensionTreeCellRenderer() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                this.setIcon(EXTENSION_ICON);
                return comp;
            }
        }

        static class ExtensionFeatureCellRenderer
        extends DefaultTreeCellRenderer {
            private static final long serialVersionUID = 1L;
            private static final Icon EXTENSION_ICON = new ExtensionIcon(16, 16);

            ExtensionFeatureCellRenderer() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                Object node = ((DefaultMutableTreeNode)value).getUserObject();
                if (node instanceof ExtensionFeature) {
                    this.setText(((ExtensionFeature)node).getId());
                    this.setIcon(EXTENSION_ICON);
                } else {
                    this.setIcon(null);
                }
                return comp;
            }
        }

        static class ExtensionNode {
            private final CmisExtensionElement extension;

            public ExtensionNode(CmisExtensionElement extension) {
                this.extension = extension;
            }

            public String toString() {
                return (this.extension.getNamespace() == null ? "" : "{" + this.extension.getNamespace() + "}") + this.extension.getName() + (!this.extension.getAttributes().isEmpty() ? " " + this.extension.getAttributes() : "") + (this.extension.getChildren().isEmpty() ? ": " + this.extension.getValue() : "");
            }
        }
    }
}

