/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestProgressMonitor;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.runner.AbstractRunner;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.checks.SwingReport;
import org.apache.chemistry.opencmis.workbench.icons.TckIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class TckDialog {
    private final Frame owner;
    private final ClientModel model;
    private final TckDialogRunner runner;
    private Map<CmisTestResultStatus, Integer> status;
    private JProgressBar groupsProgressBar;
    private JProgressBar testsProgressBar;
    private JLabel statusLabel;

    public TckDialog(Frame owner, ClientModel model) {
        this.owner = owner;
        this.model = model;
        this.runner = new TckDialogRunner(model, this);
        this.status = new HashMap<CmisTestResultStatus, Integer>();
        this.status.put(CmisTestResultStatus.INFO, 0);
        this.status.put(CmisTestResultStatus.SKIPPED, 0);
        this.status.put(CmisTestResultStatus.OK, 0);
        this.status.put(CmisTestResultStatus.WARNING, 0);
        this.status.put(CmisTestResultStatus.FAILURE, 0);
        this.status.put(CmisTestResultStatus.UNEXPECTED_EXCEPTION, 0);
        try {
            this.runner.loadDefaultTckGroups();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(owner, "Error: " + e.getMessage(), "TCK Error", 0);
            return;
        }
        new TckSelectDialog();
    }

    class TckTask
    extends SwingWorker<Void, Void> {
        private final JDialog dialog;
        private final TckDialogRunner runner;

        public TckTask(JDialog dialog, TckDialogRunner runner) {
            this.dialog = dialog;
            this.runner = runner;
        }

        @Override
        public Void doInBackground() {
            try {
                this.runner.run(new DialogProgressMonitor(this.runner.getGroups().size()));
            }
            catch (InterruptedException ie) {
                this.runner.cancel();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(TckDialog.this.owner, "Error: " + e.getMessage(), "TCK Error", 0);
            }
            return null;
        }

        @Override
        public void done() {
            try {
                SwingReport report = new SwingReport(null, 700, 500);
                report.createReport(this.runner.getParameters(), this.runner.getGroups(), null);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(TckDialog.this.owner, "Error: " + e.getMessage(), "Report Error", 0);
            }
            finally {
                this.dialog.dispose();
            }
        }
    }

    private class DialogProgressMonitor
    implements CmisTestProgressMonitor {
        public DialogProgressMonitor(int numberOfGroups) {
            TckDialog.this.groupsProgressBar.setStringPainted(true);
            TckDialog.this.groupsProgressBar.setMinimum(0);
            TckDialog.this.groupsProgressBar.setMaximum(numberOfGroups);
            TckDialog.this.groupsProgressBar.setValue(0);
        }

        public void startGroup(CmisTestGroup group) {
            TckDialog.this.groupsProgressBar.setString(group.getName());
            TckDialog.this.testsProgressBar.setStringPainted(true);
            TckDialog.this.testsProgressBar.setMinimum(0);
            TckDialog.this.testsProgressBar.setMaximum(group.getTests().size());
            TckDialog.this.testsProgressBar.setValue(0);
        }

        public void endGroup(CmisTestGroup group) {
            TckDialog.this.groupsProgressBar.setString("");
            TckDialog.this.groupsProgressBar.setValue(TckDialog.this.groupsProgressBar.getValue() + 1);
        }

        public void startTest(CmisTest test) {
            TckDialog.this.testsProgressBar.setString(test.getName());
        }

        public void endTest(CmisTest test) {
            TckDialog.this.testsProgressBar.setString("");
            TckDialog.this.testsProgressBar.setValue(TckDialog.this.testsProgressBar.getValue() + 1);
            for (CmisTestResult tr : test.getResults()) {
                int x = (Integer)TckDialog.this.status.get(tr.getStatus());
                TckDialog.this.status.put(tr.getStatus(), x + 1);
            }
            StringBuilder sb = new StringBuilder(128);
            sb.append("<html>");
            int x = (Integer)TckDialog.this.status.get(CmisTestResultStatus.INFO);
            if (x > 0) {
                sb.append("<font color='#000000'>[Info: " + x + "]</font>  ");
            }
            if ((x = ((Integer)TckDialog.this.status.get(CmisTestResultStatus.SKIPPED)).intValue()) > 0) {
                sb.append("<font color='#444444'>[Skipped: " + x + "]</font>  ");
            }
            if ((x = ((Integer)TckDialog.this.status.get(CmisTestResultStatus.OK)).intValue()) > 0) {
                sb.append("<font color='#009900'>[Ok: " + x + "]</font>  ");
            }
            if ((x = ((Integer)TckDialog.this.status.get(CmisTestResultStatus.WARNING)).intValue()) > 0) {
                sb.append("<font color='#999900'>[Warning: " + x + "]</font>  ");
            }
            if ((x = ((Integer)TckDialog.this.status.get(CmisTestResultStatus.FAILURE)).intValue()) > 0) {
                sb.append("<font color='#996000'>[Failure: " + x + "]</font>  ");
            }
            if ((x = ((Integer)TckDialog.this.status.get(CmisTestResultStatus.UNEXPECTED_EXCEPTION)).intValue()) > 0) {
                sb.append("<font color='#990000'>[Exception: " + x + "]</font>  ");
            }
            sb.append("</html>");
            TckDialog.this.statusLabel.setText(sb.toString());
        }

        public void message(String msg) {
        }
    }

    private static class TckDialogRunner
    extends AbstractRunner {
        public TckDialogRunner(ClientModel model, TckDialog tckDialog) {
            HashMap<String, String> parameters = new HashMap<String, String>(model.getClientSession().getSessionParameters());
            parameters.put("org.apache.chemistry.opencmis.session.repository.id", model.getClientSession().getSession().getRepositoryInfo().getId());
            this.setParameters(parameters);
        }
    }

    private class TckRunDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private final TckTask task;

        public TckRunDialog() {
            super(TckDialog.this.owner, "TCK");
            this.createGUI();
            this.task = new TckTask(this, TckDialog.this.runner);
            this.task.execute();
        }

        private void createGUI() {
            this.setPreferredSize(new Dimension(500, 200));
            this.setMinimumSize(new Dimension(500, 200));
            this.setLayout(new BorderLayout());
            JPanel progressPanel = new JPanel();
            progressPanel.setLayout(new BoxLayout(progressPanel, 1));
            progressPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            progressPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            JLabel groupsLabel = new JLabel("Groups:");
            groupsLabel.setAlignmentX(0.0f);
            progressPanel.add(groupsLabel);
            TckDialog.this.groupsProgressBar = new JProgressBar();
            TckDialog.this.groupsProgressBar.setMinimumSize(new Dimension(500, 30));
            TckDialog.this.groupsProgressBar.setPreferredSize(new Dimension(500, 30));
            TckDialog.this.groupsProgressBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
            TckDialog.this.groupsProgressBar.setAlignmentX(0.0f);
            TckDialog.this.groupsProgressBar.setAlignmentY(0.5f);
            progressPanel.add(TckDialog.this.groupsProgressBar);
            progressPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            JLabel testsLabel = new JLabel("Tests:");
            testsLabel.setAlignmentX(0.0f);
            progressPanel.add(testsLabel);
            TckDialog.this.testsProgressBar = new JProgressBar();
            TckDialog.this.testsProgressBar.setMinimumSize(new Dimension(500, 30));
            TckDialog.this.testsProgressBar.setPreferredSize(new Dimension(500, 30));
            TckDialog.this.testsProgressBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
            TckDialog.this.testsProgressBar.setAlignmentX(0.0f);
            TckDialog.this.testsProgressBar.setAlignmentY(0.5f);
            progressPanel.add(TckDialog.this.testsProgressBar);
            progressPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            TckDialog.this.statusLabel = new JLabel();
            progressPanel.add(TckDialog.this.statusLabel);
            this.add((Component)progressPanel, "Center");
            JButton cancelButton = new JButton("Cancel");
            cancelButton.setDefaultCapable(true);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TckRunDialog.this.task.cancel(true);
                }
            });
            JPanel cancelButtonPanel = new JPanel();
            cancelButtonPanel.setLayout(new BoxLayout(cancelButtonPanel, 3));
            cancelButtonPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            cancelButton.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
            cancelButtonPanel.add(cancelButton);
            this.add((Component)cancelButtonPanel, "Last");
            this.getRootPane().setDefaultButton(cancelButton);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
    }

    private static class TestTreeNodeEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private static final long serialVersionUID = 1L;
        private TestTreeNodeRender lastObject;

        private TestTreeNodeEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.lastObject;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, final Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.lastObject = new TestTreeNodeRender();
            this.lastObject.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, false);
            this.lastObject.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ((TestTreeNode)value).setEnabled(((JCheckBox)itemEvent.getItem()).isSelected());
                    TestTreeNodeEditor.this.fireEditingStopped();
                }
            });
            return this.lastObject;
        }
    }

    private static class TestTreeNodeRender
    extends JCheckBox
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private final Color textSelectionColor = UIManager.getDefaults().getColor("Tree.selectionForeground");
        private final Color textNonSelectionColor = UIManager.getDefaults().getColor("Tree.textForeground");
        private final Color backgroundSelectionColor = UIManager.getDefaults().getColor("Tree.selectionBackground");
        private final Color backgroundNonSelectionColor = UIManager.getDefaults().getColor("Tree.textBackground");

        public TestTreeNodeRender() {
            Insets margins = UIManager.getDefaults().getInsets("Tree.rendererMargins");
            if (margins != null) {
                this.setBorder(new EmptyBorder(margins.top, margins.left, margins.bottom, margins.right));
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (sel) {
                this.setForeground(this.textSelectionColor);
                this.setBackground(this.backgroundSelectionColor);
            } else {
                this.setForeground(this.textNonSelectionColor);
                this.setBackground(this.backgroundNonSelectionColor);
            }
            if (value instanceof TestTreeNode) {
                TestTreeNode node = (TestTreeNode)value;
                this.setText(node.getName());
                this.setSelected(node.isEnabled());
                this.setToolTipText(node.getDescription());
            } else {
                this.setText(value == null ? "" : value.toString());
                this.setToolTipText(null);
            }
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void repaint() {
        }
    }

    private static class TestTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private final JTree tree;
        private final CmisTestGroup group;
        private final CmisTest test;

        public TestTreeNode(JTree tree, CmisTestGroup group) {
            this.tree = tree;
            this.group = group;
            this.test = null;
        }

        public TestTreeNode(JTree tree, CmisTest test) {
            this.tree = tree;
            this.test = test;
            this.group = null;
        }

        public CmisTestGroup getGroup() {
            return this.group;
        }

        public String getName() {
            if (this.group != null) {
                return this.group.getName();
            }
            return this.test.getName();
        }

        public String getDescription() {
            if (this.group != null) {
                return this.group.getDescription();
            }
            return this.test.getDescription();
        }

        public boolean isEnabled() {
            if (this.group != null) {
                return this.group.isEnabled();
            }
            return this.test.isEnabled();
        }

        public void setEnabled(boolean enabled) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            if (this.group != null) {
                this.group.setEnabled(enabled);
                for (int i = 0; i < this.getChildCount(); ++i) {
                    TestTreeNode node = (TestTreeNode)this.getChildAt(i);
                    node.setEnabled(enabled);
                    treeModel.nodeChanged(node);
                }
                return;
            }
            this.test.setEnabled(enabled);
            if (enabled) {
                TestTreeNode node = (TestTreeNode)this.getParent();
                node.getGroup().setEnabled(true);
                treeModel.nodeChanged(node);
            }
        }
    }

    private class TckSelectDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public TckSelectDialog() {
            super(TckDialog.this.owner, "TCK", true);
            this.createGUI();
        }

        private void createGUI() {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setPreferredSize(new Dimension((int)(screenSize.getWidth() / 3.0), (int)(screenSize.getHeight() / 1.5)));
            this.setMinimumSize(new Dimension(600, 500));
            this.setLayout(new BorderLayout());
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Groups");
            final JTree groupTree = new JTree(rootNode);
            for (CmisTestGroup group : TckDialog.this.runner.getGroups()) {
                TestTreeNode groupNode = new TestTreeNode(groupTree, group);
                rootNode.add(groupNode);
                for (CmisTest test : group.getTests()) {
                    TestTreeNode testNode = new TestTreeNode(groupTree, test);
                    groupNode.add(testNode);
                }
            }
            ((DefaultTreeModel)groupTree.getModel()).reload();
            groupTree.setRootVisible(false);
            groupTree.setCellRenderer(new TestTreeNodeRender());
            groupTree.setCellEditor(new TestTreeNodeEditor());
            groupTree.setEditable(true);
            ToolTipManager.sharedInstance().registerComponent(groupTree);
            for (int i = 0; i < groupTree.getRowCount(); ++i) {
                groupTree.expandRow(i);
            }
            final JPopupMenu treePopup = new JPopupMenu();
            JMenuItem selectItem = new JMenuItem("Select all");
            selectItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TckSelectDialog.this.selectAll(groupTree, true);
                }
            });
            treePopup.add(selectItem);
            JMenuItem deselectItem = new JMenuItem("Deselect all");
            deselectItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TckSelectDialog.this.selectAll(groupTree, false);
                }
            });
            treePopup.add(deselectItem);
            groupTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        treePopup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            JPanel configPanel = new JPanel();
            configPanel.setLayout(new BoxLayout(configPanel, 3));
            configPanel.setPreferredSize(new Dimension(this.getWidth() / 2, 500));
            configPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0)));
            final JComboBox<String> folderComboBox = this.addComboBox(configPanel, "Test folder type:", BaseTypeId.CMIS_FOLDER.value(), "cmis:folder", true);
            configPanel.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(1, 10))));
            final JComboBox<String> documentComboBox = this.addComboBox(configPanel, "Test document type:", BaseTypeId.CMIS_DOCUMENT.value(), "cmis:document", true);
            configPanel.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(1, 10))));
            final JComboBox<String> relationshipComboBox = this.addComboBox(configPanel, "Test relationship type:", BaseTypeId.CMIS_RELATIONSHIP.value(), "cmis:relationship", true);
            configPanel.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(1, 10))));
            final JComboBox<String> policyComboBox = this.addComboBox(configPanel, "Test policy type:", BaseTypeId.CMIS_POLICY.value(), "cmis:policy", true);
            configPanel.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(1, 10))));
            final JComboBox<String> itemComboBox = this.addComboBox(configPanel, "Test item type:", BaseTypeId.CMIS_ITEM.value(), "cmis:item", true);
            configPanel.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(1, 10))));
            final JComboBox<String> secondaryComboBox = this.addComboBox(configPanel, "Test secondary type:", BaseTypeId.CMIS_SECONDARY.value(), "cmis:secondary", false);
            configPanel.add(Box.createRigidArea(WorkbenchScale.scaleDimension(new Dimension(1, 10))));
            configPanel.add(new JLabel("Test folder path:"));
            final JTextField testParentFolderField = new JTextField("/");
            testParentFolderField.setMaximumSize(new Dimension(Short.MAX_VALUE, WorkbenchScale.scaleInt(10)));
            testParentFolderField.setAlignmentX(0.0f);
            configPanel.add(testParentFolderField);
            configPanel.add(Box.createVerticalGlue());
            this.add(configPanel);
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            mainPanel.add((Component)new JScrollPane(groupTree), "Center");
            mainPanel.add((Component)configPanel, "After");
            this.add((Component)mainPanel, "Center");
            JButton runButton = new JButton("Run TCK", new TckIcon(11, 11));
            runButton.setDefaultCapable(true);
            runButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    int answer = JOptionPane.showConfirmDialog(TckDialog.this.owner, "Running the TCK may take a long time and may add, remove and alter data in the repository!\nIt also puts at a strain on the repository, performing several thousand calls!\n\nAre you sure you want to proceed?", "TCK", 0, 2);
                    if (answer == 0) {
                        Map parameters = TckDialog.this.runner.getParameters();
                        parameters.put("org.apache.chemistry.opencmis.tck.default.folderType", (String)folderComboBox.getSelectedItem());
                        parameters.put("org.apache.chemistry.opencmis.tck.default.documentType", (String)documentComboBox.getSelectedItem());
                        if (relationshipComboBox.isEnabled()) {
                            parameters.put("org.apache.chemistry.opencmis.tck.default.relationshipType", (String)relationshipComboBox.getSelectedItem());
                        }
                        if (policyComboBox.isEnabled()) {
                            parameters.put("org.apache.chemistry.opencmis.tck.default.policyType", (String)policyComboBox.getSelectedItem());
                        }
                        if (itemComboBox.isEnabled()) {
                            parameters.put("org.apache.chemistry.opencmis.tck.default.itemType", (String)itemComboBox.getSelectedItem());
                        }
                        if (secondaryComboBox.isEnabled()) {
                            parameters.put("org.apache.chemistry.opencmis.tck.default.secondaryType", (String)secondaryComboBox.getSelectedItem());
                        }
                        parameters.put("org.apache.chemistry.opencmis.tck.default.testFolderParent", testParentFolderField.getText());
                        TckDialog.this.runner.setParameters(parameters);
                        TckSelectDialog.this.dispose();
                        new TckRunDialog();
                    }
                }
            });
            int height = 30;
            height = Math.max(height, this.getFontMetrics(runButton.getFont()).getHeight() + runButton.getInsets().top + runButton.getInsets().bottom);
            JPanel runButtonPanel = new JPanel();
            runButtonPanel.setLayout(new BoxLayout(runButtonPanel, 3));
            runButtonPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            runButton.setMaximumSize(new Dimension(Short.MAX_VALUE, height));
            runButtonPanel.add(runButton);
            this.add((Component)runButtonPanel, "Last");
            this.getRootPane().setDefaultButton(runButton);
            ClientHelper.installEscapeBinding(this, this.getRootPane(), true);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        private void selectAll(JTree tree, boolean select) {
            for (CmisTestGroup group : TckDialog.this.runner.getGroups()) {
                group.setEnabled(select);
                for (CmisTest test : group.getTests()) {
                    test.setEnabled(select);
                }
            }
            DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            treeModel.nodeChanged((TreeNode)treeModel.getRoot());
        }

        private JComboBox<String> addComboBox(JPanel panel, String title, String rootTypeId, String defaultTypeId, boolean creatableOnly) {
            JLabel label = new JLabel(title);
            label.setAlignmentX(0.0f);
            panel.add(label);
            List<ObjectType> types = TckDialog.this.model.getTypesAsList(rootTypeId, creatableOnly);
            String[] typeIds = new String[types.size()];
            int i = 0;
            for (ObjectType type : types) {
                typeIds[i++] = type.getId();
            }
            JComboBox<String> comboBox = new JComboBox<String>(typeIds);
            comboBox.setSelectedItem(defaultTypeId);
            comboBox.setAlignmentX(0.0f);
            comboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, 10));
            comboBox.setEnabled(typeIds.length > 0);
            panel.add(comboBox);
            return comboBox;
        }
    }
}

