/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.checks.SwingReport;
import org.apache.chemistry.opencmis.workbench.checks.TypeComplianceTestGroup;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.BaseTypeLabel;
import org.apache.chemistry.opencmis.workbench.swing.CollectionRenderer;
import org.apache.chemistry.opencmis.workbench.swing.InfoPanel;
import org.apache.chemistry.opencmis.workbench.swing.YesNoLabel;

public class TypeSplitPane
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private final ClientModel model;
    private TypeInfoPanel typePanel;
    private PropertyDefinitionTable propertyDefinitionTable;

    public TypeSplitPane(ClientModel model) {
        super(0);
        this.model = model;
        this.createGUI();
    }

    protected ClientModel getClientModel() {
        return this.model;
    }

    private void createGUI() {
        this.typePanel = new TypeInfoPanel(this.model);
        this.propertyDefinitionTable = new PropertyDefinitionTable();
        this.add(this.typePanel);
        this.setLeftComponent(new JScrollPane(this.typePanel));
        this.setRightComponent(new JScrollPane(this.propertyDefinitionTable));
        this.setDividerLocation(300);
    }

    public void setType(ObjectType type) {
        this.typePanel.setType(type);
        this.propertyDefinitionTable.setType(type);
    }

    static class PropertyDefinitionTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        private static final String[] COLUMN_NAMES = new String[]{"Name", "Id", "Description", "Local Namespace", "Local Name", "Query Name", "Type", "Cardinality", "Updatability", "Queryable", "Orderable", "Required", "Inherited", "Default Value", "Open Choice", "Choices"};
        private static final int[] COLUMN_WIDTHS = new int[]{200, 200, 200, 200, 200, 200, 80, 80, 80, 50, 50, 50, 50, 200, 50, 200};
        private ObjectType type;
        private List<PropertyDefinition<?>> propertyDefintions;

        public PropertyDefinitionTable() {
            this.setDefaultRenderer(Collection.class, new CollectionRenderer());
            this.setModel(new PropertyDefinitionTableModel(this));
            this.setAutoResizeMode(0);
            for (int i = 0; i < COLUMN_WIDTHS.length; ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                column.setPreferredWidth(WorkbenchScale.scaleInt(COLUMN_WIDTHS[i]));
            }
            this.setRowHeight((int)((double)this.getFontMetrics(this.getFont()).getHeight() * 1.1));
            final JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Copy to clipboard");
            popup.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientHelper.copyTableToClipboard(PropertyDefinitionTable.this);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.setFillsViewportHeight(true);
        }

        public void setType(ObjectType type) {
            this.type = type;
            if (type != null && type.getPropertyDefinitions() != null) {
                this.propertyDefintions = new ArrayList();
                for (PropertyDefinition propDef : type.getPropertyDefinitions().values()) {
                    this.propertyDefintions.add(propDef);
                }
                Collections.sort(this.propertyDefintions, new Comparator<PropertyDefinition<?>>(){

                    @Override
                    public int compare(PropertyDefinition<?> pd1, PropertyDefinition<?> pd2) {
                        return pd1.getId().compareTo(pd2.getId());
                    }
                });
            } else {
                this.propertyDefintions = null;
            }
            ((AbstractTableModel)this.getModel()).fireTableDataChanged();
        }

        public ObjectType getType() {
            return this.type;
        }

        public List<PropertyDefinition<?>> getPropertyDefinitions() {
            return this.propertyDefintions;
        }

        static class PropertyDefinitionTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;
            private final PropertyDefinitionTable table;

            public PropertyDefinitionTableModel(PropertyDefinitionTable table) {
                this.table = table;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return COLUMN_NAMES[columnIndex];
            }

            @Override
            public int getColumnCount() {
                return COLUMN_NAMES.length;
            }

            @Override
            public int getRowCount() {
                if (this.table.getPropertyDefinitions() == null) {
                    return 0;
                }
                return this.table.getPropertyDefinitions().size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                PropertyDefinition<?> propDef = this.table.getPropertyDefinitions().get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return propDef.getDisplayName();
                    }
                    case 1: {
                        return propDef.getId();
                    }
                    case 2: {
                        return propDef.getDescription();
                    }
                    case 3: {
                        return propDef.getLocalNamespace();
                    }
                    case 4: {
                        return propDef.getLocalName();
                    }
                    case 5: {
                        return propDef.getQueryName();
                    }
                    case 6: {
                        return propDef.getPropertyType();
                    }
                    case 7: {
                        return propDef.getCardinality();
                    }
                    case 8: {
                        return propDef.getUpdatability();
                    }
                    case 9: {
                        return propDef.isQueryable();
                    }
                    case 10: {
                        return propDef.isOrderable();
                    }
                    case 11: {
                        return propDef.isRequired();
                    }
                    case 12: {
                        return propDef.isInherited();
                    }
                    case 13: {
                        return propDef.getDefaultValue();
                    }
                    case 14: {
                        return propDef.isOpenChoice();
                    }
                    case 15: {
                        return propDef.getChoices();
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 13 || columnIndex == 15) {
                    return Collection.class;
                }
                return super.getColumnClass(columnIndex);
            }
        }
    }

    static class TypeInfoPanel
    extends InfoPanel {
        private static final long serialVersionUID = 1L;
        private JTextField nameField;
        private JTextField descriptionField;
        private JTextField idField;
        private JTextField localNamespaceField;
        private JTextField localNameField;
        private JTextField queryNameField;
        private BaseTypeLabel baseTypeField;
        private YesNoLabel creatableLabel;
        private YesNoLabel fileableLabel;
        private YesNoLabel queryableLabel;
        private YesNoLabel includeInSuperTypeLabel;
        private YesNoLabel fulltextIndexedLabel;
        private YesNoLabel aclLabel;
        private YesNoLabel policyLabel;
        private YesNoLabel versionableLabel;
        private JTextField contentStreamAllowedField;
        private JTextField allowedSourceTypesField;
        private JTextField allowedTargetTypesField;
        private JTextField typeMutabilityField;
        private JButton checkButton;

        public TypeInfoPanel(ClientModel model) {
            super(model);
            this.createGUI();
        }

        public void setType(ObjectType type) {
            if (type != null) {
                this.nameField.setText(type.getDisplayName());
                this.descriptionField.setText(type.getDescription());
                this.idField.setText(type.getId());
                this.localNamespaceField.setText(type.getLocalNamespace());
                this.localNameField.setText(type.getLocalName());
                this.queryNameField.setText(type.getQueryName());
                this.baseTypeField.setValue(type.getBaseTypeId());
                this.creatableLabel.setValue(this.is(type.isCreatable()));
                this.fileableLabel.setValue(this.is(type.isFileable()));
                this.queryableLabel.setValue(this.is(type.isQueryable()));
                this.includeInSuperTypeLabel.setValue(this.is(type.isIncludedInSupertypeQuery()));
                this.fulltextIndexedLabel.setValue(this.is(type.isFulltextIndexed()));
                this.aclLabel.setValue(this.is(type.isControllableAcl()));
                this.policyLabel.setValue(this.is(type.isControllablePolicy()));
                if (type.getTypeMutability() != null) {
                    StringBuilder sb = new StringBuilder(64);
                    if (Boolean.TRUE.equals(type.getTypeMutability().canCreate())) {
                        sb.append("create");
                    }
                    if (Boolean.TRUE.equals(type.getTypeMutability().canUpdate())) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append("update");
                    }
                    if (Boolean.TRUE.equals(type.getTypeMutability().canDelete())) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append("delete");
                    }
                    this.typeMutabilityField.setText(sb.toString());
                } else {
                    this.typeMutabilityField.setText("");
                }
                if (type instanceof DocumentTypeDefinition) {
                    DocumentTypeDefinition docType = (DocumentTypeDefinition)type;
                    this.versionableLabel.setVisible(true);
                    this.versionableLabel.setValue(this.is(docType.isVersionable()));
                    this.contentStreamAllowedField.setVisible(true);
                    this.contentStreamAllowedField.setText(docType.getContentStreamAllowed() == null ? "???" : docType.getContentStreamAllowed().value());
                } else {
                    this.versionableLabel.setVisible(false);
                    this.contentStreamAllowedField.setVisible(false);
                }
                if (type instanceof RelationshipTypeDefinition) {
                    RelationshipTypeDefinition relationshipType = (RelationshipTypeDefinition)type;
                    this.allowedSourceTypesField.setVisible(true);
                    this.allowedSourceTypesField.setText(relationshipType.getAllowedSourceTypeIds() == null ? "???" : relationshipType.getAllowedSourceTypeIds().toString());
                    this.allowedTargetTypesField.setVisible(true);
                    this.allowedTargetTypesField.setText(relationshipType.getAllowedTargetTypeIds() == null ? "???" : relationshipType.getAllowedTargetTypeIds().toString());
                } else {
                    this.allowedSourceTypesField.setVisible(false);
                    this.allowedTargetTypesField.setVisible(false);
                }
                this.checkButton.setEnabled(true);
            } else {
                this.nameField.setText("");
                this.descriptionField.setText("");
                this.idField.setText("");
                this.localNamespaceField.setText("");
                this.localNameField.setText("");
                this.queryNameField.setText("");
                this.baseTypeField.setValue(null);
                this.creatableLabel.setValue(false);
                this.fileableLabel.setValue(false);
                this.queryableLabel.setValue(false);
                this.includeInSuperTypeLabel.setValue(false);
                this.fulltextIndexedLabel.setValue(false);
                this.aclLabel.setValue(false);
                this.policyLabel.setValue(false);
                this.versionableLabel.setVisible(false);
                this.contentStreamAllowedField.setVisible(false);
                this.allowedSourceTypesField.setVisible(false);
                this.allowedTargetTypesField.setVisible(false);
                this.typeMutabilityField.setText("");
                this.checkButton.setEnabled(false);
            }
            this.revalidate();
        }

        private void createGUI() {
            this.setupGUI();
            this.nameField = this.addLine("Name:", true);
            this.descriptionField = this.addLine("Description:");
            this.idField = this.addLine("Id:");
            this.localNamespaceField = this.addLine("Local Namespace:");
            this.localNameField = this.addLine("Local Name:");
            this.queryNameField = this.addLine("Query Name:");
            this.baseTypeField = this.addBaseTypeLabel("Base Type:");
            this.creatableLabel = this.addYesNoLabel("Creatable:");
            this.fileableLabel = this.addYesNoLabel("Fileable:");
            this.queryableLabel = this.addYesNoLabel("Queryable:");
            this.includeInSuperTypeLabel = this.addYesNoLabel("Included in super type queries:");
            this.fulltextIndexedLabel = this.addYesNoLabel("Full text indexed:");
            this.aclLabel = this.addYesNoLabel("ACL controlable:");
            this.policyLabel = this.addYesNoLabel("Policy controlable:");
            this.typeMutabilityField = this.addLine("Type mutability:");
            this.versionableLabel = this.addYesNoLabel("Versionable:");
            this.contentStreamAllowedField = this.addLine("Content stream allowed:");
            this.allowedSourceTypesField = this.addLine("Allowed source types:");
            this.allowedTargetTypesField = this.addLine("Allowed target types:");
            this.checkButton = this.addComponent("", new JButton("Check specification compliance"));
            this.checkButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        TypeInfoPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        HashMap<String, String> parameters = new HashMap<String, String>(TypeInfoPanel.this.getClientModel().getClientSession().getSessionParameters());
                        parameters.put("org.apache.chemistry.opencmis.session.repository.id", TypeInfoPanel.this.getClientModel().getRepositoryInfo().getId());
                        TypeComplianceTestGroup tctg = new TypeComplianceTestGroup(parameters, TypeInfoPanel.this.idField.getText());
                        tctg.run();
                        ArrayList<CmisTestGroup> groups = new ArrayList<CmisTestGroup>();
                        groups.add((CmisTestGroup)tctg);
                        SwingReport report = new SwingReport(null, 700, 500);
                        report.createReport(parameters, groups, null);
                    }
                    catch (Exception ex) {
                        ClientHelper.showError(null, ex);
                    }
                    finally {
                        TypeInfoPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
        }

        private boolean is(Boolean b) {
            if (b == null) {
                return false;
            }
            return b;
        }
    }
}

