/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.util.TypeUtils;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.TypeSplitPane;
import org.apache.chemistry.opencmis.workbench.icons.BaseTypeIcon;
import org.apache.chemistry.opencmis.workbench.icons.CreateTypeIcon;
import org.apache.chemistry.opencmis.workbench.icons.DeleteTypeIcon;
import org.apache.chemistry.opencmis.workbench.icons.ReloadIcon;
import org.apache.chemistry.opencmis.workbench.icons.SaveTypeIcon;
import org.apache.chemistry.opencmis.workbench.icons.TypeIcon;
import org.apache.chemistry.opencmis.workbench.icons.UpdateTypeIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class TypesFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_TITLE = "CMIS Types";
    private static final int BUTTON_RELOAD = 0;
    private static final int BUTTON_SAVE = 1;
    private static final int BUTTON_UPDATE = 2;
    private static final int BUTTON_DELETE = 3;
    private static final int BUTTON_CREATE = 4;
    private final ClientModel model;
    private RepositoryInfo repInfo;
    private ObjectType currentType;
    private JToolBar toolBar;
    private JButton[] toolbarButton;
    private JTree typesTree;
    private TypeSplitPane typePanel;

    public TypesFrame(ClientModel model) {
        this.model = model;
        this.repInfo = model.getRepositoryInfo();
        this.createGUI();
        this.loadData();
    }

    private void createGUI() {
        this.setTitle("CMIS Types - " + this.model.getRepositoryName());
        this.setIconImages(ClientHelper.getCmisIconImages());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension((int)(screenSize.getWidth() / 1.5), (int)(screenSize.getHeight() / 1.5)));
        this.setMinimumSize(new Dimension(200, 60));
        this.setLayout(new BorderLayout());
        this.toolBar = new JToolBar("CMIS Types Toolbar", 0);
        this.toolbarButton = new JButton[5];
        this.toolbarButton[0] = new JButton("Reload", new ReloadIcon(20, 20));
        this.toolbarButton[0].setDisabledIcon(new ReloadIcon(20, 20, false));
        this.toolbarButton[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TypesFrame.this.loadData();
            }
        });
        this.toolBar.add(this.toolbarButton[0]);
        this.toolBar.addSeparator();
        final JPopupMenu savePopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Save Type Definition to XML");
        savePopup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = TypesFrame.this.createXmlFileChooser();
                fileChooser.setSelectedFile(new File(TypesFrame.this.getFilename() + ".xml"));
                int chooseResult = fileChooser.showDialog(TypesFrame.this.getRootPane(), "Save XML");
                if (chooseResult == 0) {
                    BufferedOutputStream out = null;
                    try {
                        out = new BufferedOutputStream(new FileOutputStream(fileChooser.getSelectedFile()));
                        TypeUtils.writeToXML((TypeDefinition)TypesFrame.this.currentType, out);
                        ((OutputStream)out).flush();
                    }
                    catch (Exception e) {
                        try {
                            ClientHelper.showError(TypesFrame.this.getRootPane(), e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(out);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Closeable)out);
                    }
                    IOUtils.closeQuietly((Closeable)out);
                }
            }
        });
        menuItem = new JMenuItem("Save Type Definition to JSON");
        savePopup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = TypesFrame.this.createJsonFileChooser();
                fileChooser.setSelectedFile(new File(TypesFrame.this.getFilename() + ".json"));
                int chooseResult = fileChooser.showDialog(TypesFrame.this.getRootPane(), "Save JSON");
                if (chooseResult == 0) {
                    BufferedOutputStream out = null;
                    try {
                        out = new BufferedOutputStream(new FileOutputStream(fileChooser.getSelectedFile()));
                        TypeUtils.writeToJSON((TypeDefinition)TypesFrame.this.currentType, out);
                        ((OutputStream)out).flush();
                    }
                    catch (Exception e) {
                        try {
                            ClientHelper.showError(TypesFrame.this.getRootPane(), e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(out);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Closeable)out);
                    }
                    IOUtils.closeQuietly((Closeable)out);
                }
            }
        });
        this.toolbarButton[1] = new JButton("Save Type Definition", new SaveTypeIcon(20, 20));
        this.toolbarButton[1].setDisabledIcon(new SaveTypeIcon(20, 20, false));
        this.toolbarButton[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                savePopup.show(TypesFrame.this.toolbarButton[1], 0, TypesFrame.this.toolbarButton[1].getHeight());
            }
        });
        this.toolBar.add(this.toolbarButton[1]);
        this.toolBar.addSeparator();
        final JPopupMenu updatePopup = new JPopupMenu();
        menuItem = new JMenuItem("Load Type Definition from XML");
        updatePopup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = TypesFrame.this.createXmlFileChooser();
                int chooseResult = fileChooser.showDialog(TypesFrame.this.getRootPane(), "Load XML");
                if (chooseResult == 0) {
                    BufferedInputStream in = null;
                    try {
                        in = new BufferedInputStream(new FileInputStream(fileChooser.getSelectedFile()), 65536);
                        TypeDefinition type = TypeUtils.readFromXML(in);
                        if (TypesFrame.this.checkTypeDefinition(type)) {
                            TypesFrame.this.model.getClientSession().getSession().updateType(type);
                        }
                        TypesFrame.this.loadData();
                    }
                    catch (Exception e) {
                        try {
                            ClientHelper.showError(TypesFrame.this.getRootPane(), e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Closeable)in);
                    }
                    IOUtils.closeQuietly((Closeable)in);
                }
            }
        });
        menuItem = new JMenuItem("Load Type Definition from JSON");
        updatePopup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = TypesFrame.this.createJsonFileChooser();
                int chooseResult = fileChooser.showDialog(TypesFrame.this.getRootPane(), "Load JSON");
                if (chooseResult == 0) {
                    BufferedInputStream in = null;
                    try {
                        in = new BufferedInputStream(new FileInputStream(fileChooser.getSelectedFile()), 65536);
                        TypeDefinition type = TypeUtils.readFromJSON(in);
                        if (TypesFrame.this.checkTypeDefinition(type)) {
                            TypesFrame.this.model.getClientSession().getSession().updateType(type);
                        }
                        TypesFrame.this.loadData();
                    }
                    catch (Exception e) {
                        try {
                            ClientHelper.showError(TypesFrame.this.getRootPane(), e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Closeable)in);
                    }
                    IOUtils.closeQuietly((Closeable)in);
                }
            }
        });
        this.toolbarButton[2] = new JButton("Update Type", new UpdateTypeIcon(20, 20));
        this.toolbarButton[2].setDisabledIcon(new UpdateTypeIcon(20, 20, false));
        this.toolbarButton[2].setEnabled(this.repInfo.getCmisVersion() != CmisVersion.CMIS_1_0);
        this.toolbarButton[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                updatePopup.show(TypesFrame.this.toolbarButton[2], 0, TypesFrame.this.toolbarButton[2].getHeight());
            }
        });
        this.toolBar.add(this.toolbarButton[2]);
        this.toolbarButton[3] = new JButton("Delete Type", new DeleteTypeIcon(20, 20));
        this.toolbarButton[3].setDisabledIcon(new DeleteTypeIcon(20, 20, false));
        this.toolbarButton[3].setEnabled(this.repInfo.getCmisVersion() != CmisVersion.CMIS_1_0);
        this.toolbarButton[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int answer = JOptionPane.showConfirmDialog(TypesFrame.this.getOwner(), "Do you really want to delete the type " + TypesFrame.this.currentType.getId() + "?", "Delete Type", 0, 2);
                if (answer == 0) {
                    try {
                        TypesFrame.this.model.getClientSession().getSession().deleteType(TypesFrame.this.currentType.getId());
                    }
                    catch (Exception e) {
                        ClientHelper.showError(TypesFrame.this.getRootPane(), e);
                    }
                    TypesFrame.this.loadData();
                }
            }
        });
        this.toolBar.add(this.toolbarButton[3]);
        this.toolBar.addSeparator();
        final JPopupMenu createPopup = new JPopupMenu();
        menuItem = new JMenuItem("Load Type Definition from XML");
        createPopup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = TypesFrame.this.createXmlFileChooser();
                int chooseResult = fileChooser.showDialog(TypesFrame.this.getRootPane(), "Load XML");
                if (chooseResult == 0) {
                    BufferedInputStream in = null;
                    try {
                        in = new BufferedInputStream(new FileInputStream(fileChooser.getSelectedFile()), 65536);
                        TypeDefinition type = TypeUtils.readFromXML(in);
                        if (TypesFrame.this.checkTypeDefinition(type)) {
                            TypesFrame.this.model.getClientSession().getSession().createType(type);
                        }
                        TypesFrame.this.loadData();
                    }
                    catch (Exception e) {
                        try {
                            ClientHelper.showError(TypesFrame.this.getRootPane(), e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Closeable)in);
                    }
                    IOUtils.closeQuietly((Closeable)in);
                }
            }
        });
        menuItem = new JMenuItem("Load Type Definition from JSON");
        createPopup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = TypesFrame.this.createJsonFileChooser();
                int chooseResult = fileChooser.showDialog(TypesFrame.this.getRootPane(), "Load JSON");
                if (chooseResult == 0) {
                    try {
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileChooser.getSelectedFile()), 65536);
                        TypeDefinition type = TypeUtils.readFromJSON(in);
                        ((InputStream)in).close();
                        if (TypesFrame.this.checkTypeDefinition(type)) {
                            TypesFrame.this.model.getClientSession().getSession().createType(type);
                        }
                        TypesFrame.this.loadData();
                    }
                    catch (Exception e) {
                        ClientHelper.showError(TypesFrame.this.getRootPane(), e);
                    }
                }
            }
        });
        this.toolbarButton[4] = new JButton("Create Type", new CreateTypeIcon(20, 20));
        this.toolbarButton[4].setDisabledIcon(new CreateTypeIcon(20, 20, false));
        this.toolbarButton[4].setEnabled(this.repInfo.getCmisVersion() != CmisVersion.CMIS_1_0);
        this.toolbarButton[4].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                createPopup.show(TypesFrame.this.toolbarButton[4], 0, TypesFrame.this.toolbarButton[4].getHeight());
            }
        });
        this.toolBar.add(this.toolbarButton[4]);
        this.add((Component)this.toolBar, "First");
        this.typesTree = new JTree();
        this.typesTree.setRootVisible(false);
        this.typesTree.getSelectionModel().setSelectionMode(1);
        this.typesTree.setCellRenderer(new TreeCellRenderer());
        this.typesTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)((JTree)e.getSource()).getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                TypesFrame.this.currentType = ((TypeNode)node.getUserObject()).getType();
                if (TypesFrame.this.repInfo.getCmisVersion() != CmisVersion.CMIS_1_0) {
                    TypesFrame.this.toolbarButton[2].setEnabled(TypesFrame.this.currentType.getTypeMutability() != null && Boolean.TRUE.equals(TypesFrame.this.currentType.getTypeMutability().canUpdate()));
                    TypesFrame.this.toolbarButton[3].setEnabled(TypesFrame.this.currentType.getTypeMutability() != null && Boolean.TRUE.equals(TypesFrame.this.currentType.getTypeMutability().canDelete()));
                }
                TypesFrame.this.typePanel.setType(TypesFrame.this.currentType);
            }
        });
        this.typePanel = new TypeSplitPane(this.model);
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.typesTree), this.typePanel);
        splitPane.setDividerLocation(300);
        this.add((Component)splitPane, "Center");
        ClientHelper.installEscapeBinding(this, this.getRootPane(), true);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JFileChooser createXmlFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML CMIS Type Definition File";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".xml");
            }
        });
        return fileChooser;
    }

    private JFileChooser createJsonFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "JSON CMIS Type Definition File";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".json");
            }
        });
        return fileChooser;
    }

    private String getFilename() {
        if (this.currentType != null) {
            String filename = this.currentType.getId();
            filename = filename.replace(':', '_');
            filename = filename.replace('/', '_');
            filename = filename.replace('\\', '_');
            return filename;
        }
        return "type";
    }

    private boolean checkTypeDefinition(TypeDefinition type) {
        StringBuilder sb = new StringBuilder(128);
        List<TypeUtils.ValidationError> typeResult = TypeUtils.validateTypeDefinition(type);
        if (CollectionsHelper.isNotEmpty(typeResult)) {
            sb.append("\nType Definition:\n");
            for (TypeUtils.ValidationError error : typeResult) {
                sb.append("- ");
                sb.append(error.toString());
                sb.append('\n');
            }
        }
        if (type.getPropertyDefinitions() != null) {
            for (PropertyDefinition propDef : type.getPropertyDefinitions().values()) {
                List<TypeUtils.ValidationError> propResult = TypeUtils.validatePropertyDefinition(propDef);
                if (!CollectionsHelper.isNotEmpty(propResult)) continue;
                sb.append("\nProperty Definition '" + propDef.getId() + "':\n");
                for (TypeUtils.ValidationError error : propResult) {
                    sb.append("- ");
                    sb.append(error.toString());
                    sb.append('\n');
                }
            }
        }
        if (sb.length() == 0) {
            return true;
        }
        int answer = JOptionPane.showConfirmDialog(this, "The type defintion has the following issues.\n" + sb.toString() + "\n\nDo you want to proceed anyway?", "Type Definition Validation", 0, 2);
        return answer == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
            List<Tree<ObjectType>> types = this.model.getTypeDescendants();
            for (Tree<ObjectType> tt : types) {
                this.addLevel(rootNode, tt);
            }
            DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
            this.typesTree.setModel(treeModel);
            this.typesTree.setSelectionRow(0);
        }
        catch (Exception ex) {
            TreeModel model = this.typesTree.getModel();
            if (model instanceof DefaultTreeModel) {
                ((DefaultTreeModel)model).setRoot(null);
            }
            ClientHelper.showError(null, ex);
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void addLevel(DefaultMutableTreeNode parent, Tree<ObjectType> tree) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new TypeNode((ObjectType)tree.getItem()));
        parent.add(node);
        if (tree.getChildren() != null) {
            for (Tree tt : tree.getChildren()) {
                this.addLevel(node, (Tree<ObjectType>)tt);
            }
        }
    }

    private static class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final Icon BASETYPE_ICON = new BaseTypeIcon(16, 16);
        private static final Icon TYPE_ICON = new TypeIcon(16, 16);

        private TreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object node = ((DefaultMutableTreeNode)value).getUserObject();
            if (node instanceof TypeNode) {
                if (((TypeNode)node).getType().isBaseType()) {
                    this.setIcon(BASETYPE_ICON);
                } else {
                    this.setIcon(TYPE_ICON);
                }
            }
            return comp;
        }
    }

    private static class TypeNode {
        private final ObjectType type;

        public TypeNode(ObjectType type) {
            this.type = type;
        }

        public ObjectType getType() {
            return this.type;
        }

        public String toString() {
            return this.type.getDisplayName() + " (" + this.type.getId() + ")";
        }
    }
}

