/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.net.Authenticator;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.chemistry.opencmis.workbench.ClientFrame;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Workbench {
    private static final Logger LOG = LoggerFactory.getLogger(Workbench.class);

    public Workbench() {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "CMIS Workbench");
        Authenticator.setDefault(null);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean nimbus = false;
                        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                            if (!"Nimbus".equals(info.getName())) continue;
                            if (WorkbenchScale.isScaling()) {
                                UIManager.setLookAndFeel(new WorkbenchScale.ScaledNimbusLookAndFeel());
                            } else {
                                UIManager.setLookAndFeel(info.getClassName());
                            }
                            nimbus = true;
                            break;
                        }
                        if (!nimbus) {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Nimbus not available: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Nimbus not available: {}", (Object)e.getMessage(), (Object)e);
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ClientHelper.installKeyBindings();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ClientFrame();
            }
        });
    }

    public static void main(String[] args) {
        new Workbench();
    }
}

