/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;

public class WorkbenchScale {
    public static final String WORKBENCH_SCALE = "cmis.workbench.scale";
    private static boolean scale = false;
    private static Float scaleFactor = null;

    public static boolean isScaling() {
        return scale;
    }

    public static float getScaleFactor() {
        return scaleFactor == null ? 1.0f : scaleFactor.floatValue();
    }

    public static int scaleInt(int x) {
        if (scale) {
            return (int)((float)x * WorkbenchScale.getScaleFactor());
        }
        return x;
    }

    public static Font scaleFont(Font font) {
        if (scale) {
            return font.deriveFont((float)font.getSize() * WorkbenchScale.getScaleFactor());
        }
        return font;
    }

    public static Insets scaleInsets(Insets insets) {
        if (scale) {
            return new Insets(WorkbenchScale.scaleInt(insets.top), WorkbenchScale.scaleInt(insets.left), WorkbenchScale.scaleInt(insets.bottom), WorkbenchScale.scaleInt(insets.right));
        }
        return insets;
    }

    public static Dimension scaleDimension(Dimension dim) {
        if (scale) {
            return new Dimension(WorkbenchScale.scaleInt(dim.width), WorkbenchScale.scaleInt(dim.height));
        }
        return dim;
    }

    public static Border scaleBorder(Border border) {
        if (scale) {
            if (border instanceof EmptyBorder) {
                Insets borderInsets = WorkbenchScale.scaleInsets(((EmptyBorder)border).getBorderInsets());
                return BorderFactory.createEmptyBorder(borderInsets.top, borderInsets.left, borderInsets.bottom, borderInsets.right);
            }
            if (border instanceof LineBorder) {
                return BorderFactory.createLineBorder(((LineBorder)border).getLineColor(), WorkbenchScale.scaleInt(((LineBorder)border).getThickness()));
            }
            if (border instanceof MatteBorder) {
                Insets borderInsets = WorkbenchScale.scaleInsets(((MatteBorder)border).getBorderInsets());
                return BorderFactory.createMatteBorder(borderInsets.top, borderInsets.left, borderInsets.bottom, borderInsets.right, ((MatteBorder)border).getMatteColor());
            }
            return border;
        }
        return border;
    }

    public static ImageIcon scaleIcon(ImageIcon icon) {
        if (scale) {
            int newWidth = (int)((float)icon.getIconWidth() * WorkbenchScale.getScaleFactor());
            int newHeight = (int)((float)icon.getIconHeight() * WorkbenchScale.getScaleFactor());
            BufferedImage img = new BufferedImage(newWidth, newHeight, 6);
            Graphics2D g = img.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(icon.getImage(), 0, 0, newWidth, newHeight, 0, 0, icon.getIconWidth(), icon.getIconHeight(), null);
            g.dispose();
            return new ImageIcon(img);
        }
        return icon;
    }

    static {
        String scaleStr = System.getProperty(WORKBENCH_SCALE);
        if (scaleStr != null) {
            try {
                scaleFactor = Float.valueOf(Float.parseFloat(scaleStr.trim()));
                scale = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class ScaledNimbusLookAndFeel
    extends NimbusLookAndFeel {
        private static final long serialVersionUID = 1L;
        private UIDefaults defs;
        private boolean isScaled = false;

        @Override
        public synchronized UIDefaults getDefaults() {
            if (this.isScaled) {
                return this.defs;
            }
            this.defs = super.getDefaults();
            HashMap<String, Object> newDefs = new HashMap<String, Object>();
            Enumeration enumeration = this.defs.keys();
            while (enumeration.hasMoreElements()) {
                Border border;
                Insets insets;
                Dimension dim;
                String key = enumeration.nextElement().toString();
                Font font = this.defs.getFont(key);
                if (font != null) {
                    newDefs.put(key, WorkbenchScale.scaleFont(font));
                }
                if ((dim = this.defs.getDimension(key)) != null) {
                    newDefs.put(key, WorkbenchScale.scaleDimension(dim));
                }
                if ((insets = this.defs.getInsets(key)) != null) {
                    newDefs.put(key, WorkbenchScale.scaleInsets(insets));
                }
                if ((border = this.defs.getBorder(key)) == null) continue;
                newDefs.put(key, WorkbenchScale.scaleBorder(border));
            }
            for (Map.Entry entry : newDefs.entrySet()) {
                this.defs.put(entry.getKey(), entry.getValue());
            }
            this.isScaled = true;
            return this.defs;
        }
    }
}

