/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.ActionPanel;

public class AddObjectToFolderPanel
extends ActionPanel {
    private static final long serialVersionUID = 1L;
    private JTextField folderField;
    private JCheckBox allVersionsBox;

    public AddObjectToFolderPanel(ClientModel model) {
        super("Add Object To Folder", "Add", model);
    }

    @Override
    protected void createActionComponents() {
        JPanel folderPanel = new JPanel(new BorderLayout());
        folderPanel.setBackground(Color.WHITE);
        folderPanel.add((Component)new JLabel("Folder Id:"), "Before");
        this.folderField = new JTextField(30);
        folderPanel.add((Component)this.folderField, "Center");
        this.addActionComponent(folderPanel);
        this.allVersionsBox = new JCheckBox("add all versions", true);
        this.addActionComponent(this.allVersionsBox);
    }

    @Override
    public boolean isAllowed() {
        if (!(this.getObject() instanceof FileableCmisObject)) {
            return false;
        }
        if (this.getObject().getAllowableActions() == null || this.getObject().getAllowableActions().getAllowableActions() == null) {
            return true;
        }
        return this.getObject().hasAllowableAction(Action.CAN_ADD_OBJECT_TO_FOLDER);
    }

    @Override
    public boolean doAction() {
        ObjectId folderId = this.getClientModel().getClientSession().getSession().createObjectId(this.folderField.getText());
        ((FileableCmisObject)this.getObject()).addToFolder(folderId, this.allVersionsBox.isSelected());
        return true;
    }
}

