/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.actions;

import java.io.FileNotFoundException;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.ActionPanel;

public class AppendContentStreamPanel
extends ActionPanel {
    private static final long serialVersionUID = 1L;
    private JTextField filenameField;
    private JCheckBox isLastChunkBox;

    public AppendContentStreamPanel(ClientModel model) {
        super("Append Content Stream", "Append Content Stream", model);
    }

    @Override
    protected void createActionComponents() {
        this.filenameField = new JTextField(30);
        this.addActionComponent(this.createFilenamePanel(this.filenameField));
        this.isLastChunkBox = new JCheckBox("is last chunk", false);
        this.addActionComponent(this.isLastChunkBox);
    }

    @Override
    public boolean isAllowed() {
        if (this.getCmisVersion() == CmisVersion.CMIS_1_0) {
            return false;
        }
        if (this.getObject() == null || !(this.getObject() instanceof Document)) {
            return false;
        }
        if (this.getObject().getAllowableActions() == null || this.getObject().getAllowableActions().getAllowableActions() == null) {
            return true;
        }
        return this.getObject().hasAllowableAction(Action.CAN_SET_CONTENT_STREAM);
    }

    @Override
    public boolean doAction() throws FileNotFoundException {
        ContentStream content = this.getClientModel().createContentStream(this.filenameField.getText());
        try {
            ((Document)this.getObject()).appendContentStream(content, this.isLastChunkBox.isSelected(), false);
        }
        finally {
            IOUtils.closeQuietly((ContentStream)content);
        }
        return true;
    }
}

