/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.actions;

import java.io.FileNotFoundException;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.ActionPanel;

public class CheckInPanel
extends ActionPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox majorBox;
    private JTextField filenameField;

    public CheckInPanel(ClientModel model) {
        super("Check-in Object", "Check-in", model);
    }

    @Override
    protected void createActionComponents() {
        this.majorBox = new JCheckBox("major version", true);
        this.addActionComponent(this.majorBox);
        this.filenameField = new JTextField(30);
        this.addActionComponent(this.createFilenamePanel(this.filenameField));
    }

    @Override
    public boolean isAllowed() {
        if (this.getObject() == null || !(this.getObject() instanceof Document)) {
            return false;
        }
        if (this.getObject().getAllowableActions() == null || this.getObject().getAllowableActions().getAllowableActions() == null) {
            return true;
        }
        return this.getObject().hasAllowableAction(Action.CAN_CHECK_IN);
    }

    @Override
    public boolean doAction() throws FileNotFoundException {
        ContentStream content = this.getClientModel().createContentStream(this.filenameField.getText());
        try {
            ((Document)this.getObject()).checkIn(this.majorBox.isSelected(), null, content, null, null, null, null);
        }
        finally {
            IOUtils.closeQuietly((ContentStream)content);
        }
        return false;
    }
}

