/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.actions;

import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.ActionPanel;

public class DeleteTreePanel
extends ActionPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox allVersionsBox;
    private JComboBox<UnfileObject> unfileObjectsBox;
    private JCheckBox continueOnFailureBox;

    public DeleteTreePanel(ClientModel model) {
        super("Delete Tree", "Delete", model);
    }

    @Override
    protected void createActionComponents() {
        this.allVersionsBox = new JCheckBox("delete all versions", true);
        this.addActionComponent(this.allVersionsBox);
        this.unfileObjectsBox = new JComboBox<UnfileObject>(new UnfileObject[]{UnfileObject.DELETE, UnfileObject.DELETESINGLEFILED, UnfileObject.UNFILE});
        this.unfileObjectsBox.setSelectedIndex(0);
        this.addActionComponent(this.unfileObjectsBox);
        this.continueOnFailureBox = new JCheckBox("continue on failure", true);
        this.addActionComponent(this.allVersionsBox);
    }

    @Override
    public boolean isAllowed() {
        if (this.getObject() == null || !(this.getObject() instanceof Folder)) {
            return false;
        }
        if (this.getObject().getAllowableActions() == null || this.getObject().getAllowableActions().getAllowableActions() == null) {
            return true;
        }
        return this.getObject().hasAllowableAction(Action.CAN_DELETE_TREE);
    }

    @Override
    public boolean doAction() {
        List ids = ((Folder)this.getObject()).deleteTree(this.allVersionsBox.isSelected(), (UnfileObject)this.unfileObjectsBox.getSelectedItem(), this.continueOnFailureBox.isSelected());
        if (ids != null && !ids.isEmpty()) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Delete tree failed! At least the following objects could not be deleted:\n");
            for (String id : ids) {
                sb.append('\n');
                sb.append(id);
            }
            JOptionPane.showMessageDialog(this, sb.toString(), "Delete Tree", 0);
        }
        return false;
    }
}

