/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.ActionPanel;

public class DownloadPanel
extends ActionPanel {
    private static final long serialVersionUID = 1L;
    private JTextField streamIdField;

    public DownloadPanel(ClientModel model) {
        super("Download Content", "Download", model);
    }

    @Override
    protected void createActionComponents() {
        JPanel streamIdPanel = new JPanel(new BorderLayout());
        streamIdPanel.setBackground(Color.WHITE);
        streamIdPanel.add((Component)new JLabel("Stream Id:"), "Before");
        this.streamIdField = new JTextField(30);
        streamIdPanel.add((Component)this.streamIdField, "Center");
        this.addActionComponent(streamIdPanel);
    }

    @Override
    public boolean isAllowed() {
        if (this.getObject() == null || !(this.getObject() instanceof Document)) {
            return false;
        }
        if (this.getObject().getAllowableActions() == null || this.getObject().getAllowableActions().getAllowableActions() == null) {
            return true;
        }
        return this.getObject().hasAllowableAction(Action.CAN_GET_CONTENT_STREAM);
    }

    @Override
    public boolean doAction() {
        String streamId = this.streamIdField.getText().trim();
        if (streamId.length() == 0) {
            streamId = null;
        }
        ClientHelper.download(this, this.getObject(), streamId);
        return true;
    }
}

