/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.ActionPanel;

public class MovePanel
extends ActionPanel {
    private static final long serialVersionUID = 1L;
    private JTextField targetFolderField;

    public MovePanel(ClientModel model) {
        super("Move Object", "Move", model);
    }

    @Override
    protected void createActionComponents() {
        JPanel targetFolderPanel = new JPanel(new BorderLayout());
        targetFolderPanel.setBackground(Color.WHITE);
        targetFolderPanel.add((Component)new JLabel("Target Folder Id:"), "Before");
        this.targetFolderField = new JTextField(30);
        targetFolderPanel.add((Component)this.targetFolderField, "Center");
        this.addActionComponent(targetFolderPanel);
    }

    @Override
    public boolean isAllowed() {
        if (this.getObject() == null || !(this.getObject() instanceof FileableCmisObject)) {
            return false;
        }
        if (this.getObject().getAllowableActions() == null || this.getObject().getAllowableActions().getAllowableActions() == null) {
            return true;
        }
        return this.getObject().hasAllowableAction(Action.CAN_MOVE_OBJECT);
    }

    @Override
    public boolean doAction() {
        ObjectIdImpl targetFolderId = new ObjectIdImpl(this.targetFolderField.getText());
        FileableCmisObject before = (FileableCmisObject)this.getObject();
        FileableCmisObject after = before.move((ObjectId)this.getClientModel().getCurrentFolder(), (ObjectId)targetFolderId);
        return before.getId().equals(after.getId());
    }
}

