/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.ActionPanel;

public class RemoveObjectFromFolderPanel
extends ActionPanel {
    private static final long serialVersionUID = 1L;
    private JTextField folderField;

    public RemoveObjectFromFolderPanel(ClientModel model) {
        super("Remove Object From Folder", "Remove", model);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            if (this.getClientModel().getCurrentFolder() != null) {
                this.folderField.setText(this.getClientModel().getCurrentFolder().getId());
            } else {
                this.folderField.setText("");
            }
        }
        super.setVisible(visible);
    }

    @Override
    protected void createActionComponents() {
        JPanel folderPanel = new JPanel(new BorderLayout());
        folderPanel.setBackground(Color.WHITE);
        folderPanel.add((Component)new JLabel("Folder Id:"), "Before");
        this.folderField = new JTextField(30);
        folderPanel.add((Component)this.folderField, "Center");
        this.addActionComponent(folderPanel);
    }

    @Override
    public boolean isAllowed() {
        if (!(this.getObject() instanceof FileableCmisObject)) {
            return false;
        }
        if (this.getObject().getAllowableActions() == null || this.getObject().getAllowableActions().getAllowableActions() == null) {
            return true;
        }
        return this.getObject().hasAllowableAction(Action.CAN_REMOVE_OBJECT_FROM_FOLDER);
    }

    @Override
    public boolean doAction() {
        ObjectId folderId = this.getClientModel().getClientSession().getSession().createObjectId(this.folderField.getText());
        ((FileableCmisObject)this.getObject()).removeFromFolder(folderId);
        return true;
    }
}

