/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.checks;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;

public class ObjectComplianceCheck
extends AbstractSessionTest {
    private String objectId;

    public ObjectComplianceCheck(String objectId) {
        this.objectId = objectId;
    }

    public final void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Object Compliance Check");
    }

    public final void run(Session session) {
        CmisObject object = session.getObject(this.objectId, SELECT_ALL_NO_CACHE_OC);
        String[] propertiesToCheck = this.getAllProperties(object);
        this.addResult(this.checkObject(session, object, propertiesToCheck, "Object check: " + object.getId()));
        if (object instanceof Document) {
            this.addResult(this.checkVersionHistory(session, object, propertiesToCheck, "Version history check: " + object.getId()));
        } else if (object instanceof Folder) {
            this.addResult(this.checkChildren(session, (Folder)object, "Folder children check: " + object.getId()));
        }
        if (this.getResults().isEmpty()) {
            this.addResult((CmisTestResult)this.createResult(CmisTestResultStatus.OK, "Object seems to be compliant! ID: " + object.getId()));
        }
    }
}

