/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Collection;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.workbench.AclEditorFrame;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.details.AbstractDetailsTable;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class ACLTable
extends AbstractDetailsTable {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"Principal", "Permissions", "Direct"};
    private static final int[] COLUMN_WIDTHS = new int[]{200, 400, 50};

    public ACLTable(ClientModel model) {
        this.init(model, COLUMN_NAMES, COLUMN_WIDTHS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doubleClickAction(MouseEvent e, int rowIndex) {
        AllowableActions aa = this.getObject().getAllowableActions();
        if (aa == null || aa.getAllowableActions() == null || aa.getAllowableActions().contains(Action.CAN_APPLY_ACL)) {
            new AclEditorFrame(this.getClientModel(), this.getObject());
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.getClientModel().reloadObject();
                this.getClientModel().reloadFolder();
            }
            catch (Exception ex) {
                ClientHelper.showError(null, ex);
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    public int getDetailRowCount() {
        if (this.getObject().getAcl() == null || this.getObject().getAcl().getAces() == null) {
            return 0;
        }
        return this.getObject().getAcl().getAces().size();
    }

    @Override
    public Object getDetailValueAt(int rowIndex, int columnIndex) {
        Ace ace = (Ace)this.getObject().getAcl().getAces().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return ace.getPrincipalId();
            }
            case 1: {
                return ace.getPermissions();
            }
            case 2: {
                return ace.isDirect();
            }
        }
        return null;
    }

    @Override
    public Class<?> getDetailColumClass(int columnIndex) {
        if (columnIndex == 1) {
            return Collection.class;
        }
        if (columnIndex == 2) {
            return Boolean.class;
        }
        return super.getDetailColumClass(columnIndex);
    }
}

