/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;
import org.apache.chemistry.opencmis.workbench.model.ObjectListener;
import org.apache.chemistry.opencmis.workbench.swing.CollectionRenderer;
import org.apache.chemistry.opencmis.workbench.swing.IdRenderer;

public abstract class AbstractDetailsTable
extends JTable
implements ObjectListener {
    private static final long serialVersionUID = 1L;
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    private ClientModel model;
    private String[] columnNames;

    public void init(ClientModel model, String[] columnNames, int[] colummnWidths) {
        this.model = model;
        model.addObjectListener(this);
        this.columnNames = columnNames;
        this.setModel(new DetailsTableModel(this));
        this.setDefaultRenderer(Collection.class, new CollectionRenderer());
        this.setDefaultRenderer(ObjectId.class, new IdRenderer());
        this.setAutoResizeMode(0);
        this.setAutoCreateRowSorter(true);
        for (int i = 0; i < colummnWidths.length; ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth(WorkbenchScale.scaleInt(colummnWidths[i]));
        }
        this.setRowHeight((int)((double)this.getFontMetrics(this.getFont()).getHeight() * 1.1));
        this.setFillsViewportHeight(true);
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Copy to clipboard");
        popup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientHelper.copyTableToClipboard(AbstractDetailsTable.this);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int row = AbstractDetailsTable.this.rowAtPoint(e.getPoint());
                    int column = AbstractDetailsTable.this.columnAtPoint(e.getPoint());
                    if (row > -1 && column > -1) {
                        if (e.getClickCount() == 1) {
                            AbstractDetailsTable.this.singleClickAction(e, row, column);
                        } else if (e.getClickCount() == 2) {
                            AbstractDetailsTable.this.doubleClickAction(e, row);
                        }
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = AbstractDetailsTable.this.rowAtPoint(e.getPoint());
                int column = AbstractDetailsTable.this.columnAtPoint(e.getPoint());
                if (row > -1 && AbstractDetailsTable.this.getColumnClass(column) == ObjectId.class) {
                    AbstractDetailsTable.this.setCursor(HAND_CURSOR);
                } else {
                    AbstractDetailsTable.this.setCursor(DEFAULT_CURSOR);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
    }

    @Override
    public void objectLoaded(ClientModelEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((DetailsTableModel)AbstractDetailsTable.this.getModel()).fireTableDataChanged();
            }
        });
    }

    public CmisObject getObject() {
        return this.model.getCurrentObject();
    }

    public ClientModel getClientModel() {
        return this.model;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public abstract int getDetailRowCount();

    public abstract Object getDetailValueAt(int var1, int var2);

    public Class<?> getDetailColumClass(int columnIndex) {
        return String.class;
    }

    public void singleClickAction(MouseEvent e, int rowIndex, int colIndex) {
    }

    public void doubleClickAction(MouseEvent e, int rowIndex) {
    }

    public void setTab(int tab) {
        ((JTabbedPane)this.getParent().getParent().getParent()).setSelectedIndex(tab);
    }

    static class DetailsTableModel
    extends AbstractTableModel {
        private final AbstractDetailsTable table;
        private static final long serialVersionUID = 1L;

        public DetailsTableModel(AbstractDetailsTable table) {
            this.table = table;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.table.getColumnNames()[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return this.table.getColumnNames().length;
        }

        @Override
        public int getRowCount() {
            if (this.table.getObject() == null) {
                return 0;
            }
            return this.table.getDetailRowCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.table.getObject() == null) {
                return null;
            }
            return this.table.getDetailValueAt(rowIndex, columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.table.getDetailColumClass(columnIndex);
        }
    }
}

