/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.enums.ExtensionLevel;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.icons.ExtensionIcon;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;
import org.apache.chemistry.opencmis.workbench.model.ObjectListener;

public class ExtensionsPanel
extends JPanel
implements ObjectListener {
    private static final long serialVersionUID = 1L;
    private final ClientModel model;
    private JTree extensionsTree;

    public ExtensionsPanel(ClientModel model) {
        this.model = model;
        model.addObjectListener(this);
        this.createGUI();
    }

    @Override
    public void objectLoaded(ClientModelEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CmisObject object = ExtensionsPanel.this.model.getCurrentObject();
                DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
                if (object != null) {
                    List extensions = object.getExtensions(ExtensionLevel.OBJECT);
                    if (CollectionsHelper.isNotEmpty((Collection)extensions)) {
                        DefaultMutableTreeNode objectRootNode = new DefaultMutableTreeNode("Object");
                        ExtensionsPanel.this.addExtension(objectRootNode, extensions);
                        rootNode.add(objectRootNode);
                    }
                    if (CollectionsHelper.isNotEmpty((Collection)(extensions = object.getExtensions(ExtensionLevel.PROPERTIES)))) {
                        DefaultMutableTreeNode propertiesRootNode = new DefaultMutableTreeNode("Properties");
                        ExtensionsPanel.this.addExtension(propertiesRootNode, extensions);
                        rootNode.add(propertiesRootNode);
                    }
                    if (CollectionsHelper.isNotEmpty((Collection)(extensions = object.getExtensions(ExtensionLevel.ALLOWABLE_ACTIONS)))) {
                        DefaultMutableTreeNode allowableActionsRootNode = new DefaultMutableTreeNode("Allowable Actions");
                        ExtensionsPanel.this.addExtension(allowableActionsRootNode, extensions);
                        rootNode.add(allowableActionsRootNode);
                    }
                    if (CollectionsHelper.isNotEmpty((Collection)(extensions = object.getExtensions(ExtensionLevel.ACL)))) {
                        DefaultMutableTreeNode aclRootNode = new DefaultMutableTreeNode("ACL");
                        ExtensionsPanel.this.addExtension(aclRootNode, extensions);
                        rootNode.add(aclRootNode);
                    }
                    if (CollectionsHelper.isNotEmpty((Collection)(extensions = object.getExtensions(ExtensionLevel.POLICIES)))) {
                        DefaultMutableTreeNode policiesRootNode = new DefaultMutableTreeNode("Policies");
                        ExtensionsPanel.this.addExtension(policiesRootNode, extensions);
                        rootNode.add(policiesRootNode);
                    }
                }
                DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
                ExtensionsPanel.this.extensionsTree.setModel(treeModel);
            }
        });
    }

    private void addExtension(DefaultMutableTreeNode parent, List<CmisExtensionElement> extensions) {
        if (CollectionsHelper.isNullOrEmpty(extensions)) {
            return;
        }
        for (CmisExtensionElement ext : extensions) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ExtensionNode(ext));
            parent.add(node);
            if (!CollectionsHelper.isNotEmpty((Collection)ext.getChildren())) continue;
            this.addExtension(node, ext.getChildren());
        }
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder()));
        this.setBackground(Color.WHITE);
        this.extensionsTree = new JTree();
        this.extensionsTree.setRootVisible(false);
        this.extensionsTree.setCellRenderer(new ExtensionTreeCellRenderer());
        this.extensionsTree.getSelectionModel().setSelectionMode(1);
        this.extensionsTree.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.extensionsTree.setModel(new DefaultTreeModel(null));
        JScrollPane pane = new JScrollPane(this.extensionsTree);
        pane.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder()));
        this.add(pane);
    }

    static class ExtensionTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final Icon EXTENSION_ICON = new ExtensionIcon(16, 16);

        ExtensionTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(EXTENSION_ICON);
            return comp;
        }
    }

    static class ExtensionNode {
        private final CmisExtensionElement extension;

        public ExtensionNode(CmisExtensionElement extension) {
            this.extension = extension;
        }

        public String toString() {
            return (this.extension.getNamespace() == null ? "" : "{" + this.extension.getNamespace() + "}") + this.extension.getName() + (!this.extension.getAttributes().isEmpty() ? " " + this.extension.getAttributes() : "") + (this.extension.getChildren().isEmpty() ? ": " + this.extension.getValue() : "");
        }
    }
}

