/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import groovy.ui.Console;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.checks.ObjectComplianceTestGroup;
import org.apache.chemistry.opencmis.workbench.checks.SwingReport;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;
import org.apache.chemistry.opencmis.workbench.model.ObjectListener;
import org.apache.chemistry.opencmis.workbench.swing.BaseTypeLabel;
import org.apache.chemistry.opencmis.workbench.swing.InfoPanel;

public class ObjectPanel
extends InfoPanel
implements ObjectListener {
    private static final long serialVersionUID = 1L;
    private final Set<String> scriptExtensions;
    private JTextField nameField;
    private JTextField idField;
    private JTextField typeField;
    private BaseTypeLabel basetypeField;
    private InfoPanel.InfoList secondaryTypesList;
    private JTextField versionLabelField;
    private JTextField pwcField;
    private JTextField contentUrlField;
    private InfoPanel.InfoList pathsList;
    private InfoPanel.InfoList allowableActionsList;
    private JTextField aclExactField;
    private JPanel buttonPanel;
    private JButton refreshButton;
    private JButton checkButton;
    private JButton consoleButton;
    private JPanel scriptPanel;
    private JButton scriptOpenButton;
    private JButton scriptRunButton;
    private JTextArea scriptOutput;
    private JTextAreaWriter scriptOutputWriter;

    public ObjectPanel(ClientModel model) {
        super(model);
        model.addObjectListener(this);
        this.scriptExtensions = new HashSet<String>();
        ScriptEngineManager mgr = new ScriptEngineManager();
        for (ScriptEngineFactory sef : mgr.getEngineFactories()) {
            this.scriptExtensions.addAll(sef.getExtensions());
        }
        this.createGUI();
    }

    @Override
    public void objectLoaded(ClientModelEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CmisObject object = ObjectPanel.this.getClientModel().getCurrentObject();
                if (object == null) {
                    ObjectPanel.this.nameField.setText("");
                    ObjectPanel.this.idField.setText("");
                    ObjectPanel.this.typeField.setText("");
                    ObjectPanel.this.basetypeField.setValue(null);
                    ObjectPanel.this.secondaryTypesList.removeAll();
                    ObjectPanel.this.versionLabelField.setText("");
                    ObjectPanel.this.pwcField.setText("");
                    ObjectPanel.this.pathsList.removeAll();
                    ObjectPanel.this.contentUrlField.setText("");
                    ObjectPanel.this.allowableActionsList.removeAll();
                    ObjectPanel.this.aclExactField.setText("");
                    ObjectPanel.this.refreshButton.setEnabled(false);
                    ObjectPanel.this.checkButton.setEnabled(false);
                    ObjectPanel.this.consoleButton.setEnabled(false);
                    ObjectPanel.this.scriptPanel.setVisible(false);
                } else {
                    try {
                        ObjectPanel.this.nameField.setText(object.getName());
                        ObjectPanel.this.idField.setText(object.getId());
                        ObjectPanel.this.typeField.setText(object.getType().getId());
                        ObjectPanel.this.basetypeField.setValue(object.getBaseTypeId());
                        if (object.getSecondaryTypes() != null) {
                            ArrayList<String> secTypeIds = new ArrayList<String>();
                            for (SecondaryType type : object.getSecondaryTypes()) {
                                secTypeIds.add(type.getId());
                            }
                            ObjectPanel.this.secondaryTypesList.setList(secTypeIds);
                        } else {
                            ObjectPanel.this.secondaryTypesList.removeAll();
                        }
                        if (object instanceof Document) {
                            Document doc = (Document)object;
                            try {
                                ObjectPanel.this.versionLabelField.setText(doc.getVersionLabel());
                            }
                            catch (Exception e) {
                                ObjectPanel.this.versionLabelField.setText("???");
                            }
                            if (doc.isVersionSeriesCheckedOut() == null) {
                                ObjectPanel.this.pwcField.setText("");
                            } else if (doc.isVersionSeriesCheckedOut().booleanValue()) {
                                ObjectPanel.this.pwcField.setText(doc.getVersionSeriesCheckedOutId());
                            } else {
                                ObjectPanel.this.pwcField.setText("(not checked out)");
                            }
                        } else {
                            ObjectPanel.this.pwcField.setText("");
                            ObjectPanel.this.versionLabelField.setText("");
                        }
                        if (object instanceof FileableCmisObject) {
                            if (object instanceof Folder) {
                                ObjectPanel.this.pathsList.setList(Collections.singletonList(((Folder)object).getPath()));
                            } else {
                                ObjectPanel.this.pathsList.setList(Collections.singletonList(""));
                                final FileableCmisObject pathObject = (FileableCmisObject)object;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            List paths = pathObject.getPaths();
                                            if (CollectionsHelper.isNullOrEmpty((Collection)paths)) {
                                                ObjectPanel.this.pathsList.setList(Collections.singletonList("(unfiled)"));
                                            } else {
                                                ObjectPanel.this.pathsList.setList(paths);
                                            }
                                        }
                                        catch (Exception e) {
                                            ObjectPanel.this.pathsList.setList(Collections.singletonList("(???)"));
                                        }
                                        ObjectPanel.this.revalidate();
                                    }
                                });
                            }
                        } else {
                            ObjectPanel.this.pathsList.setList(Collections.singletonList("(not filable)"));
                        }
                        String docUrl = ObjectPanel.this.getDocumentURL(object, ObjectPanel.this.getClientModel().getClientSession().getSession());
                        if (docUrl != null) {
                            ObjectPanel.this.contentUrlField.setText(docUrl);
                        } else {
                            ObjectPanel.this.contentUrlField.setText("(not available)");
                        }
                        if (object.getAllowableActions() != null) {
                            ObjectPanel.this.allowableActionsList.setList(object.getAllowableActions().getAllowableActions());
                        } else {
                            ObjectPanel.this.allowableActionsList.setList(Collections.singletonList("(missing)"));
                        }
                        if (object.getAcl() == null) {
                            ObjectPanel.this.aclExactField.setText("(no ACL)");
                        } else if (object.getAcl().isExact() == null) {
                            ObjectPanel.this.aclExactField.setText("exact flag not set");
                        } else if (object.getAcl().isExact().booleanValue()) {
                            ObjectPanel.this.aclExactField.setText("is exact");
                        } else {
                            ObjectPanel.this.aclExactField.setText("is not exact");
                        }
                        ObjectPanel.this.refreshButton.setEnabled(true);
                        ObjectPanel.this.checkButton.setEnabled(true);
                        ObjectPanel.this.consoleButton.setEnabled(true);
                        if (object instanceof Document) {
                            String name = object.getName().toLowerCase(Locale.ENGLISH);
                            int x = name.lastIndexOf(46);
                            if (x > -1 && ObjectPanel.this.scriptExtensions.contains(name.substring(x + 1))) {
                                ObjectPanel.this.scriptPanel.setVisible(true);
                                ObjectPanel.this.scriptOutput.setVisible(false);
                            } else {
                                ObjectPanel.this.scriptPanel.setVisible(false);
                            }
                        }
                    }
                    catch (Exception e) {
                        ClientHelper.showError(ObjectPanel.this, e);
                    }
                }
                ObjectPanel.this.revalidate();
            }
        });
    }

    private void createGUI() {
        this.setupGUI();
        this.nameField = this.addLine("Name:", true);
        this.idField = this.addId("Id:");
        this.typeField = this.addLine("Type:");
        this.basetypeField = this.addBaseTypeLabel("Base Type:");
        this.secondaryTypesList = this.addComponent("Secondary Types:", new InfoPanel.InfoList());
        this.pathsList = this.addComponent("Paths:", new InfoPanel.InfoList());
        this.versionLabelField = this.addLine("Version Label:");
        this.pwcField = this.addId("PWC:");
        this.contentUrlField = this.addLink("Content URL:");
        this.allowableActionsList = this.addComponent("Allowable Actions:", new InfoPanel.InfoList());
        this.aclExactField = this.addLine("ACL:");
        this.buttonPanel = this.addComponent("", new JPanel(new BorderLayout()));
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        this.buttonPanel.setOpaque(false);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setEnabled(false);
        this.buttonPanel.add(this.refreshButton);
        this.checkButton = new JButton("Check specification compliance");
        this.checkButton.setEnabled(false);
        this.buttonPanel.add(this.checkButton);
        this.consoleButton = new JButton("Open console");
        this.consoleButton.setEnabled(false);
        this.buttonPanel.add(this.consoleButton);
        this.scriptPanel = this.addComponent("", new JPanel(new BorderLayout()));
        this.scriptPanel.setOpaque(false);
        this.scriptPanel.setVisible(false);
        JPanel scriptButtonPanel = new JPanel();
        scriptButtonPanel.setLayout(new BoxLayout(scriptButtonPanel, 2));
        scriptButtonPanel.setOpaque(false);
        this.scriptPanel.add((Component)scriptButtonPanel, "First");
        this.scriptOpenButton = new JButton("Open Script");
        scriptButtonPanel.add(this.scriptOpenButton);
        this.scriptRunButton = new JButton("Run Script");
        scriptButtonPanel.add(this.scriptRunButton);
        this.scriptOutput = new JTextArea(null, 1, 80);
        this.scriptOutput.setEditable(false);
        this.scriptOutput.setFont(Font.decode("Monospaced"));
        this.scriptOutput.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createTitledBorder("")));
        this.scriptOutputWriter = new JTextAreaWriter(this.scriptOutput);
        this.scriptPanel.add((Component)this.scriptOutput, "Center");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ObjectPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    ObjectPanel.this.getClientModel().reloadObject();
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                }
                finally {
                    ObjectPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.checkButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ObjectPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    HashMap<String, String> parameters = new HashMap<String, String>(ObjectPanel.this.getClientModel().getClientSession().getSessionParameters());
                    parameters.put("org.apache.chemistry.opencmis.session.repository.id", ObjectPanel.this.getClientModel().getRepositoryInfo().getId());
                    String objectId = ObjectPanel.this.getClientModel().getCurrentObject().getId();
                    ObjectComplianceTestGroup octg = new ObjectComplianceTestGroup(parameters, objectId);
                    octg.run();
                    ArrayList<CmisTestGroup> groups = new ArrayList<CmisTestGroup>();
                    groups.add((CmisTestGroup)octg);
                    SwingReport report = new SwingReport(null, 700, 500);
                    report.createReport(parameters, groups, null);
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                }
                finally {
                    ObjectPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.consoleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ObjectPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    ClientHelper.openConsole((Component)ObjectPanel.this, ObjectPanel.this.getClientModel(), ObjectPanel.this.createGroovySourceCode(ObjectPanel.this.getClientModel().getCurrentObject()));
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                }
                finally {
                    ObjectPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.scriptOpenButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ObjectPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    Document doc = (Document)ObjectPanel.this.getClientModel().getCurrentObject();
                    String name = doc.getName().toLowerCase(Locale.ENGLISH);
                    if (name.endsWith(".groovy")) {
                        File file = ClientHelper.createTempFileFromDocument((CmisObject)doc, null);
                        Console console = ClientHelper.openConsole((Component)ObjectPanel.this, ObjectPanel.this.getClientModel(), (String)null);
                        if (console != null) {
                            console.loadScriptFile(file);
                        }
                    } else {
                        ClientHelper.open(ObjectPanel.this, (CmisObject)doc, null);
                    }
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                }
                finally {
                    ObjectPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.scriptRunButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ObjectPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    Document doc = (Document)ObjectPanel.this.getClientModel().getCurrentObject();
                    File file = ClientHelper.createTempFileFromDocument((CmisObject)doc, null);
                    String name = doc.getName().toLowerCase(Locale.ENGLISH);
                    String ext = name.substring(name.lastIndexOf(46) + 1);
                    ObjectPanel.this.scriptOutput.setText("");
                    ObjectPanel.this.scriptOutput.setVisible(true);
                    ObjectPanel.this.scriptOutput.invalidate();
                    ClientHelper.runJSR223Script(ObjectPanel.this, ObjectPanel.this.getClientModel(), file, ext, ObjectPanel.this.scriptOutputWriter);
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                }
                finally {
                    ObjectPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    private String getDocumentURL(CmisObject document, Session session) {
        if (!(document instanceof Document)) {
            return null;
        }
        return ((Document)document).getContentUrl();
    }

    private String createGroovySourceCode(CmisObject object) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("import org.apache.chemistry.opencmis.commons.*\n");
        sb.append("import org.apache.chemistry.opencmis.commons.data.*\n");
        sb.append("import org.apache.chemistry.opencmis.commons.enums.*\n");
        sb.append("import org.apache.chemistry.opencmis.client.api.*\n\n");
        sb.append("// ");
        sb.append(object.getName());
        sb.append('\n');
        switch (object.getBaseTypeId()) {
            case CMIS_DOCUMENT: {
                sb.append("Document doc = (Document)");
                break;
            }
            case CMIS_FOLDER: {
                sb.append("Folder folder = (Folder)");
                break;
            }
            case CMIS_POLICY: {
                sb.append("Policy policy = (Policy)");
                break;
            }
            case CMIS_RELATIONSHIP: {
                sb.append("Relationship rel = (Relationship)");
                break;
            }
            case CMIS_ITEM: {
                sb.append("Item item = (Item)");
                break;
            }
            default: {
                sb.append("CmisObject obj =");
            }
        }
        sb.append(" session.getObject(\"");
        sb.append(object.getId().replaceAll("\"", "\\\""));
        sb.append("\");\n\n");
        return sb.toString();
    }

    private static class JTextAreaWriter
    extends Writer {
        private final JTextArea textArea;

        public JTextAreaWriter(JTextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            final String s = new String(cbuf, off, len);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTextAreaWriter.this.textArea.append(s);
                }
            });
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

