/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import java.awt.event.MouseEvent;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.details.AbstractDetailsTable;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class PolicyTable
extends AbstractDetailsTable {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Id"};
    private static final int[] COLUMN_WIDTHS = new int[]{200, 400};

    public PolicyTable(ClientModel model) {
        this.init(model, COLUMN_NAMES, COLUMN_WIDTHS);
    }

    @Override
    public void singleClickAction(MouseEvent e, int rowIndex, int colIndex) {
        if (this.getColumnClass(colIndex) != ObjectId.class) {
            return;
        }
        try {
            this.getClientModel().loadObject(((Policy)this.getObject().getPolicies().get(this.getRowSorter().convertRowIndexToModel(rowIndex))).getId());
            this.setTab(0);
        }
        catch (Exception ex) {
            ClientHelper.showError(this, ex);
        }
    }

    @Override
    public int getDetailRowCount() {
        if (this.getObject().getPolicies() == null) {
            return 0;
        }
        return this.getObject().getPolicies().size();
    }

    @Override
    public Object getDetailValueAt(int rowIndex, int columnIndex) {
        Policy policy = (Policy)this.getObject().getPolicies().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return policy.getName();
            }
            case 1: {
                return policy;
            }
        }
        return null;
    }

    @Override
    public Class<?> getDetailColumClass(int columnIndex) {
        if (columnIndex == 1) {
            return ObjectId.class;
        }
        return super.getDetailColumClass(columnIndex);
    }
}

