/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.workbench.PropertyEditorFrame;
import org.apache.chemistry.opencmis.workbench.details.AbstractDetailsTable;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.CollectionRenderer;

public class PropertyTable
extends AbstractDetailsTable {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Type", "Value", "Property ID", "Object Type ID"};
    private static final int[] COLUMN_WIDTHS = new int[]{200, 80, 400, 200, 200};

    public PropertyTable(ClientModel model) {
        this.init(model, COLUMN_NAMES, COLUMN_WIDTHS);
        this.setDefaultRenderer(Collection.class, new CollectionRenderer(true));
    }

    @Override
    public void doubleClickAction(MouseEvent e, int rowIndex) {
        if (this.getObject().hasAllowableAction(Action.CAN_UPDATE_PROPERTIES)) {
            new PropertyEditorFrame(this.getClientModel(), this.getObject());
        }
    }

    @Override
    public int getDetailRowCount() {
        return this.getObject().getProperties().size();
    }

    @Override
    public Object getDetailValueAt(int rowIndex, int columnIndex) {
        CmisObject obj = this.getObject();
        Property property = (Property)obj.getProperties().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return property.getDefinition().getDisplayName();
            }
            case 1: {
                return property.getDefinition().getPropertyType().value();
            }
            case 2: {
                return property.getValues();
            }
            case 3: {
                return property.getId();
            }
            case 4: {
                return this.findObjectType(obj, property.getId());
            }
        }
        return null;
    }

    @Override
    public Class<?> getDetailColumClass(int columnIndex) {
        if (columnIndex == 2) {
            return Collection.class;
        }
        return super.getDetailColumClass(columnIndex);
    }

    private String findObjectType(CmisObject obj, String propertyId) {
        List types = obj.findObjectType(propertyId);
        if (types == null || types.isEmpty()) {
            return "???";
        }
        StringBuilder sb = new StringBuilder(64);
        for (ObjectType type : types) {
            if (sb.length() > 0) {
                sb.append(" ,");
            }
            sb.append(type.getId());
        }
        return sb.toString();
    }
}

