/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import java.awt.event.MouseEvent;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.details.AbstractDetailsTable;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class RelationshipTable
extends AbstractDetailsTable {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Type", "Relationship Id", "Source", "Target"};
    private static final int[] COLUMN_WIDTHS = new int[]{200, 200, 200, 200, 200};

    public RelationshipTable(ClientModel model) {
        this.init(model, COLUMN_NAMES, COLUMN_WIDTHS);
    }

    @Override
    public void singleClickAction(MouseEvent e, int rowIndex, int colIndex) {
        if (this.getColumnClass(colIndex) != ObjectId.class) {
            return;
        }
        ObjectId id = (ObjectId)this.getValueAt(rowIndex, colIndex);
        if (id == null || id.getId() == null) {
            return;
        }
        try {
            this.getClientModel().loadObject(id.getId());
            this.setTab(0);
        }
        catch (Exception ex) {
            ClientHelper.showError(this, ex);
        }
    }

    @Override
    public int getDetailRowCount() {
        if (this.getObject().getRelationships() == null) {
            return 0;
        }
        return this.getObject().getRelationships().size();
    }

    @Override
    public Object getDetailValueAt(int rowIndex, int columnIndex) {
        Relationship relationship = (Relationship)this.getObject().getRelationships().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return relationship.getName();
            }
            case 1: {
                return relationship.getType().getId();
            }
            case 2: {
                return relationship;
            }
            case 3: {
                return relationship.getSourceId();
            }
            case 4: {
                return relationship.getTarget();
            }
        }
        return null;
    }

    @Override
    public Class<?> getDetailColumClass(int columnIndex) {
        if (columnIndex == 2 || columnIndex == 3 || columnIndex == 4) {
            return ObjectId.class;
        }
        return super.getDetailColumClass(columnIndex);
    }
}

