/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import java.awt.event.MouseEvent;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.details.AbstractDetailsTable;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class RenditionTable
extends AbstractDetailsTable {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"Title", "Kind", "MIME Type", "Size", "Stream Id"};
    private static final int[] COLUMN_WIDTHS = new int[]{200, 200, 80, 80, 200};

    public RenditionTable(ClientModel model) {
        this.init(model, COLUMN_NAMES, COLUMN_WIDTHS);
    }

    @Override
    public void doubleClickAction(MouseEvent e, int rowIndex) {
        String streamId = ((Rendition)this.getObject().getRenditions().get(this.getRowSorter().convertRowIndexToModel(rowIndex))).getStreamId();
        if (e.isShiftDown()) {
            ClientHelper.download(this.getParent(), this.getObject(), streamId);
        } else {
            ClientHelper.open(this.getParent(), this.getObject(), streamId);
        }
    }

    @Override
    public int getDetailRowCount() {
        if (this.getObject().getRenditions() == null) {
            return 0;
        }
        return this.getObject().getRenditions().size();
    }

    @Override
    public Object getDetailValueAt(int rowIndex, int columnIndex) {
        Rendition rendition = (Rendition)this.getObject().getRenditions().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rendition.getTitle();
            }
            case 1: {
                return rendition.getKind();
            }
            case 2: {
                return rendition.getMimeType();
            }
            case 3: {
                return rendition.getLength();
            }
            case 4: {
                return rendition.getStreamId();
            }
        }
        return null;
    }
}

