/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingUtilities;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.details.AbstractDetailsTable;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;

public class VersionTable
extends AbstractDetailsTable {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Label", "Latest", "Major", "Latest Major", "Id", "Filename", "MIME Type", "Length"};
    private static final int[] COLUMN_WIDTHS = new int[]{200, 200, 50, 50, 50, 400, 200, 100, 100};
    private List<Document> versions;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public VersionTable(ClientModel model) {
        this.versions = Collections.emptyList();
        this.init(model, COLUMN_NAMES, COLUMN_WIDTHS);
    }

    @Override
    public void objectLoaded(ClientModelEvent event) {
        this.lock.writeLock().lock();
        try {
            this.versions = Collections.emptyList();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.getObject() instanceof Document) {
            boolean fetchVersions;
            final Document doc = (Document)this.getObject();
            boolean bl = fetchVersions = this.getObject().getAllowableActions() == null || this.getObject().getAllowableActions().getAllowableActions() == null || doc.hasAllowableAction(Action.CAN_GET_ALL_VERSIONS);
            if (fetchVersions) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VersionTable.this.setCursor(Cursor.getPredefinedCursor(3));
                            List newVersions = doc.getAllVersions(VersionTable.this.getClientModel().getClientSession().getVersionOperationContext());
                            VersionTable.this.lock.writeLock().lock();
                            try {
                                VersionTable.this.versions = newVersions;
                            }
                            finally {
                                VersionTable.this.lock.writeLock().unlock();
                            }
                        }
                        catch (Exception ex) {
                            if (!(ex instanceof CmisNotSupportedException)) {
                                ClientHelper.showError(null, ex);
                            }
                        }
                        finally {
                            VersionTable.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                        ((AbstractDetailsTable.DetailsTableModel)VersionTable.this.getModel()).fireTableDataChanged();
                    }
                });
            }
        }
        super.objectLoaded(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void singleClickAction(MouseEvent e, int rowIndex, int colIndex) {
        if (this.getColumnClass(colIndex) != ObjectId.class) {
            return;
        }
        String versionId = null;
        this.lock.readLock().lock();
        try {
            versionId = this.versions.get(this.getRowSorter().convertRowIndexToModel(rowIndex)).getId();
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            this.getClientModel().loadObject(versionId);
            this.setTab(0);
        }
        catch (Exception ex) {
            ClientHelper.showError(this, ex);
        }
    }

    @Override
    public void doubleClickAction(MouseEvent e, int rowIndex) {
        this.lock.readLock().lock();
        try {
            if (e.isShiftDown()) {
                ClientHelper.download(this.getParent(), (CmisObject)this.versions.get(this.getRowSorter().convertRowIndexToModel(rowIndex)), null);
            } else {
                ClientHelper.open(this.getParent(), (CmisObject)this.versions.get(this.getRowSorter().convertRowIndexToModel(rowIndex)), null);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getDetailRowCount() {
        if (!(this.getObject() instanceof Document)) {
            return 0;
        }
        this.lock.readLock().lock();
        try {
            int n = this.versions.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getDetailValueAt(int rowIndex, int columnIndex) {
        Document version = null;
        this.lock.readLock().lock();
        try {
            version = this.versions.get(rowIndex);
        }
        finally {
            this.lock.readLock().unlock();
        }
        switch (columnIndex) {
            case 0: {
                return version.getName();
            }
            case 1: {
                return version.getVersionLabel();
            }
            case 2: {
                return version.isLatestVersion();
            }
            case 3: {
                return version.isMajorVersion();
            }
            case 4: {
                return version.isLatestMajorVersion();
            }
            case 5: {
                return version;
            }
            case 6: {
                return version.getContentStreamFileName();
            }
            case 7: {
                return version.getContentStreamMimeType();
            }
            case 8: {
                return version.getContentStreamLength() == -1L ? null : Long.valueOf(version.getContentStreamLength());
            }
        }
        return null;
    }

    @Override
    public Class<?> getDetailColumClass(int columnIndex) {
        if (columnIndex == 2 || columnIndex == 3 || columnIndex == 4) {
            return Boolean.class;
        }
        if (columnIndex == 5) {
            return ObjectId.class;
        }
        if (columnIndex == 8) {
            return Long.class;
        }
        return super.getDetailColumClass(columnIndex);
    }
}

