/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.icons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;

public abstract class AbstractWorkbenchIcon
implements Icon {
    protected static final Color DEFAULT_COLOR = new Color(3367564);
    protected static final Color DISABLED_COLOR = new Color(9342865);
    protected int width;
    protected int height;
    protected boolean enabled = true;
    protected Map<Integer, BufferedImage> images = new HashMap<Integer, BufferedImage>();

    public AbstractWorkbenchIcon() {
        this(true);
    }

    public AbstractWorkbenchIcon(boolean enabled) {
        this.enabled = enabled;
        this.width = WorkbenchScale.isScaling() ? (int)((float)this.getOrginalWidth() * WorkbenchScale.getScaleFactor()) : this.getOrginalWidth();
        this.height = WorkbenchScale.isScaling() ? (int)((float)this.getOrginalHeight() * WorkbenchScale.getScaleFactor()) : this.getOrginalHeight();
    }

    public AbstractWorkbenchIcon(int width, int height) {
        this(width, height, true);
    }

    public AbstractWorkbenchIcon(int width, int height, boolean enabled) {
        this.enabled = enabled;
        this.width = WorkbenchScale.isScaling() ? (int)((float)width * WorkbenchScale.getScaleFactor()) : width;
        this.height = WorkbenchScale.isScaling() ? (int)((float)height * WorkbenchScale.getScaleFactor()) : height;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        double scaleD = g2d.getFontRenderContext().getTransform().getScaleX();
        int scaleP = (int)(scaleD * 100.0);
        BufferedImage image = null;
        AbstractWorkbenchIcon abstractWorkbenchIcon = this;
        synchronized (abstractWorkbenchIcon) {
            image = this.images.get(scaleP);
            if (image == null) {
                image = this.renderIcon(scaleD);
                this.images.put(scaleP, image);
            }
        }
        if (scaleP != 100) {
            g2d.scale(1.0 / scaleD, 1.0 / scaleD);
            g2d.drawImage((Image)image, (int)((double)x * scaleD), (int)((double)y * scaleD), c);
        } else {
            g2d.drawImage((Image)image, x, y, c);
        }
    }

    @Override
    public final int getIconHeight() {
        return this.height;
    }

    @Override
    public final int getIconWidth() {
        return this.width;
    }

    protected Color getColor() {
        return this.enabled ? DEFAULT_COLOR : DISABLED_COLOR;
    }

    protected abstract int getOrginalHeight();

    protected abstract int getOrginalWidth();

    protected abstract void paint(Graphics2D var1);

    protected void paintPlusBadge(Graphics2D g, Color color) {
        GeneralPath shape = new GeneralPath();
        shape.moveTo(59.82887, 47.315468);
        shape.lineTo(55.657738, 47.315468);
        shape.lineTo(55.657738, 43.144333);
        shape.curveTo(55.657738, 40.840477, 53.790462, 38.9732, 51.486603, 38.9732);
        shape.curveTo(49.182747, 38.9732, 47.31547, 40.840477, 47.31547, 43.144333);
        shape.lineTo(47.31547, 47.315468);
        shape.lineTo(43.144337, 47.315468);
        shape.curveTo(40.84048, 47.315468, 38.973206, 49.182743, 38.973206, 51.4866);
        shape.curveTo(38.973206, 53.790455, 40.84048, 55.657734, 43.144337, 55.657734);
        shape.lineTo(47.31547, 55.657734);
        shape.lineTo(47.31547, 59.828865);
        shape.curveTo(47.315468, 62.132725, 49.182747, 64.0, 51.4866, 64.0);
        shape.curveTo(53.790455, 64.0, 55.657734, 62.132725, 55.657734, 59.828865);
        shape.lineTo(55.657734, 55.65773);
        shape.lineTo(59.828865, 55.65773);
        shape.curveTo(62.132725, 55.657734, 64.0, 53.79046, 64.0, 51.4866);
        shape.curveTo(64.0, 49.182747, 62.132725, 47.315468, 59.82887, 47.315468);
        shape.closePath();
        g.setPaint(color);
        g.fill(shape);
    }

    private final BufferedImage renderIcon(double factor) {
        BufferedImage img = new BufferedImage((int)Math.round((double)this.getIconWidth() * factor), (int)Math.round((double)this.getIconHeight() * factor), 2);
        double coef = Math.min((double)this.getIconWidth() * factor / (double)this.getOrginalWidth(), (double)this.getIconHeight() * factor / (double)this.getOrginalHeight());
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.scale(coef, coef);
        this.paint(g2d);
        g2d.dispose();
        return img;
    }
}

