/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.model;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.MimeTypes;
import org.apache.chemistry.opencmis.workbench.LoggingInputStream;
import org.apache.chemistry.opencmis.workbench.RandomInputStream;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;
import org.apache.chemistry.opencmis.workbench.model.ClientSession;
import org.apache.chemistry.opencmis.workbench.model.FolderListener;
import org.apache.chemistry.opencmis.workbench.model.ObjectListener;

public class ClientModel {
    private static final long OLD = 60000L;
    private ClientSession clientSession;
    private Folder currentFolder = null;
    private List<CmisObject> currentChildren = Collections.emptyList();
    private CmisObject currentObject = null;
    private List<ObjectType> baseTypes = null;
    private final EventListenerList listenerList = new EventListenerList();

    public void addFolderListener(FolderListener listener) {
        this.listenerList.add(FolderListener.class, listener);
    }

    public void removeFolderListener(FolderListener listener) {
        this.listenerList.remove(FolderListener.class, listener);
    }

    public void addObjectListener(ObjectListener listener) {
        this.listenerList.add(ObjectListener.class, listener);
    }

    public void removeObjectListener(ObjectListener listener) {
        this.listenerList.remove(ObjectListener.class, listener);
    }

    public synchronized void setClientSession(ClientSession clientSession) {
        this.clientSession = clientSession;
        this.currentFolder = null;
        this.currentChildren = Collections.emptyList();
        this.currentObject = null;
        this.baseTypes = null;
    }

    public synchronized ClientSession getClientSession() {
        return this.clientSession;
    }

    public synchronized RepositoryInfo getRepositoryInfo() {
        Session session = this.clientSession.getSession();
        return session.getRepositoryInfo();
    }

    public synchronized String getRepositoryName() {
        try {
            return this.getRepositoryInfo().getName();
        }
        catch (Exception e) {
            return "?";
        }
    }

    public synchronized boolean supportsQuery() {
        try {
            RepositoryCapabilities cap = this.getRepositoryInfo().getCapabilities();
            if (cap == null) {
                return true;
            }
            return cap.getQueryCapability() != null && cap.getQueryCapability() != CapabilityQuery.NONE;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized boolean supportsChangeLog() {
        try {
            RepositoryCapabilities cap = this.getRepositoryInfo().getCapabilities();
            if (cap == null) {
                return true;
            }
            return cap.getChangesCapability() != null && cap.getChangesCapability() != CapabilityChanges.NONE;
        }
        catch (Exception e) {
            return false;
        }
    }

    private synchronized void loadBaseTypes() {
        if (this.baseTypes != null) {
            return;
        }
        this.baseTypes = new ArrayList<ObjectType>();
        for (ObjectType type : this.clientSession.getSession().getTypeChildren(null, false)) {
            this.baseTypes.add(type);
        }
    }

    public synchronized boolean supportsItems() {
        this.loadBaseTypes();
        for (ObjectType type : this.baseTypes) {
            if (type.getBaseTypeId() != BaseTypeId.CMIS_ITEM) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean supportsRelationships() {
        this.loadBaseTypes();
        for (ObjectType type : this.baseTypes) {
            if (type.getBaseTypeId() != BaseTypeId.CMIS_RELATIONSHIP) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean supportsPolicies() {
        this.loadBaseTypes();
        for (ObjectType type : this.baseTypes) {
            if (type.getBaseTypeId() != BaseTypeId.CMIS_POLICY) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized ObjectId loadFolder(String folderId, boolean byPath) {
        try {
            Session session = this.clientSession.getSession();
            CmisObject selectedObject = null;
            CmisObject folderObject = null;
            selectedObject = byPath ? session.getObjectByPath(folderId) : session.getObject(folderId);
            if (selectedObject instanceof Folder) {
                folderObject = selectedObject;
            } else {
                if (!(selectedObject instanceof FileableCmisObject)) {
                    this.setCurrentFolder(null, new ArrayList<CmisObject>(0));
                    return selectedObject;
                }
                List parents = ((FileableCmisObject)selectedObject).getParents();
                if (!CollectionsHelper.isNotEmpty((Collection)parents)) {
                    this.setCurrentFolder(null, new ArrayList<CmisObject>(0));
                    return selectedObject;
                }
                folderObject = (CmisObject)parents.get(0);
            }
            ArrayList<CmisObject> children = new ArrayList<CmisObject>();
            if (this.clientSession.getMaxChildren() != 0) {
                ItemIterable iter = ((Folder)folderObject).getChildren(this.clientSession.getFolderOperationContext());
                if (this.clientSession.getMaxChildren() > 0) {
                    iter = iter.getPage(this.clientSession.getMaxChildren());
                }
                for (CmisObject child : iter) {
                    children.add(child);
                }
            }
            this.setCurrentFolder((Folder)folderObject, children);
            return selectedObject;
        }
        catch (CmisBaseException ex) {
            this.setCurrentFolder(null, new ArrayList<CmisObject>(0));
            throw ex;
        }
    }

    public synchronized void reloadFolder() {
        if (this.currentFolder != null) {
            this.loadFolder(this.currentFolder.getId(), false);
        }
    }

    public synchronized void loadObject(String objectId) {
        try {
            Session session = this.clientSession.getSession();
            CmisObject object = session.getObject(objectId, this.clientSession.getObjectOperationContext());
            object.refreshIfOld(60000L);
            this.setCurrentObject(object);
        }
        catch (CmisBaseException ex) {
            this.setCurrentObject(null);
            throw ex;
        }
    }

    public synchronized void reloadObject() {
        if (this.currentObject == null) {
            return;
        }
        try {
            Session session = this.clientSession.getSession();
            CmisObject object = session.getObject((ObjectId)this.currentObject, this.clientSession.getObjectOperationContext());
            object.refresh();
            this.setCurrentObject(object);
        }
        catch (CmisBaseException ex) {
            this.setCurrentObject(null);
            throw ex;
        }
    }

    public synchronized ItemIterable<QueryResult> query(String q, boolean searchAllVersions, int maxHits) {
        OperationContextImpl queryContext = new OperationContextImpl(null, false, false, false, IncludeRelationships.NONE, null, false, null, false, maxHits > 0 ? maxHits : 1);
        Session session = this.clientSession.getSession();
        return session.query(q, searchAllVersions, (OperationContext)queryContext);
    }

    public synchronized List<Tree<ObjectType>> getTypeDescendants() {
        Session session = this.clientSession.getSession();
        return session.getTypeDescendants(null, -1, true);
    }

    public ContentStream createContentStream(String filename) throws FileNotFoundException {
        ContentStream content = null;
        if (filename != null && filename.length() > 0) {
            File file = new File(filename);
            LoggingInputStream stream = new LoggingInputStream(new BufferedInputStream(new FileInputStream(file), 524288), file.getName());
            content = this.clientSession.getSession().getObjectFactory().createContentStream(file.getName(), file.length(), MimeTypes.getMIMEType((File)file), (InputStream)stream);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectId createDocument(String name, String type, String filename, Map<String, Object> additionalProperties, VersioningState versioningState, boolean unfiled) throws FileNotFoundException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", type);
        if (additionalProperties != null) {
            properties.putAll(additionalProperties);
        }
        ContentStream content = this.createContentStream(filename);
        try {
            ObjectId objectId = this.clientSession.getSession().createDocument(properties, (ObjectId)(unfiled ? null : this.currentFolder), content, versioningState, null, null, null);
            return objectId;
        }
        finally {
            IOUtils.closeQuietly((ContentStream)content);
        }
    }

    public ContentStream createContentStream(String name, long length, long seed) {
        return this.clientSession.getSession().getObjectFactory().createContentStream(name, length, "application/octet-stream", (InputStream)new LoggingInputStream(new RandomInputStream(length, seed), name + " (random)"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectId createDocument(String name, String type, Map<String, Object> additionalProperties, long length, long seed, VersioningState versioningState, boolean unfiled) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", type);
        if (additionalProperties != null) {
            properties.putAll(additionalProperties);
        }
        ContentStream content = this.createContentStream(name, length, seed);
        try {
            ObjectId objectId = this.clientSession.getSession().createDocument(properties, (ObjectId)(unfiled ? null : this.currentFolder), content, versioningState, null, null, null);
            return objectId;
        }
        finally {
            IOUtils.closeQuietly((ContentStream)content);
        }
    }

    public synchronized ObjectId createItem(String name, String type, Map<String, Object> additionalProperties, boolean unfiled) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", type);
        if (additionalProperties != null) {
            properties.putAll(additionalProperties);
        }
        return this.clientSession.getSession().createItem(properties, (ObjectId)(unfiled ? null : this.currentFolder), null, null, null);
    }

    public synchronized ObjectId createFolder(String name, String type, Map<String, Object> additionalProperties) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", type);
        if (additionalProperties != null) {
            properties.putAll(additionalProperties);
        }
        return this.clientSession.getSession().createFolder(properties, (ObjectId)this.currentFolder, null, null, null);
    }

    public synchronized ObjectId createRelationship(String name, String type, String sourceId, String targetId, Map<String, Object> additionalProperties) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", type);
        properties.put("cmis:sourceId", sourceId);
        properties.put("cmis:targetId", targetId);
        if (additionalProperties != null) {
            properties.putAll(additionalProperties);
        }
        return this.clientSession.getSession().createRelationship(properties, null, null, null);
    }

    public synchronized ObjectId createPolicy(String name, String type, String policyText, Map<String, Object> additionalProperties, boolean unfiled) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", type);
        if (policyText != null && policyText.length() > 0) {
            properties.put("cmis:policyText", policyText);
        }
        if (additionalProperties != null) {
            properties.putAll(additionalProperties);
        }
        return this.clientSession.getSession().createPolicy(properties, (ObjectId)(unfiled ? null : this.currentFolder), null, null, null);
    }

    public synchronized List<ObjectType> getTypesAsList(String rootTypeId, boolean creatableOnly) {
        ArrayList<ObjectType> result = new ArrayList<ObjectType>();
        ObjectType rootType = null;
        try {
            rootType = this.clientSession.getSession().getTypeDefinition(rootTypeId);
        }
        catch (CmisBaseException e) {
            return result;
        }
        List types = this.clientSession.getSession().getTypeDescendants(rootTypeId, -1, true);
        this.addType(types, result, creatableOnly);
        if (creatableOnly) {
            boolean isCreatable;
            boolean bl = isCreatable = rootType.isCreatable() == null ? true : rootType.isCreatable();
            if (isCreatable) {
                result.add(rootType);
            }
        } else {
            result.add(rootType);
        }
        Collections.sort(result, new Comparator<ObjectType>(){

            @Override
            public int compare(ObjectType ot1, ObjectType ot2) {
                return ot1.getDisplayName().compareTo(ot2.getDisplayName());
            }
        });
        return result;
    }

    private void addType(List<Tree<ObjectType>> types, List<ObjectType> resultList, boolean creatableOnly) {
        assert (types != null);
        assert (resultList != null);
        for (Tree<ObjectType> tt : types) {
            if (tt.getItem() == null) continue;
            if (creatableOnly) {
                boolean isCreatable;
                boolean bl = isCreatable = ((ObjectType)tt.getItem()).isCreatable() == null ? true : ((ObjectType)tt.getItem()).isCreatable();
                if (isCreatable) {
                    resultList.add((ObjectType)tt.getItem());
                }
            } else {
                resultList.add((ObjectType)tt.getItem());
            }
            this.addType(tt.getChildren(), resultList, creatableOnly);
        }
    }

    public synchronized Folder getCurrentFolder() {
        return this.currentFolder;
    }

    public synchronized List<CmisObject> getCurrentChildren() {
        return this.currentChildren;
    }

    public synchronized CmisObject getFromCurrentChildren(String id) {
        if (CollectionsHelper.isNullOrEmpty(this.currentChildren)) {
            return null;
        }
        for (CmisObject o : this.currentChildren) {
            if (!o.getId().equals(id)) continue;
            return o;
        }
        return null;
    }

    private synchronized void setCurrentFolder(Folder folder, List<CmisObject> children) {
        this.currentFolder = folder;
        this.currentChildren = children;
        for (FolderListener fl : (FolderListener[])this.listenerList.getListeners(FolderListener.class)) {
            fl.folderLoaded(new ClientModelEvent(this));
        }
    }

    public synchronized CmisObject getCurrentObject() {
        return this.currentObject;
    }

    private synchronized void setCurrentObject(CmisObject object) {
        this.currentObject = object;
        for (ObjectListener ol : (ObjectListener[])this.listenerList.getListeners(ObjectListener.class)) {
            ol.objectLoaded(new ClientModelEvent(this));
        }
    }
}

