/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.model;

import java.util.Map;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;

public final class ClientOperationContext
extends OperationContextImpl {
    private static final long serialVersionUID = 1L;
    public static final String FILTER = "filter";
    public static final String INCLUDE_ACLS = "includeAcls";
    public static final String INCLUDE_ALLOWABLE_ACTIONS = "includeAllowableActions";
    public static final String INCLUDE_POLICIES = "includePolicies";
    public static final String INCLUDE_RELATIONSHIPS = "includeRelationships";
    public static final String RENDITION_FILTER = "renditionFilter";
    public static final String ORDER_BY = "orderBy";
    public static final String MAX_ITEMS_PER_PAGE = "maxItemsPerPage";

    public ClientOperationContext(String prefix, Map<String, String> map) {
        this.loadContext(prefix, map);
        this.setIncludePathSegments(false);
        this.setCacheEnabled(true);
    }

    public void loadContext(String prefix, Map<String, String> map) {
        this.setFilterString(map.get(prefix + FILTER));
        this.setIncludeAcls(this.parseBoolean(map.get(prefix + INCLUDE_ACLS), false));
        this.setIncludeAllowableActions(this.parseBoolean(map.get(prefix + INCLUDE_ALLOWABLE_ACTIONS), false));
        this.setIncludePolicies(this.parseBoolean(map.get(prefix + INCLUDE_POLICIES), false));
        this.setIncludeRelationships(this.parseIncludeRelationships(map.get(prefix + INCLUDE_RELATIONSHIPS), IncludeRelationships.NONE));
        this.setRenditionFilterString(map.get(prefix + RENDITION_FILTER));
        this.setOrderBy(map.get(prefix + ORDER_BY));
        this.setMaxItemsPerPage(this.parseInteger(map.get(prefix + MAX_ITEMS_PER_PAGE), 1000));
    }

    private boolean parseBoolean(String s, boolean defaultValue) {
        return s == null ? defaultValue : Boolean.parseBoolean(s);
    }

    private IncludeRelationships parseIncludeRelationships(String s, IncludeRelationships defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return IncludeRelationships.fromValue((String)s);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private int parseInteger(String s, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

