/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.model;

import java.net.Authenticator;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.chemistry.opencmis.client.SessionParameterMap;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.cache.TypeDefinitionCache;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.client.runtime.cache.Cache;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.chemistry.opencmis.workbench.model.ClientOperationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSession {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSession.class);
    public static final String WORKBENCH_PREFIX = "cmis.workbench.";
    public static final String OBJECT_PREFIX = "cmis.workbench.object.";
    public static final String FOLDER_PREFIX = "cmis.workbench.folder.";
    public static final String VERSION_PREFIX = "cmis.workbench.version.";
    public static final String ACCEPT_SELF_SIGNED_CERTIFICATES = "cmis.workbench.acceptSelfSignedCertificates";
    public static final String MAX_FOLDER_CHILDREN = "cmis.workbench.folder.maxChildren";
    private static final Set<String> FOLDER_PROPERTY_SET = new HashSet<String>();
    private static final Set<String> VERSION_PROPERTY_SET;
    private Map<String, String> sessionParameters;
    private List<Repository> repositories;
    private Session session;
    private OperationContext objectOperationContext;
    private OperationContext folderOperationContext;
    private OperationContext versionOperationContext;
    private int maxChildren;
    private String startFolderId;

    public ClientSession(Map<String, String> sessionParameters, ObjectFactory objectFactory, AuthenticationProvider authenticationProvider, Cache cache, TypeDefinitionCache typeDefCache) {
        if (sessionParameters == null) {
            throw new IllegalArgumentException("Parameters must not be null!");
        }
        this.connect(sessionParameters, objectFactory, authenticationProvider, cache, typeDefCache);
    }

    public static SessionParameterMap createSessionParameters(String url, BindingType binding, String username, String password, Authentication authentication, boolean compression, boolean clientCompression, boolean cookies, String csrfHeader, long connectionTimeout, long readTimeout) {
        String ch;
        SessionParameterMap parameters = new SessionParameterMap();
        switch (binding) {
            case WEBSERVICES: {
                parameters.setWebServicesBindingUrl(url);
                break;
            }
            case ATOMPUB: {
                parameters.setAtomPubBindingUrl(url);
                break;
            }
            case BROWSER: {
                parameters.setBrowserBindingUrl(url);
                break;
            }
            default: {
                parameters.put((Object)"org.apache.chemistry.opencmis.binding.spi.type", (Object)BindingType.CUSTOM.value());
            }
        }
        switch (authentication) {
            case STANDARD: {
                parameters.setUsernameTokenAuthentication(username, password, true);
                break;
            }
            case NTLM: {
                parameters.setNtlmAuthentication(username, password);
                break;
            }
            case OAUTH_BEARER: {
                parameters.setOAuthBearerTokenAuthentication(username);
                break;
            }
            default: {
                parameters.setNoAuthentication();
            }
        }
        parameters.setCompression(compression);
        parameters.setClientCompression(clientCompression);
        parameters.setCookies(cookies);
        if (csrfHeader != null && (ch = csrfHeader.trim()).length() > 0) {
            parameters.setCsrfHeader(ch);
        }
        if (connectionTimeout > 0L) {
            parameters.setConnectionTimeout(connectionTimeout);
        } else {
            parameters.setConnectionTimeout(0L);
        }
        if (readTimeout > 0L) {
            parameters.setReadTimeout(readTimeout);
        } else {
            parameters.setReadTimeout(0L);
        }
        Properties sysProps = System.getProperties();
        for (String key : sysProps.stringPropertyNames()) {
            if (!key.startsWith(WORKBENCH_PREFIX)) continue;
            parameters.put((Object)key, (Object)sysProps.getProperty(key));
        }
        if (url != null) {
            String proxyUser;
            String urlLower = url.trim().toLowerCase(Locale.ENGLISH);
            if (urlLower.startsWith("http://")) {
                proxyUser = System.getProperty("http.proxyUser");
                if (proxyUser != null) {
                    String proxyPassword = System.getProperty("http.proxyPassword");
                    parameters.setProxyUserAndPassword(proxyUser, proxyPassword);
                }
            } else if (urlLower.startsWith("https://") && (proxyUser = System.getProperty("https.proxyUser")) != null) {
                String proxyPassword = System.getProperty("https.proxyPassword");
                parameters.setProxyUserAndPassword(proxyUser, proxyPassword);
            }
        }
        return parameters;
    }

    private void connect(Map<String, String> sessionParameters, ObjectFactory objectFactory, AuthenticationProvider authenticationProvider, Cache cache, TypeDefinitionCache typeDefCache) {
        this.sessionParameters = sessionParameters;
        Authenticator.setDefault(new Authenticator(){});
        if (Boolean.parseBoolean(sessionParameters.get(ACCEPT_SELF_SIGNED_CERTIFICATES))) {
            this.acceptSelfSignedCertificates();
        }
        this.maxChildren = -1;
        String maxChildrenStr = sessionParameters.get(MAX_FOLDER_CHILDREN);
        if (maxChildrenStr != null) {
            try {
                this.maxChildren = Integer.valueOf(maxChildrenStr.trim());
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid {} parameter!", (Object)MAX_FOLDER_CHILDREN, (Object)e);
            }
        }
        this.repositories = SessionFactoryImpl.newInstance().getRepositories(sessionParameters, objectFactory, authenticationProvider, cache, typeDefCache);
    }

    public List<Repository> getRepositories() {
        return this.repositories;
    }

    public synchronized Session createSession(int index) {
        this.session = this.repositories.get(index).createSession();
        this.objectOperationContext = null;
        this.folderOperationContext = null;
        this.versionOperationContext = null;
        return this.getSession();
    }

    public Session getSession() {
        return this.session;
    }

    public Map<String, String> getSessionParameters() {
        return Collections.unmodifiableMap(this.sessionParameters);
    }

    public void setStartFolderId(String startFolderId) {
        this.startFolderId = startFolderId;
    }

    public String getStartFolderId() {
        if (this.startFolderId != null) {
            return this.startFolderId;
        }
        return this.getSession().getRepositoryInfo().getRootFolderId();
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public synchronized OperationContext getObjectOperationContext() {
        if (this.objectOperationContext == null) {
            this.createOperationContexts();
        }
        return this.objectOperationContext;
    }

    public synchronized OperationContext getFolderOperationContext() {
        if (this.folderOperationContext == null) {
            this.createOperationContexts();
        }
        return this.folderOperationContext;
    }

    public synchronized OperationContext getVersionOperationContext() {
        if (this.versionOperationContext == null) {
            this.createOperationContexts();
        }
        return this.versionOperationContext;
    }

    private void createOperationContexts() {
        PropertyDefinition propDef;
        StringBuilder filter;
        ObjectType type;
        RepositoryInfo repositoryInfo = this.getSession().getRepositoryInfo();
        String supportsAcl = "true";
        if (repositoryInfo != null && repositoryInfo.getCapabilities() != null && repositoryInfo.getCapabilities().getAclCapability() == CapabilityAcl.NONE) {
            supportsAcl = "false";
        }
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "filter", "*");
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "includeAcls", supportsAcl);
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "includeAllowableActions", "true");
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "includePolicies", "true");
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "includeRelationships", IncludeRelationships.BOTH.value());
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "renditionFilter", "*");
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "orderBy", null);
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "maxItemsPerPage", "1000");
        this.objectOperationContext = new ClientOperationContext(OBJECT_PREFIX, this.sessionParameters);
        if (!this.sessionParameters.containsKey("cmis.workbench.folder.filter")) {
            type = this.session.getTypeDefinition(BaseTypeId.CMIS_DOCUMENT.value());
            filter = new StringBuilder(128);
            for (String propId : FOLDER_PROPERTY_SET) {
                propDef = (PropertyDefinition)type.getPropertyDefinitions().get(propId);
                if (propDef == null) continue;
                if (filter.length() > 0) {
                    filter.append(',');
                }
                filter.append(propDef.getQueryName());
            }
            this.sessionParameters.put("cmis.workbench.folder.filter", filter.toString());
        }
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "includeAcls", "false");
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "includeAllowableActions", "false");
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "includePolicies", "false");
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "includeRelationships", IncludeRelationships.NONE.value());
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "renditionFilter", "cmis:none");
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "orderBy", null);
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "maxItemsPerPage", "10000");
        this.folderOperationContext = new ClientOperationContext(FOLDER_PREFIX, this.sessionParameters);
        if (!this.sessionParameters.containsKey("cmis.workbench.version.filter")) {
            type = this.session.getTypeDefinition(BaseTypeId.CMIS_DOCUMENT.value());
            filter = new StringBuilder(128);
            for (String propId : VERSION_PROPERTY_SET) {
                propDef = (PropertyDefinition)type.getPropertyDefinitions().get(propId);
                if (propDef == null) continue;
                if (filter.length() > 0) {
                    filter.append(',');
                }
                filter.append(propDef.getQueryName());
            }
            this.sessionParameters.put("cmis.workbench.version.filter", filter.toString());
        }
        this.setDefault(VERSION_PREFIX, this.sessionParameters, "includeAcls", "false");
        this.setDefault(VERSION_PREFIX, this.sessionParameters, "includeAllowableActions", "false");
        this.setDefault(VERSION_PREFIX, this.sessionParameters, "includePolicies", "false");
        this.setDefault(VERSION_PREFIX, this.sessionParameters, "includeRelationships", IncludeRelationships.NONE.value());
        this.setDefault(VERSION_PREFIX, this.sessionParameters, "renditionFilter", "cmis:none");
        this.setDefault(VERSION_PREFIX, this.sessionParameters, "maxItemsPerPage", "10000");
        this.versionOperationContext = new ClientOperationContext(VERSION_PREFIX, this.sessionParameters);
    }

    private void setDefault(String prefix, Map<String, String> map, String key, String value) {
        if (!map.containsKey(prefix + key)) {
            map.put(prefix + key, value);
        }
    }

    private void acceptSelfSignedCertificates() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier accepctAllHostnames = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(accepctAllHostnames);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        FOLDER_PROPERTY_SET.add("cmis:objectId");
        FOLDER_PROPERTY_SET.add("cmis:objectTypeId");
        FOLDER_PROPERTY_SET.add("cmis:name");
        FOLDER_PROPERTY_SET.add("cmis:contentStreamMimeType");
        FOLDER_PROPERTY_SET.add("cmis:contentStreamLength");
        FOLDER_PROPERTY_SET.add("cmis:contentStreamFileName");
        FOLDER_PROPERTY_SET.add("cmis:createdBy");
        FOLDER_PROPERTY_SET.add("cmis:creationDate");
        FOLDER_PROPERTY_SET.add("cmis:lastModifiedBy");
        FOLDER_PROPERTY_SET.add("cmis:lastModificationDate");
        FOLDER_PROPERTY_SET.add("cmis:isVersionSeriesCheckedOut");
        FOLDER_PROPERTY_SET.add("cmis:versionSeriesCheckedOutId");
        VERSION_PROPERTY_SET = new HashSet<String>();
        VERSION_PROPERTY_SET.add("cmis:objectId");
        VERSION_PROPERTY_SET.add("cmis:objectTypeId");
        VERSION_PROPERTY_SET.add("cmis:name");
        VERSION_PROPERTY_SET.add("cmis:versionLabel");
        VERSION_PROPERTY_SET.add("cmis:isLatestVersion");
        VERSION_PROPERTY_SET.add("cmis:isMajorVersion");
        VERSION_PROPERTY_SET.add("cmis:isLatestMajorVersion");
        VERSION_PROPERTY_SET.add("cmis:contentStreamMimeType");
        VERSION_PROPERTY_SET.add("cmis:contentStreamLength");
        VERSION_PROPERTY_SET.add("cmis:contentStreamFileName");
    }

    public static enum Authentication {
        NONE,
        STANDARD,
        NTLM,
        OAUTH_BEARER;

    }
}

