/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public abstract class ActionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final ClientModel model;
    private CmisObject object;
    private JPanel centerPanel;

    public ActionPanel(String title, String buttonLabel, ClientModel model) {
        this.model = model;
        this.createGUI(title, buttonLabel);
    }

    public ClientModel getClientModel() {
        return this.model;
    }

    public void setObject(CmisObject object) {
        this.object = object;
    }

    public CmisObject getObject() {
        return this.object;
    }

    public CmisVersion getCmisVersion() {
        try {
            return this.model.getRepositoryInfo().getCmisVersion();
        }
        catch (Exception e) {
            return CmisVersion.CMIS_1_0;
        }
    }

    private void createGUI(String title, String buttonLabel) {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(3);
        this.setLayout(borderLayout);
        this.setBackground(Color.WHITE);
        this.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createCompoundBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)), WorkbenchScale.scaleBorder(BorderFactory.createCompoundBorder(WorkbenchScale.scaleBorder(BorderFactory.createLineBorder(Color.GRAY, 2)), WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)))))));
        Font labelFont = UIManager.getFont("Label.font");
        Font boldFont = labelFont.deriveFont(1, labelFont.getSize2D() * 1.2f);
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(boldFont);
        this.add((Component)titleLabel, "First");
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 3));
        this.centerPanel.setBackground(Color.WHITE);
        this.add((Component)this.centerPanel, "Center");
        this.createActionComponents();
        JButton actionButton = new JButton(buttonLabel);
        actionButton.addActionListener(this);
        this.add((Component)actionButton, "Last");
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, this.getPreferredSize().height));
    }

    protected void addActionComponent(JComponent comp) {
        comp.setAlignmentX(0.0f);
        this.centerPanel.add(comp);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            ((JButton)e.getSource()).requestFocusInWindow();
            if (this.doAction()) {
                this.model.reloadObject();
            }
            this.model.reloadFolder();
        }
        catch (Exception ex) {
            ClientHelper.showError(null, ex);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected abstract void createActionComponents();

    public abstract boolean isAllowed();

    public abstract boolean doAction() throws Exception;

    protected JPanel createFilenamePanel(final JTextField filenameField) {
        JPanel filePanel = new JPanel(new BorderLayout());
        filePanel.setBackground(Color.WHITE);
        filePanel.add((Component)new JLabel("File:"), "Before");
        filePanel.add((Component)filenameField, "Center");
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser();
                int chooseResult = fileChooser.showDialog(filenameField, "Select");
                if (chooseResult == 0 && fileChooser.getSelectedFile().isFile()) {
                    filenameField.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        filePanel.add((Component)browseButton, "After");
        return filePanel;
    }
}

