/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.swing;

import java.util.EnumMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.workbench.icons.DocumentIcon;
import org.apache.chemistry.opencmis.workbench.icons.FolderIcon;
import org.apache.chemistry.opencmis.workbench.icons.ItemIcon;
import org.apache.chemistry.opencmis.workbench.icons.PolicyIcon;
import org.apache.chemistry.opencmis.workbench.icons.RelationshipIcon;
import org.apache.chemistry.opencmis.workbench.icons.SecondaryIcon;

public class BaseTypeLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static final int ICON_SIZE = 16;
    private static final Map<BaseTypeId, Icon> ICONS = new EnumMap<BaseTypeId, Icon>(BaseTypeId.class);
    private BaseTypeId value = null;

    public BaseTypeLabel() {
        super("", null, 2);
    }

    public BaseTypeId getValue() {
        return this.value;
    }

    public void setValue(BaseTypeId value) {
        if (this.value != value) {
            this.value = value;
            if (value == null) {
                this.setIcon(null);
                this.setText("");
            } else {
                this.setIcon(ICONS.get(value));
                this.setText(value.value());
            }
            this.invalidate();
        }
    }

    static {
        ICONS.put(BaseTypeId.CMIS_DOCUMENT, new DocumentIcon(16, 16));
        ICONS.put(BaseTypeId.CMIS_FOLDER, new FolderIcon(16, 16));
        ICONS.put(BaseTypeId.CMIS_RELATIONSHIP, new RelationshipIcon(16, 16));
        ICONS.put(BaseTypeId.CMIS_POLICY, new PolicyIcon(16, 16));
        ICONS.put(BaseTypeId.CMIS_ITEM, new ItemIcon(16, 16));
        ICONS.put(BaseTypeId.CMIS_SECONDARY, new SecondaryIcon(16, 16));
    }
}

