/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.swing;

import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.chemistry.opencmis.commons.definitions.Choice;
import org.apache.chemistry.opencmis.workbench.ClientHelper;

public class CollectionRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final String NOT_SET_COLOR;
    private boolean bold = false;

    public CollectionRenderer() {
    }

    public CollectionRenderer(boolean bold) {
        this.bold = bold;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int height = (int)this.getPreferredSize().getHeight();
        if (height > this.getFontMetrics(this.getFont()).getHeight() + this.getInsets().bottom + this.getInsets().top && table.getRowHeight(row) != height) {
            table.setRowHeight(row, height);
        }
        return comp;
    }

    @Override
    protected void setValue(Object value) {
        Collection col = (Collection)value;
        if (col == null || col.isEmpty()) {
            super.setValue("<html><span><font color=" + NOT_SET_COLOR + "><i>" + (this.bold ? "<b>" : "") + "not set</i>" + (this.bold ? "</b>" : "") + "</font></span>");
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("<html>");
        for (Object o : col) {
            sb.append("<span>");
            if (this.bold) {
                sb.append("<b>");
            }
            if (o == null) {
                sb.append("<i>null</i>");
            } else if (o instanceof GregorianCalendar) {
                sb.append(ClientHelper.getDateString((GregorianCalendar)o));
            } else if (o instanceof Choice) {
                List choiceValue = ((Choice)o).getValue();
                if (choiceValue == null) {
                    sb.append("<i>null</i>");
                } else if (o instanceof GregorianCalendar) {
                    sb.append(ClientHelper.getDateString((GregorianCalendar)o));
                } else {
                    ClientHelper.encodeHtml(sb, choiceValue.toString());
                }
            } else {
                ClientHelper.encodeHtml(sb, o.toString());
            }
            if (this.bold) {
                sb.append("</b>");
            }
            sb.append("</span><br/>");
        }
        super.setValue(sb.toString());
    }

    static {
        Color notSetColor = UIManager.getColor("Label.disabledText");
        NOT_SET_COLOR = notSetColor != null ? String.format("#%1$02x%2$02x%3$02x", notSetColor.getRed(), notSetColor.getGreen(), notSetColor.getBlue()) : "#8e8f91";
    }
}

