/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public abstract class CreateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final ClientModel model;
    private final JPanel panel;
    private final JPanel mandatoryOrOnCreatePropertiesPanel;
    private final JPanel actionPanel;
    private final Map<String, JComponent> mandatoryOrOnCreateProperties;

    public CreateDialog(Frame owner, String title, ClientModel model) {
        super(owner, title, true);
        this.model = model;
        this.setLayout(new BorderLayout());
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.add((Component)this.panel, "Center");
        this.mandatoryOrOnCreateProperties = new HashMap<String, JComponent>();
        this.mandatoryOrOnCreatePropertiesPanel = new JPanel(new GridBagLayout());
        this.mandatoryOrOnCreatePropertiesPanel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createCompoundBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0)), WorkbenchScale.scaleBorder(BorderFactory.createTitledBorder("Mandatory or OnCreate properties")))));
        this.actionPanel = new JPanel();
        this.createRow(this.actionPanel, 10);
    }

    protected ClientModel getClientModel() {
        return this.model;
    }

    protected final void createRow(String label, JComponent comp, int row) {
        this.createRow(this.panel, label, comp, row);
    }

    protected final void createActionRow(String label, JComponent comp, int row) {
        this.createRow(this.actionPanel, label, comp, row);
    }

    protected final void createRow(JPanel panel, String label, JComponent comp, int row) {
        JLabel textLabel = new JLabel(label);
        textLabel.setLabelFor(comp);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = row;
        panel.add((Component)textLabel, c);
        c.gridx = 1;
        panel.add((Component)comp, c);
    }

    protected final void createRow(JComponent comp, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 2;
        this.panel.add((Component)comp, c);
    }

    public final void showDialog() {
        this.panel.invalidate();
        ClientHelper.installEscapeBinding(this, this.getRootPane(), true);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    protected final ObjectTypeItem[] getTypes(String rootTypeId) {
        List<ObjectType> types = this.model.getTypesAsList(rootTypeId, true);
        ObjectTypeItem[] result = new ObjectTypeItem[types.size()];
        int i = 0;
        for (final ObjectType type : types) {
            result[i] = new ObjectTypeItem(){

                @Override
                public ObjectType getObjectType() {
                    return type;
                }

                public String toString() {
                    return type.getDisplayName() + " (" + type.getId() + ")";
                }
            };
            ++i;
        }
        return result;
    }

    protected final void updateMandatoryOrOnCreateFields(TypeDefinition type) {
        this.mandatoryOrOnCreateProperties.clear();
        this.mandatoryOrOnCreatePropertiesPanel.removeAll();
        Map propertyDefinitions = type.getPropertyDefinitions();
        if (propertyDefinitions != null) {
            int row = 0;
            for (PropertyDefinition definition : propertyDefinitions.values()) {
                if (!Boolean.TRUE.equals(definition.isRequired()) && !Updatability.ONCREATE.equals((Object)definition.getUpdatability()) || "cmis:name".equals(definition.getId()) || "cmis:objectTypeId".equals(definition.getId()) || "cmis:sourceId".equals(definition.getId()) || "cmis:targetId".equals(definition.getId())) continue;
                JComponent child = this.createPropertyComponent(definition);
                this.mandatoryOrOnCreateProperties.put(definition.getId(), child);
                this.createRow(this.mandatoryOrOnCreatePropertiesPanel, definition.getDisplayName() + ":", child, row);
                ++row;
            }
        }
        if (this.mandatoryOrOnCreatePropertiesPanel.getComponents().length > 0) {
            this.createRow(this.mandatoryOrOnCreatePropertiesPanel, 9);
        } else {
            this.panel.remove(this.mandatoryOrOnCreatePropertiesPanel);
        }
        this.pack();
        this.repaint();
    }

    protected JComponent createPropertyComponent(PropertyDefinition<?> definition) {
        JComponent result;
        PropertyType propertyType = definition.getPropertyType();
        switch (propertyType) {
            case BOOLEAN: {
                result = new JCheckBox();
                break;
            }
            case INTEGER: {
                DecimalFormat intFormat = new DecimalFormat("#,##0");
                intFormat.setParseBigDecimal(true);
                intFormat.setParseIntegerOnly(true);
                result = new JFormattedTextField(intFormat);
                ((JFormattedTextField)result).setColumns(50);
                break;
            }
            case DECIMAL: {
                DecimalFormat decFormat = new DecimalFormat("#,##0.#############################");
                decFormat.setParseBigDecimal(true);
                result = new JFormattedTextField(decFormat);
                ((JFormattedTextField)result).setColumns(50);
                break;
            }
            case DATETIME: {
                result = new JFormattedTextField(DateFormat.getDateTimeInstance());
                ((JFormattedTextField)result).setColumns(50);
                break;
            }
            default: {
                result = new JTextField("", 50);
            }
        }
        return result;
    }

    protected Map<String, Object> getMandatoryOrOnCreatePropertyValues(TypeDefinition type) {
        if (this.mandatoryOrOnCreateProperties.isEmpty()) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, JComponent> component : this.mandatoryOrOnCreateProperties.entrySet()) {
            PropertyDefinition propDef = (PropertyDefinition)type.getPropertyDefinitions().get(component.getKey());
            Object value = null;
            if (component.getValue() instanceof JFormattedTextField) {
                value = ((JFormattedTextField)component.getValue()).getValue();
                if (value != null && propDef.getPropertyType() == PropertyType.INTEGER) {
                    value = ((BigDecimal)value).toBigIntegerExact();
                }
            } else if (component.getValue() instanceof JTextField) {
                value = ((JTextField)component.getValue()).getText();
            } else if (component.getValue() instanceof JCheckBox) {
                value = ((JCheckBox)component.getValue()).isSelected();
            }
            if (value == null) continue;
            result.put(component.getKey(), value);
        }
        return result;
    }

    public static interface ObjectTypeItem {
        public ObjectType getObjectType();
    }
}

