/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.swing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.WorkbenchScale;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.BaseTypeLabel;
import org.apache.chemistry.opencmis.workbench.swing.YesNoLabel;

public abstract class InfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ClientModel model;
    private JPanel gridPanel;
    private GridBagConstraints gbc;
    private Font boldFont;

    public InfoPanel(ClientModel model) {
        this.model = model;
    }

    protected ClientModel getClientModel() {
        return this.model;
    }

    protected void setupGUI() {
        this.setLayout(new FlowLayout(0));
        this.setBackground(Color.WHITE);
        this.gridPanel = new JPanel(new GridBagLayout());
        this.gridPanel.setBackground(Color.WHITE);
        this.add(this.gridPanel);
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.gridy = 0;
        this.gbc.insets = WorkbenchScale.scaleInsets(new Insets(3, 3, 3, 3));
        Font labelFont = UIManager.getFont("Label.font");
        this.boldFont = labelFont.deriveFont(1, labelFont.getSize2D() * 1.2f);
    }

    protected JTextField addLine(String label) {
        return this.addLine(label, false);
    }

    protected JTextField addLine(String label, boolean bold) {
        return this.addLine(label, bold, new JTextField());
    }

    protected JTextField addLine(String label, boolean bold, JTextField textField) {
        textField.setEditable(false);
        textField.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder()));
        if (bold) {
            textField.setFont(this.boldFont);
        }
        JLabel textLable = new JLabel(label);
        textLable.setLabelFor(textField);
        if (bold) {
            textLable.setFont(this.boldFont);
        }
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.anchor = 768;
        this.gridPanel.add((Component)textLable, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 512;
        this.gridPanel.add((Component)textField, this.gbc);
        return textField;
    }

    protected JTextField addId(String label) {
        return this.addLine(label, false, new IdTextField());
    }

    protected JTextField addLink(String label) {
        return this.addLine(label, false, new UrlTextField());
    }

    protected YesNoLabel addYesNoLabel(String label) {
        YesNoLabel ynl = new YesNoLabel();
        JLabel textLable = new JLabel(label);
        textLable.setLabelFor(ynl);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.anchor = 768;
        this.gridPanel.add((Component)textLable, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 512;
        this.gridPanel.add((Component)ynl, this.gbc);
        return ynl;
    }

    protected BaseTypeLabel addBaseTypeLabel(String label) {
        BaseTypeLabel btl = new BaseTypeLabel();
        JLabel textLable = new JLabel(label);
        textLable.setLabelFor(btl);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.anchor = 768;
        this.gridPanel.add((Component)textLable, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 512;
        this.gridPanel.add((Component)btl, this.gbc);
        return btl;
    }

    protected <T extends JComponent> T addComponent(String label, T comp) {
        JLabel textLable = new JLabel(label);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder()));
        panel.setOpaque(false);
        panel.add(comp);
        textLable.setLabelFor(panel);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.anchor = 768;
        this.gridPanel.add((Component)textLable, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 512;
        this.gridPanel.add((Component)panel, this.gbc);
        return comp;
    }

    private class UrlTextField
    extends ClickableTextField {
        private static final long serialVersionUID = 1L;
        private JMenuItem qrCodeItem;

        public UrlTextField() {
            this.qrCodeItem = new JMenuItem();
            this.qrCodeItem.setVerticalTextPosition(3);
            this.qrCodeItem.setHorizontalTextPosition(0);
            this.getPopupMenu().addSeparator();
            this.getPopupMenu().add(this.qrCodeItem);
        }

        @Override
        public void setText(String text) {
            if (this.isLink(text)) {
                try {
                    EnumMap<EncodeHintType, Integer> hints = new EnumMap<EncodeHintType, Integer>(EncodeHintType.class);
                    hints.put(EncodeHintType.MARGIN, 0);
                    BitMatrix bitMatrix = new QRCodeWriter().encode(text, BarcodeFormat.QR_CODE, 200, 200, hints);
                    this.qrCodeItem.setIcon(new ImageIcon(MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix)));
                    this.qrCodeItem.setVisible(true);
                }
                catch (WriterException e) {
                    this.qrCodeItem.setVisible(false);
                }
            } else {
                this.qrCodeItem.setVisible(false);
                this.getPopupMenu().setEnabled(false);
            }
            super.setText(text);
        }

        @Override
        public boolean isLink(String link) {
            if (link == null || link.length() == 0) {
                return false;
            }
            String lower = link.toLowerCase(Locale.ENGLISH);
            return lower.startsWith("http://") || lower.startsWith("https://");
        }

        @Override
        public Color getLinkColor(String link) {
            return Color.BLUE;
        }

        @Override
        public void linkAction(String link) {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(link));
                }
                catch (Exception ex) {
                    ClientHelper.showError(InfoPanel.this, ex);
                }
            }
        }
    }

    private class IdTextField
    extends ClickableTextField {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isLink(String link) {
            return link != null && link.length() > 0 && link.charAt(0) != '(';
        }

        @Override
        public Color getLinkColor(String link) {
            return ClientHelper.LINK_COLOR;
        }

        @Override
        public void linkAction(String link) {
            try {
                InfoPanel.this.getClientModel().loadObject(link);
            }
            catch (Exception ex) {
                ClientHelper.showError(InfoPanel.this, ex);
            }
        }
    }

    private abstract class ClickableTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private String link;
        private boolean updated = false;
        private final JPopupMenu popup = new JPopupMenu();

        public ClickableTextField() {
            JMenuItem menuItem = new JMenuItem("Copy to clipboard");
            this.popup.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection transferable = new StringSelection(ClickableTextField.this.link);
                    clipboard.setContents(transferable, null);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (ClickableTextField.this.link != null && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
                        try {
                            ClickableTextField.this.linkAction(ClickableTextField.this.link);
                        }
                        catch (Exception ex) {
                            ClientHelper.showError(InfoPanel.this, ex);
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        ClickableTextField.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }

        public JPopupMenu getPopupMenu() {
            return this.popup;
        }

        public abstract boolean isLink(String var1);

        public abstract Color getLinkColor(String var1);

        public abstract void linkAction(String var1);

        @Override
        public void setText(String text) {
            if (!this.isLink(text)) {
                this.setForeground(UIManager.getColor("textForeground"));
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.popup.setEnabled(false);
                this.link = null;
            } else {
                this.setForeground(this.getLinkColor(text));
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.popup.setEnabled(true);
                this.link = text;
            }
            this.updated = true;
            super.setText(text);
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
            if (this.updated) {
                super.repaint(tm, x, y, width, height);
                this.updated = false;
            }
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.link != null) {
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int y1 = fm.getHeight() - 2;
                int x2 = fm.stringWidth(this.link);
                g.setColor(this.getLinkColor(this.link));
                g.drawLine(0, y1, x2, y1);
            }
        }
    }

    public static class InfoList
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public InfoList() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBackground(Color.WHITE);
        }

        public void clear() {
            this.removeAll();
        }

        public void setList(Collection<?> list) {
            this.clear();
            if (CollectionsHelper.isNullOrEmpty(list)) {
                return;
            }
            for (Object o : list) {
                JTextField textField = new JTextField(o == null ? "" : o.toString());
                textField.setEditable(false);
                textField.setBorder(WorkbenchScale.scaleBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0)));
                this.add(textField);
            }
        }
    }
}

