/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.basics;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class RootFolderTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Root Folder Test");
        this.setDescription("Checks the root folder and its children for specification compliance.");
    }

    @Override
    public void run(Session session) throws Exception {
        RepositoryInfo ri = this.getRepositoryInfo(session);
        CmisTestResultImpl success = this.createResult(CmisTestResultStatus.OK, "Root folder id: " + ri.getRootFolderId());
        CmisTestResultImpl failure = this.createResult(CmisTestResultStatus.FAILURE, "Root folder id is not set!");
        this.addResult(this.assertStringNotEmpty(ri.getRootFolderId(), success, failure));
        Folder rootFolder = session.getRootFolder(SELECT_ALL_NO_CACHE_OC);
        if (rootFolder == null) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Root folder is not available!"));
            return;
        }
        failure = this.createResult(CmisTestResultStatus.FAILURE, "Root folder doesn't exist?!");
        this.addResult(this.assertIsTrue(session.exists(ri.getRootFolderId()), null, failure));
        this.addResult(this.checkObject(session, (CmisObject)rootFolder, this.getAllProperties((CmisObject)rootFolder), "Root folder object spec compliance"));
        failure = this.createResult(CmisTestResultStatus.FAILURE, "Root folder id in the repository info doesn't match the root folder object id!");
        this.addResult(this.assertEquals(ri.getRootFolderId(), rootFolder.getId(), null, (CmisTestResult)failure));
        failure = this.createResult(CmisTestResultStatus.FAILURE, "Root folder is not a cmis:folder!");
        this.addResult(this.assertEquals(BaseTypeId.CMIS_FOLDER, rootFolder.getBaseTypeId(), null, (CmisTestResult)failure));
        failure = this.createResult(CmisTestResultStatus.FAILURE, "Root folder path is not '/'!");
        this.addResult(this.assertEquals("/", rootFolder.getPath(), null, (CmisTestResult)failure));
        failure = this.createResult(CmisTestResultStatus.FAILURE, "Root folder has parents!");
        this.addResult(this.assertEquals(0, rootFolder.getParents().size(), null, (CmisTestResult)failure));
        failure = this.createResult(CmisTestResultStatus.FAILURE, "Root folder has CAN_GET_FOLDER_PARENT allowable action!");
        this.addResult(this.assertNotAllowableAction((CmisObject)rootFolder, Action.CAN_GET_FOLDER_PARENT, null, failure));
        failure = this.createResult(CmisTestResultStatus.WARNING, "Root folder has no CAN_GET_CHILDREN allowable action!");
        this.addResult(this.assertAllowableAction((CmisObject)rootFolder, Action.CAN_GET_CHILDREN, null, failure));
        this.addResult(this.checkChildren(session, rootFolder, "Root folder children check"));
    }
}

