/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class CreateDocumentWithoutContent
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Create Document without Content Test");
        this.setDescription("Creates a document without content and deletes it.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        String objectTypeId = this.getDocumentTestTypeId();
        ObjectType type = session.getTypeDefinition(objectTypeId);
        if (!(type instanceof DocumentTypeDefinition)) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Type is not a document type! Type: " + objectTypeId, true));
            return;
        }
        DocumentTypeDefinition docType = (DocumentTypeDefinition)type;
        if (docType.getContentStreamAllowed() == ContentStreamAllowed.REQUIRED) {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "The test document type does not support documents without content. Test skipped!"));
            return;
        }
        Folder testFolder = this.createTestFolder(session);
        try {
            String name = "nocontent";
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("cmis:name", name);
            properties.put("cmis:objectTypeId", objectTypeId);
            VersioningState versioningState = Boolean.TRUE.equals(docType.isVersionable()) ? VersioningState.MAJOR : VersioningState.NONE;
            ObjectId id = session.createDocument(properties, (ObjectId)testFolder, null, versioningState);
            Document doc = (Document)session.getObject(id, SELECT_ALL_NO_CACHE_OC);
            this.addResult(this.checkObject(session, (CmisObject)doc, this.getAllProperties((CmisObject)doc), "New document object spec compliance"));
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "The document has no content but a MIME type!", true);
            this.assertNull(doc.getContentStreamMimeType(), null, f);
            if (doc.getContentStreamLength() == 0L) {
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "The document has no content but the content length is set to 0! The content length shouldn't be set."));
            } else if (doc.getContentStreamLength() > 0L) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "The document has no content but the content length is set and >0! (content length: " + doc.getContentStreamLength() + ")"));
            }
            doc.delete(true);
        }
        finally {
            this.deleteTestFolder();
        }
    }
}

