/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;

public final class FileUtil {
    public static void copyContent(FileObject srcFile, FileObject destFile) throws IOException {
        srcFile.getContent().write(destFile);
    }

    public static byte[] getContent(FileObject file) throws IOException {
        try (FileContent content = file.getContent();){
            byte[] byArray = content.getByteArray();
            return byArray;
        }
    }

    public static void writeContent(FileObject file, OutputStream output) throws IOException {
        file.getContent().write(output);
    }

    private FileUtil() {
    }
}

