/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.LocalFileProvider;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.local.GenericFileNameParser;
import org.apache.commons.vfs2.provider.local.LocalFileName;
import org.apache.commons.vfs2.provider.local.LocalFileNameParser;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.apache.commons.vfs2.provider.local.WindowsFileNameParser;
import org.apache.commons.vfs2.util.Os;

public class DefaultLocalFileProvider
extends AbstractOriginatingFileProvider
implements LocalFileProvider {
    public static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE, Capability.SET_LAST_MODIFIED_FOLDER, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT, Capability.RANDOM_ACCESS_READ, Capability.RANDOM_ACCESS_SET_LENGTH, Capability.RANDOM_ACCESS_WRITE));

    public DefaultLocalFileProvider() {
        if (Os.isFamily(Os.OS_FAMILY_WINDOWS)) {
            this.setFileNameParser(new WindowsFileNameParser());
        } else {
            this.setFileNameParser(new GenericFileNameParser());
        }
    }

    @Override
    public boolean isAbsoluteLocalName(String name) {
        return ((LocalFileNameParser)this.getFileNameParser()).isAbsoluteName(name);
    }

    @Override
    public FileObject findLocalFile(String name) throws FileSystemException {
        String scheme = "file:";
        StringBuilder uri = new StringBuilder(name.length() + "file:".length());
        uri.append("file:");
        uri.append(name);
        FileName fileName = this.parseUri(null, uri.toString());
        return this.findFile(fileName, null);
    }

    @Override
    public FileObject findLocalFile(File file) throws FileSystemException {
        return this.findLocalFile(UriParser.encode(file.getAbsolutePath()));
    }

    @Override
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LocalFileName rootName = (LocalFileName)name;
        return new LocalFileSystem((FileName)rootName, rootName.getRootFile(), fileSystemOptions);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

