/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.servlet.BaseUrlHelper;

public final class HttpUtils {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(HttpUtils.class);
    private static final Logger LOG = LogUtils.getL7dLogger(HttpUtils.class);
    private static final String REQUEST_PATH_TO_MATCH = "path_to_match";
    private static final String REQUEST_PATH_TO_MATCH_SLASH = "path_to_match_slash";
    private static final String HTTP_SCHEME = "http";
    private static final String ANY_IP_ADDRESS = "0.0.0.0";
    private static final String ANY_IP_ADDRESS_START = "://0.0.0.0";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final Pattern ENCODE_PATTERN = Pattern.compile("%[0-9a-fA-F][0-9a-fA-F]");
    private static final String CHARSET_PARAMETER = "charset";
    private static final String PATH_RESERVED_CHARACTERS = "=@/:!$&'(),;~";
    private static final String QUERY_RESERVED_CHARACTERS = "?/,";

    private HttpUtils() {
    }

    public static String urlDecode(String value, String enc) {
        return UrlUtils.urlDecode(value, enc);
    }

    public static String urlDecode(String value) {
        return UrlUtils.urlDecode(value);
    }

    public static String pathDecode(String value) {
        return UrlUtils.pathDecode(value);
    }

    private static String componentEncode(String reservedChars, String value) {
        StringBuilder buffer = new StringBuilder();
        StringBuilder bufferToEncode = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            if (reservedChars.indexOf(currentChar) != -1) {
                if (bufferToEncode.length() > 0) {
                    buffer.append(HttpUtils.urlEncode(bufferToEncode.toString()));
                    bufferToEncode.setLength(0);
                }
                buffer.append(currentChar);
                continue;
            }
            bufferToEncode.append(currentChar);
        }
        if (bufferToEncode.length() > 0) {
            buffer.append(HttpUtils.urlEncode(bufferToEncode.toString()));
        }
        return buffer.toString();
    }

    public static String queryEncode(String value) {
        return HttpUtils.componentEncode(QUERY_RESERVED_CHARACTERS, value);
    }

    public static String urlEncode(String value) {
        return HttpUtils.urlEncode(value, "UTF-8");
    }

    public static String urlEncode(String value, String enc) {
        return UrlUtils.urlEncode(value, enc);
    }

    public static String pathEncode(String value) {
        String result = HttpUtils.componentEncode(PATH_RESERVED_CHARACTERS, value);
        if (result.indexOf(43) != -1) {
            result = result.replace("+", "%20");
        }
        if (result.indexOf("%2B") != -1) {
            result = result.replace("%2B", "+");
        }
        return result;
    }

    public static boolean isPartiallyEncoded(String value) {
        return ENCODE_PATTERN.matcher(value).find();
    }

    public static String encodePartiallyEncoded(String encoded, boolean query) {
        if (encoded.length() == 0) {
            return encoded;
        }
        Matcher m = ENCODE_PATTERN.matcher(encoded);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (m.find()) {
            String before = encoded.substring(i, m.start());
            sb.append(query ? HttpUtils.queryEncode(before) : HttpUtils.pathEncode(before));
            sb.append(m.group());
            i = m.end();
        }
        String tail = encoded.substring(i, encoded.length());
        sb.append(query ? HttpUtils.queryEncode(tail) : HttpUtils.pathEncode(tail));
        return sb.toString();
    }

    public static SimpleDateFormat getHttpDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        TimeZone tZone = TimeZone.getTimeZone("GMT");
        dateFormat.setTimeZone(tZone);
        return dateFormat;
    }

    public static Date getHttpDate(String value) {
        if (value == null) {
            return null;
        }
        try {
            return HttpUtils.getHttpDateFormat().parse(value);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static Locale getLocale(String value) {
        if (value == null) {
            return null;
        }
        String language = null;
        String locale = null;
        int index = value.indexOf(45);
        if (index == 0 || index == value.length() - 1) {
            throw new IllegalArgumentException("Illegal locale value : " + value);
        }
        if (index > 0) {
            language = value.substring(0, index);
            locale = value.substring(index + 1);
        } else {
            language = value;
        }
        if (locale == null) {
            return new Locale(language);
        }
        return new Locale(language, locale);
    }

    public static int getContentLength(String value) {
        if (value == null) {
            return -1;
        }
        try {
            int len = Integer.valueOf(value);
            return len >= 0 ? len : -1;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static String getHeaderString(List<String> values) {
        if (values == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            if (StringUtils.isEmpty(value)) continue;
            sb.append(value);
            if (i + 1 >= values.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static boolean isDateRelatedHeader(String headerName) {
        return "Date".equalsIgnoreCase(headerName) || "If-Modified-Since".equalsIgnoreCase(headerName) || "If-Unmodified-Since".equalsIgnoreCase(headerName) || "Expires".equalsIgnoreCase(headerName) || "Last-Modified".equalsIgnoreCase(headerName);
    }

    public static boolean isHttpRequest(Message message) {
        return message.get("HTTP.REQUEST") != null;
    }

    public static URI toAbsoluteUri(String relativePath, Message message) {
        String base = BaseUrlHelper.getBaseURL((HttpServletRequest)message.get("HTTP.REQUEST"));
        return URI.create(base + relativePath);
    }

    public static URI toAbsoluteUri(URI u, Message message) {
        HttpServletRequest request = (HttpServletRequest)message.get("HTTP.REQUEST");
        boolean absolute = u.isAbsolute();
        if (request != null && (!absolute || u.toString().contains(ANY_IP_ADDRESS_START))) {
            int port;
            String serverAndPort = request.getServerName();
            boolean localAddressUsed = false;
            if (absolute && ANY_IP_ADDRESS.equals(serverAndPort)) {
                serverAndPort = request.getLocalAddr();
                localAddressUsed = true;
            }
            int n = port = localAddressUsed ? request.getLocalPort() : request.getServerPort();
            if (port != 80) {
                serverAndPort = serverAndPort + ":" + port;
            }
            String base = request.getScheme() + "://" + serverAndPort;
            if (!absolute) {
                u = URI.create(base + u.toString());
            } else {
                int originalPort = u.getPort();
                String replaceValue = originalPort == -1 ? ANY_IP_ADDRESS : "0.0.0.0:" + originalPort;
                u = URI.create(u.toString().replace(replaceValue, serverAndPort));
            }
        }
        return u;
    }

    public static void resetRequestURI(Message m, String requestURI) {
        m.remove(REQUEST_PATH_TO_MATCH_SLASH);
        m.remove(REQUEST_PATH_TO_MATCH);
        m.put("org.apache.cxf.request.uri", requestURI);
    }

    public static String getPathToMatch(Message m, boolean addSlash) {
        int index;
        String var = addSlash ? REQUEST_PATH_TO_MATCH_SLASH : REQUEST_PATH_TO_MATCH;
        String pathToMatch = (String)m.get(var);
        if (pathToMatch != null) {
            return pathToMatch;
        }
        String requestAddress = HttpUtils.getProtocolHeader(m, "org.apache.cxf.request.uri", "/");
        if (m.get(Message.QUERY_STRING) == null && (index = requestAddress.lastIndexOf(63)) > 0 && index < requestAddress.length()) {
            m.put(Message.QUERY_STRING, requestAddress.substring(index + 1));
            requestAddress = requestAddress.substring(0, index);
        }
        String baseAddress = HttpUtils.getBaseAddress(m);
        pathToMatch = HttpUtils.getPathToMatch(requestAddress, baseAddress, addSlash);
        m.put(var, pathToMatch);
        return pathToMatch;
    }

    public static String getProtocolHeader(Message m, String name, String defaultValue) {
        return HttpUtils.getProtocolHeader(m, name, defaultValue, false);
    }

    public static String getProtocolHeader(Message m, String name, String defaultValue, boolean setOnMessage) {
        String value = (String)m.get(name);
        if (value == null && (value = (String)new HttpHeadersImpl(m).getRequestHeaders().getFirst((Object)name)) != null && setOnMessage) {
            m.put(name, value);
        }
        return value == null ? defaultValue : value;
    }

    public static String getBaseAddress(Message m) {
        String endpointAddress = HttpUtils.getEndpointAddress(m);
        try {
            URI uri = new URI(endpointAddress);
            String path = uri.getRawPath();
            String scheme = uri.getScheme();
            if (scheme != null && !scheme.startsWith(HTTP_SCHEME) && HttpUtils.isHttpRequest(m)) {
                path = HttpUtils.toAbsoluteUri(path, m).getRawPath();
            }
            return path.length() == 0 ? "/" : path;
        }
        catch (URISyntaxException ex) {
            return endpointAddress == null ? "/" : endpointAddress;
        }
    }

    public static String getEndpointAddress(Message m) {
        String address = null;
        Destination d = m.getExchange().getDestination();
        if (d != null) {
            if (d instanceof AbstractHTTPDestination) {
                EndpointInfo ei = ((AbstractHTTPDestination)d).getEndpointInfo();
                HttpServletRequest request = (HttpServletRequest)m.get("HTTP.REQUEST");
                Object property = request != null ? request.getAttribute("org.apache.cxf.transport.endpoint.address") : null;
                address = property != null ? property.toString() : ei.getAddress();
            } else {
                address = m.containsKey(Message.BASE_PATH) ? (String)m.get(Message.BASE_PATH) : d.getAddress().getAddress().getValue();
            }
        } else {
            address = (String)m.get(Message.ENDPOINT_ADDRESS);
        }
        if (address.startsWith(HTTP_SCHEME) && address.endsWith("//")) {
            address = address.substring(0, address.length() - 1);
        }
        return address;
    }

    public static void updatePath(Message m, String path) {
        String baseAddress = HttpUtils.getBaseAddress(m);
        boolean pathSlash = path.startsWith("/");
        boolean baseSlash = baseAddress.endsWith("/");
        if (pathSlash && baseSlash) {
            path = path.substring(1);
        } else if (!pathSlash && !baseSlash) {
            path = "/" + path;
        }
        m.put("org.apache.cxf.request.uri", baseAddress + path);
        m.remove(REQUEST_PATH_TO_MATCH);
        m.remove(REQUEST_PATH_TO_MATCH_SLASH);
    }

    public static String getPathToMatch(String path, String address, boolean addSlash) {
        int ind = path.indexOf(address);
        if (ind == -1 && address.equals(path + "/")) {
            path = path + "/";
            ind = 0;
        }
        if (ind == 0) {
            path = path.substring(ind + address.length());
        }
        if (addSlash && !path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public static String getOriginalAddress(Message m) {
        Destination d = m.getDestination();
        return d == null ? "/" : d.getAddress().getAddress().getValue();
    }

    public static String fromPathSegment(PathSegment ps) {
        if (PathSegmentImpl.class.isAssignableFrom(ps.getClass())) {
            return ((PathSegmentImpl)ps).getOriginalPath();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ps.getPath());
        for (Map.Entry entry : ps.getMatrixParameters().entrySet()) {
            for (String value : (List)entry.getValue()) {
                sb.append(';').append((String)entry.getKey());
                if (value == null) continue;
                sb.append('=').append(value);
            }
        }
        return sb.toString();
    }

    public static Response.Status getParameterFailureStatus(ParameterType pType) {
        if (pType == ParameterType.MATRIX || pType == ParameterType.PATH || pType == ParameterType.QUERY) {
            return Response.Status.NOT_FOUND;
        }
        return Response.Status.BAD_REQUEST;
    }

    public static String getSetEncoding(MediaType mt, MultivaluedMap<String, Object> headers, String defaultEncoding) {
        String enc = (String)mt.getParameters().get(CHARSET_PARAMETER);
        if (enc == null) {
            return defaultEncoding;
        }
        try {
            "0".getBytes(enc);
            return enc;
        }
        catch (UnsupportedEncodingException ex) {
            String message = new org.apache.cxf.common.i18n.Message("UNSUPPORTED_ENCODING", BUNDLE, enc, defaultEncoding).toString();
            LOG.warning(message);
            headers.putSingle((Object)"Content-Type", (Object)(JAXRSUtils.mediaTypeToString(mt, CHARSET_PARAMETER) + ';' + CHARSET_PARAMETER + "=" + (defaultEncoding == null ? "UTF-8" : defaultEncoding)));
            return defaultEncoding;
        }
    }

    public static String getEncoding(MediaType mt, String defaultEncoding) {
        String charset = mt == null ? defaultEncoding : (String)mt.getParameters().get(CHARSET_PARAMETER);
        return charset == null ? defaultEncoding : charset;
    }
}

