/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.SystemUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.maven_plugin.ClassLoaderSwitcher;
import org.apache.cxf.maven_plugin.ForkOnceWSDL2Java;
import org.apache.cxf.maven_plugin.Option;
import org.apache.cxf.maven_plugin.WsdlArtifact;
import org.apache.cxf.maven_plugin.WsdlOption;
import org.apache.cxf.maven_plugin.WsdlOptionLoader;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.settings.Proxy;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL2JavaMojo
extends AbstractMojo {
    File testSourceRoot;
    File sourceRoot;
    String classesDirectory;
    MavenProject project;
    Option defaultOptions = new Option();
    WsdlOption[] wsdlOptions;
    File wsdlRoot;
    File testWsdlRoot;
    File markerDirectory;
    boolean useCompileClasspath;
    boolean disableDirectoryScan;
    boolean disableDependencyScan;
    String[] includes;
    String[] excludes;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private List repositories;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private MavenSession mavenSession;
    private ArtifactResolver artifactResolver;
    private List<Artifact> pluginArtifacts;
    private String fork;
    private String javaExecutable;
    private String additionalJvmArgs;

    private void mergeOptions(List<WsdlOption> effectiveWsdlOptions) {
        if (this.wsdlOptions == null) {
            return;
        }
        File outputDirFile = this.testSourceRoot == null ? this.sourceRoot : this.testSourceRoot;
        for (WsdlOption o : this.wsdlOptions) {
            File file;
            if (this.defaultOptions != null) {
                o.merge(this.defaultOptions);
            }
            if (o.getOutputDir() == null) {
                o.setOutputDir(outputDirFile);
            }
            if ((file = o.getWsdlFile(this.project.getBasedir())) != null && file.exists()) {
                file = file.getAbsoluteFile();
                for (WsdlOption o2 : effectiveWsdlOptions) {
                    File file2 = o2.getWsdlFile(this.project.getBasedir());
                    if (file2 == null || !file2.exists() || !file2.getAbsoluteFile().equals(file)) continue;
                    o.getExtraargs().addAll(0, o2.getExtraargs());
                    effectiveWsdlOptions.remove(o2);
                    break;
                }
            }
            effectiveWsdlOptions.add(o);
        }
    }

    private List<WsdlOption> createWsdlOptionsFromScansAndExplicitWsdlOptions() throws MojoExecutionException {
        List<WsdlOption> temp;
        ArrayList<WsdlOption> effectiveWsdlOptions = new ArrayList<WsdlOption>();
        if (this.wsdlRoot != null && this.wsdlRoot.exists() && !this.disableDirectoryScan) {
            temp = WsdlOptionLoader.loadWsdlOptionsFromFiles(this.wsdlRoot, this.includes, this.excludes, this.defaultOptions, this.sourceRoot);
            effectiveWsdlOptions.addAll(temp);
        }
        if (this.testWsdlRoot != null && this.testWsdlRoot.exists() && !this.disableDirectoryScan) {
            temp = WsdlOptionLoader.loadWsdlOptionsFromFiles(this.testWsdlRoot, this.includes, this.excludes, this.defaultOptions, this.testSourceRoot);
            effectiveWsdlOptions.addAll(temp);
        }
        if (!this.disableDependencyScan) {
            temp = WsdlOptionLoader.loadWsdlOptionsFromDependencies(this.project, this.defaultOptions, this.sourceRoot);
            effectiveWsdlOptions.addAll(temp);
        }
        this.mergeOptions(effectiveWsdlOptions);
        this.downloadRemoteWsdls(effectiveWsdlOptions);
        return effectiveWsdlOptions;
    }

    private Artifact resolveRemoteWsdlArtifact(List remoteRepos, Artifact artifact) throws MojoExecutionException {
        List rProjects = this.mavenSession.getSortedProjects();
        for (MavenProject rProject : rProjects) {
            if (!artifact.getGroupId().equals(rProject.getGroupId()) || !artifact.getArtifactId().equals(rProject.getArtifactId()) || !artifact.getVersion().equals(rProject.getVersion())) continue;
            Set artifacts = rProject.getArtifacts();
            for (Artifact pArtifact : artifacts) {
                if (!"wsdl".equals(pArtifact.getType())) continue;
                return pArtifact;
            }
        }
        try {
            this.artifactResolver.resolve(artifact, remoteRepos, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error downloading wsdl artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Resource can not be found.", (Exception)((Object)e));
        }
        return artifact;
    }

    private void downloadRemoteWsdls(List<WsdlOption> effectiveWsdlOptions) throws MojoExecutionException {
        List remoteRepos;
        try {
            remoteRepos = ProjectUtils.buildArtifactRepositories((List)this.repositories, (ArtifactRepositoryFactory)this.artifactRepositoryFactory, (PlexusContainer)this.mavenSession.getContainer());
        }
        catch (InvalidRepositoryException e) {
            throw new MojoExecutionException("Error build repositories for remote wsdls", (Exception)((Object)e));
        }
        for (WsdlOption wsdlOption : effectiveWsdlOptions) {
            WsdlArtifact wsdlA = wsdlOption.getWsdlArtifact();
            if (wsdlA == null) {
                return;
            }
            Artifact wsdlArtifact = this.artifactFactory.createArtifact(wsdlA.getGroupId(), wsdlA.getArtifactId(), wsdlA.getVersion(), "compile", wsdlA.getType());
            if ((wsdlArtifact = this.resolveRemoteWsdlArtifact(remoteRepos, wsdlArtifact)) == null) continue;
            String path = wsdlArtifact.getFile().getAbsolutePath();
            this.getLog().info((CharSequence)("Resolved WSDL artifact to file " + path));
            wsdlOption.setWsdl(path);
        }
    }

    private void configureProxyServerSettings() throws MojoExecutionException {
        Proxy proxy = this.mavenSession.getSettings().getActiveProxy();
        if (proxy != null) {
            this.getLog().info((CharSequence)"Using proxy server configured in maven.");
            if (proxy.getHost() == null) {
                throw new MojoExecutionException("Proxy in settings.xml has no host");
            }
            System.setProperty("proxySet", "true");
            System.setProperty("proxyHost", proxy.getHost());
            System.setProperty("proxyPort", String.valueOf(proxy.getPort()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.includes == null) {
            this.includes = new String[]{"*.wsdl"};
        }
        this.defaultOptions.addDefaultBindingFileIfExists(this.project.getBasedir());
        File classesDir = new File(this.classesDirectory);
        classesDir.mkdirs();
        this.markerDirectory.mkdirs();
        this.configureProxyServerSettings();
        List<WsdlOption> effectiveWsdlOptions = this.createWsdlOptionsFromScansAndExplicitWsdlOptions();
        if (effectiveWsdlOptions.size() == 0) {
            this.getLog().info((CharSequence)"Nothing to generate");
            return;
        }
        ClassLoaderSwitcher classLoaderSwitcher = new ClassLoaderSwitcher(this.getLog());
        boolean result = true;
        Bus bus = null;
        try {
            Set<URI> cp = classLoaderSwitcher.switchClassLoader(this.project, this.useCompileClasspath, classesDir);
            if ("once".equals(this.fork) || "true".equals(this.fork)) {
                this.forkOnce(cp, effectiveWsdlOptions);
            } else {
                for (WsdlOption o : effectiveWsdlOptions) {
                    bus = this.callWsdl2Java(o, bus, cp);
                    File[] dirs = o.getDeleteDirs();
                    if (dirs == null) continue;
                    for (int idx = 0; idx < dirs.length; ++idx) {
                        result = result && this.deleteDir(dirs[idx]);
                    }
                }
            }
        }
        finally {
            if (bus != null) {
                bus.shutdown(true);
            }
            classLoaderSwitcher.restoreClassLoader();
        }
        if (this.project != null && this.sourceRoot != null && this.sourceRoot.exists()) {
            this.project.addCompileSourceRoot(this.sourceRoot.getAbsolutePath());
        }
        if (this.project != null && this.testSourceRoot != null && this.testSourceRoot.exists()) {
            this.project.addTestCompileSourceRoot(this.testSourceRoot.getAbsolutePath());
        }
        System.gc();
    }

    private void addPluginArtifact(Set<URI> artifactsPath) {
        URL url = ((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + ".class");
        try {
            File file;
            URI uri;
            String s;
            if ("jar".equals(url.getProtocol()) && (s = url.getPath()).contains("!")) {
                s = s.substring(0, s.indexOf(33));
                url = new URL(s);
            }
            if ((uri = new URI(url.getProtocol(), null, url.getPath(), null, null)).getSchemeSpecificPart().endsWith(".class")) {
                String s2 = uri.toString();
                s2 = s2.substring(0, s2.length() - 6 - ((Object)((Object)this)).getClass().getName().length());
                uri = new URI(s2);
            }
            if ((file = new File(uri)).exists()) {
                artifactsPath.add(file.toURI());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void forkOnce(Set<URI> classPath, List<WsdlOption> effectiveWsdlOptions) throws MojoExecutionException {
        LinkedList<WsdlOption> toDo = new LinkedList<WsdlOption>();
        LinkedList<List<String>> wargs = new LinkedList<List<String>>();
        for (WsdlOption wsdlOption : effectiveWsdlOptions) {
            File outputDirFile = wsdlOption.getOutputDir();
            outputDirFile.mkdirs();
            URI basedir = this.project.getBasedir().toURI();
            URI wsdlURI = wsdlOption.getWsdlURI(basedir);
            File doneFile = this.getDoneFile(basedir, wsdlURI);
            if (!this.shouldRun(wsdlOption, doneFile, wsdlURI)) continue;
            doneFile.delete();
            toDo.add(wsdlOption);
            wargs.add(wsdlOption.generateCommandLine(outputDirFile, basedir, wsdlURI, this.getLog().isDebugEnabled()));
        }
        if (wargs.isEmpty()) {
            return;
        }
        LinkedHashSet<URI> artifactsPath = new LinkedHashSet<URI>();
        for (Artifact a : this.pluginArtifacts) {
            File file = a.getFile();
            if (file == null) {
                throw new MojoExecutionException("Unable to find " + file + " for artifact " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion());
            }
            artifactsPath.add(file.toURI());
        }
        this.addPluginArtifact(artifactsPath);
        artifactsPath.addAll(classPath);
        String[] args = this.createForkOnceArgs(wargs);
        this.runForked(artifactsPath, ForkOnceWSDL2Java.class, args);
        for (WsdlOption wsdlOption : toDo) {
            File[] dirs = wsdlOption.getDeleteDirs();
            if (dirs != null) {
                for (int idx = 0; idx < dirs.length; ++idx) {
                    this.deleteDir(dirs[idx]);
                }
            }
            URI basedir = this.project.getBasedir().toURI();
            URI wsdlURI = wsdlOption.getWsdlURI(basedir);
            File doneFile = this.getDoneFile(basedir, wsdlURI);
            try {
                doneFile.createNewFile();
            }
            catch (Throwable e) {
                this.getLog().warn((CharSequence)("Could not create marker file " + doneFile.getAbsolutePath()));
                this.getLog().debug(e);
            }
        }
    }

    private String[] createForkOnceArgs(List<List<String>> wargs) throws MojoExecutionException {
        try {
            File f = FileUtils.createTempFile((String)"cxf-w2j", (String)"args");
            PrintWriter fw = new PrintWriter(new FileWriter(f));
            for (List<String> args : wargs) {
                fw.println(Integer.toString(args.size()));
                for (String s : args) {
                    fw.println(s);
                }
            }
            fw.println("-1");
            fw.close();
            return new String[]{f.getAbsolutePath()};
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not create argument file", (Exception)ex);
        }
    }

    private Bus callWsdl2Java(WsdlOption wsdlOption, Bus bus, Set<URI> classPath) throws MojoExecutionException {
        File outputDirFile = wsdlOption.getOutputDir();
        outputDirFile.mkdirs();
        URI basedir = this.project.getBasedir().toURI();
        URI wsdlURI = wsdlOption.getWsdlURI(basedir);
        File doneFile = this.getDoneFile(basedir, wsdlURI);
        if (!this.shouldRun(wsdlOption, doneFile, wsdlURI)) {
            return bus;
        }
        doneFile.delete();
        List<String> list = wsdlOption.generateCommandLine(outputDirFile, basedir, wsdlURI, this.getLog().isDebugEnabled());
        Object[] args = list.toArray(new String[list.size()]);
        this.getLog().debug((CharSequence)("Calling wsdl2java with args: " + Arrays.toString(args)));
        if (!"false".equals(this.fork)) {
            LinkedHashSet<URI> artifactsPath = new LinkedHashSet<URI>();
            for (Artifact a : this.pluginArtifacts) {
                File file = a.getFile();
                if (file == null) {
                    throw new MojoExecutionException("Unable to find " + file + " for artifact " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion());
                }
                artifactsPath.add(file.toURI());
            }
            this.addPluginArtifact(artifactsPath);
            artifactsPath.addAll(classPath);
            this.runForked(artifactsPath, WSDLToJava.class, (String[])args);
        } else {
            if (bus == null) {
                bus = BusFactory.newInstance().createBus();
                BusFactory.setThreadDefaultBus((Bus)bus);
            }
            try {
                new WSDLToJava((String[])args).run(new ToolContext());
            }
            catch (Throwable e) {
                this.getLog().debug(e);
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        try {
            doneFile.createNewFile();
        }
        catch (Throwable e) {
            this.getLog().warn((CharSequence)("Could not create marker file " + doneFile.getAbsolutePath()));
            this.getLog().debug(e);
        }
        return bus;
    }

    private File getJavaExecutable() throws IOException {
        String exe = SystemUtils.IS_OS_WINDOWS && !this.javaExecutable.endsWith(".exe") ? ".exe" : "";
        File javaExe = new File(this.javaExecutable + exe);
        if (!javaExe.isFile()) {
            throw new IOException("The java executable '" + javaExe + "' doesn't exist or is not a file. Verify the <javaExecutable/> parameter.");
        }
        return javaExe;
    }

    private void runForked(Set<URI> classPath, Class cls, String[] args) throws MojoExecutionException {
        StringBuffer msg;
        int exitCode;
        this.getLog().info((CharSequence)"Running wsdl2java in fork mode...");
        Commandline cmd = new Commandline();
        cmd.getShell().setQuotedArgumentsEnabled(false);
        cmd.setWorkingDirectory(this.project.getBuild().getDirectory());
        try {
            cmd.setExecutable(this.getJavaExecutable().getAbsolutePath());
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        cmd.createArg().setLine(this.additionalJvmArgs);
        File file = null;
        try {
            file = FileUtils.createTempFile((String)"cxf-codegen", (String)".jar");
            JarArchiver jar = new JarArchiver();
            jar.setDestFile(file.getAbsoluteFile());
            Manifest manifest = new Manifest();
            Manifest.Attribute attr = new Manifest.Attribute();
            attr.setName("Class-Path");
            StringBuilder b = new StringBuilder(8000);
            for (URI cp : classPath) {
                b.append(cp.toURL().toExternalForm()).append(' ');
            }
            attr.setValue(b.toString());
            manifest.getMainSection().addConfiguredAttribute(attr);
            attr = new Manifest.Attribute();
            attr.setName("Main-Class");
            attr.setValue(cls.getName());
            manifest.getMainSection().addConfiguredAttribute(attr);
            jar.addConfiguredManifest(manifest);
            jar.createArchive();
            cmd.createArg().setValue("-jar");
            cmd.createArg().setValue(file.getAbsolutePath());
        }
        catch (Exception e1) {
            throw new MojoExecutionException("Could not create runtime jar", e1);
        }
        cmd.addArguments(args);
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
        }
        catch (CommandLineException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        String output = StringUtils.isEmpty((String)out.getOutput()) ? null : '\n' + out.getOutput().trim();
        String cmdLine = CommandLineUtils.toString((String[])cmd.getCommandline());
        if (exitCode != 0) {
            if (StringUtils.isNotEmpty((String)output)) {
                this.getLog().info((CharSequence)output);
            }
            msg = new StringBuffer("\nExit code: ");
            msg.append(exitCode);
            if (StringUtils.isNotEmpty((String)err.getOutput())) {
                msg.append(" - ").append(err.getOutput());
            }
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MojoExecutionException(msg.toString());
        }
        if (file != null) {
            file.delete();
        }
        if (StringUtils.isNotEmpty((String)err.getOutput()) && err.getOutput().contains("WSDL2Java Error")) {
            msg = new StringBuffer();
            msg.append(err.getOutput());
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MojoExecutionException(msg.toString());
        }
    }

    private File getDoneFile(URI basedir, URI wsdlURI) {
        String doneFileName = wsdlURI.toString();
        if (doneFileName.startsWith(basedir.toString())) {
            doneFileName = doneFileName.substring(basedir.toString().length());
        }
        doneFileName = doneFileName.replace('?', '_').replace('&', '_').replace('/', '_').replace('\\', '_').replace(':', '_');
        return new File(this.markerDirectory, "." + doneFileName + ".DONE");
    }

    private boolean shouldRun(WsdlOption wsdlOption, File doneFile, URI wsdlURI) {
        long timestamp = 0L;
        if ("file".equals(wsdlURI.getScheme())) {
            timestamp = new File(wsdlURI).lastModified();
        } else {
            try {
                timestamp = wsdlURI.toURL().openConnection().getDate();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean doWork = false;
        if (!doneFile.exists()) {
            doWork = true;
        } else if (timestamp > doneFile.lastModified()) {
            doWork = true;
        } else if (wsdlOption.isDefServiceName()) {
            doWork = true;
        } else {
            File[] files = wsdlOption.getDependencies();
            if (files != null) {
                for (int z = 0; z < files.length; ++z) {
                    if (files[z].lastModified() <= doneFile.lastModified()) continue;
                    doWork = true;
                }
            }
        }
        return doWork;
    }

    private boolean deleteDir(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int idx = 0; idx < files.length; ++idx) {
                this.deleteDir(files[idx]);
            }
        }
        if (f.exists()) {
            return f.delete();
        }
        return true;
    }
}

