/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.brave.TraceScope;
import org.apache.cxf.tracing.brave.internal.HttpAdapterFactory;
import org.apache.cxf.tracing.brave.internal.HttpClientAdapterFactory;

public abstract class AbstractBraveClientProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractBraveClientProvider.class);
    protected static final String TRACE_SPAN = "org.apache.cxf.tracing.client.brave.span";
    private final HttpTracing brave;

    public AbstractBraveClientProvider(HttpTracing brave) {
        this.brave = brave;
    }

    protected AbstractTracingProvider.TraceScopeHolder<TraceScope> startTraceSpan(Map<String, List<String>> requestHeaders, URI uri, String method) {
        HttpAdapterFactory.Request request = HttpAdapterFactory.request(requestHeaders, uri, method);
        HttpClientAdapter<HttpAdapterFactory.Request, HttpAdapterFactory.Response> adapter = HttpClientAdapterFactory.create(request);
        HttpClientHandler handler = HttpClientHandler.create((HttpTracing)this.brave, adapter);
        Span span = handler.handleSend(this.brave.tracing().propagation().injector(this.inject(requestHeaders)), (Object)request);
        Tracer.SpanInScope scope = null;
        if (!this.isAsyncInvocation() && span != null) {
            scope = this.brave.tracing().tracer().withSpanInScope(span);
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)new TraceScope(span, scope), scope == null);
    }

    private <C> Propagation.Setter<C, String> inject(Map<String, List<String>> requestHeaders) {
        return (carrier, key, value) -> {
            if (!requestHeaders.containsKey(key)) {
                requestHeaders.put((String)key, Collections.singletonList(value));
            }
        };
    }

    private boolean isAsyncInvocation() {
        return !PhaseInterceptorChain.getCurrentMessage().getExchange().isSynchronous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTraceSpan(AbstractTracingProvider.TraceScopeHolder<TraceScope> holder, int responseStatus) {
        if (holder == null) {
            return;
        }
        TraceScope scope = (TraceScope)holder.getScope();
        if (scope != null) {
            try {
                if (holder.isDetached()) {
                    this.brave.tracing().tracer().joinSpan(scope.getSpan().context());
                }
                HttpAdapterFactory.Response response = HttpAdapterFactory.response(responseStatus);
                HttpClientAdapter<HttpAdapterFactory.Request, HttpAdapterFactory.Response> adapter = HttpClientAdapterFactory.create(response);
                HttpClientHandler handler = HttpClientHandler.create((HttpTracing)this.brave, adapter);
                handler.handleReceive((Object)response, null, scope.getSpan());
            }
            finally {
                scope.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTraceSpan(AbstractTracingProvider.TraceScopeHolder<TraceScope> holder, Throwable ex) {
        if (holder == null) {
            return;
        }
        TraceScope scope = (TraceScope)holder.getScope();
        if (scope != null) {
            try {
                if (holder.isDetached()) {
                    this.brave.tracing().tracer().joinSpan(scope.getSpan().context());
                }
                HttpClientHandler handler = HttpClientHandler.create((HttpTracing)this.brave);
                handler.handleReceive(null, ex, scope.getSpan());
            }
            finally {
                scope.close();
            }
        }
    }
}

