/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging.event;

import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.ext.logging.event.EventType;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventMapper;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;

public class DefaultLogEventMapper
implements LogEventMapper {
    private static final Set<String> BINARY_CONTENT_MEDIA_TYPES = new HashSet<String>();

    @Override
    public LogEvent map(Message message) {
        String ct;
        String httpMethod;
        String encoding;
        Integer responseCode;
        LogEvent event = new LogEvent();
        event.setMessageId(this.getMessageId(message));
        event.setExchangeId((String)message.getExchange().get((Object)"exchangeId"));
        event.setType(this.getEventType(message));
        if (!Boolean.TRUE.equals(message.get((Object)"decoupled.channel.message")) && (responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE)) != null) {
            event.setResponseCode(responseCode.toString());
        }
        if ((encoding = (String)message.get((Object)Message.ENCODING)) != null) {
            event.setEncoding(encoding);
        }
        if ((httpMethod = (String)message.get((Object)"org.apache.cxf.request.method")) != null) {
            event.setHttpMethod(httpMethod);
        }
        if ((ct = (String)message.get((Object)"Content-Type")) != null) {
            event.setContentType(ct);
        }
        Map<String, String> headerMap = this.getHeaders(message);
        event.setHeaders(headerMap);
        String uri = this.getUri(message);
        if (uri != null) {
            event.setAddress(uri);
        }
        event.setPrincipal(this.getPrincipal(message));
        event.setBinaryContent(this.isBinaryContent(message));
        this.setEpInfo(message, event);
        return event;
    }

    private String getPrincipal(Message message) {
        String principal = this.getJAASPrincipal();
        if (principal != null) {
            return principal;
        }
        SecurityContext sc = (SecurityContext)message.get(SecurityContext.class);
        if (sc != null && sc.getUserPrincipal() != null) {
            return sc.getUserPrincipal().getName();
        }
        AuthorizationPolicy authPolicy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class);
        if (authPolicy != null) {
            return authPolicy.getUserName();
        }
        return null;
    }

    private String getJAASPrincipal() {
        StringBuilder principals = new StringBuilder();
        Iterator<? extends Object> principalIt = this.getJAASPrincipals();
        while (principalIt.hasNext()) {
            principals.append(principalIt.next());
            if (!principalIt.hasNext()) continue;
            principals.append(",");
        }
        return principals.toString();
    }

    private Iterator<? extends Object> getJAASPrincipals() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        return subject != null && subject.getPrincipals() != null ? subject.getPrincipals().iterator() : Collections.emptyIterator();
    }

    private Map<String, String> getHeaders(Message message) {
        Map headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : headers.keySet()) {
            List value = (List)headers.get(key);
            if (value.size() == 1) {
                result.put(key, (String)value.iterator().next());
                continue;
            }
            String[] valueAr = value.toArray(new String[0]);
            result.put(key, valueAr.toString());
        }
        return result;
    }

    private String getUri(Message message) {
        String query;
        String uri = (String)message.get((Object)"org.apache.cxf.request.url");
        if (uri == null) {
            String address = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
            uri = (String)message.get((Object)"org.apache.cxf.request.uri");
            if (uri != null && uri.startsWith("/")) {
                if (address != null && !address.startsWith(uri)) {
                    if (address.endsWith("/") && address.length() > 1) {
                        address = address.substring(0, address.length());
                    }
                    uri = address + uri;
                }
            } else {
                uri = address;
            }
        }
        if ((query = (String)message.get((Object)Message.QUERY_STRING)) != null) {
            return uri + "?" + query;
        }
        return uri;
    }

    private boolean isBinaryContent(Message message) {
        String contentType = (String)message.get((Object)"Content-Type");
        return contentType != null && BINARY_CONTENT_MEDIA_TYPES.contains(contentType);
    }

    private boolean isSOAPMessage(Message message) {
        Binding binding = message.getExchange().getBinding();
        return binding != null && binding.getClass().getSimpleName().equals("SoapBinding");
    }

    private String getMessageId(Message message) {
        AddressingProperties addrProp = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)MessageUtils.isOutbound((Message)message), (boolean)false);
        return addrProp != null ? addrProp.getMessageID().getValue() : UUID.randomUUID().toString();
    }

    private String getOperationName(Message message) {
        Message reqMsg;
        Message inMsg;
        String operationName = null;
        BindingOperationInfo boi = null;
        boi = message.getExchange().getBindingOperationInfo();
        if (null == boi) {
            boi = this.getOperationFromContent(message);
        }
        if (null == boi && null != (inMsg = message.getExchange().getInMessage()) && null != (reqMsg = inMsg.getExchange().getInMessage())) {
            boi = this.getOperationFromContent(reqMsg);
        }
        if (null != boi) {
            operationName = boi.getName().toString();
        }
        return operationName;
    }

    private BindingOperationInfo getOperationFromContent(Message message) {
        BindingOperationInfo boi = null;
        XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        if (null != xmlReader) {
            QName qName = xmlReader.getName();
            boi = ServiceModelUtil.getOperation((Exchange)message.getExchange(), (QName)qName);
        }
        return boi;
    }

    private Message getEffectiveMessage(Message message) {
        boolean isRequestor = MessageUtils.isRequestor((Message)message);
        boolean isOutbound = MessageUtils.isOutbound((Message)message);
        if (isRequestor) {
            return isOutbound ? message : message.getExchange().getOutMessage();
        }
        return isOutbound ? message.getExchange().getInMessage() : message;
    }

    private String getRestOperationName(Message curMessage) {
        Message message = this.getEffectiveMessage(curMessage);
        if (message.containsKey((Object)"org.apache.cxf.request.method")) {
            int baseUriLength;
            String requestUri;
            String httpMethod = message.get((Object)"org.apache.cxf.request.method").toString();
            String path = "";
            if (message.containsKey((Object)"org.apache.cxf.request.uri") && (path = (requestUri = message.get((Object)"org.apache.cxf.request.uri").toString()).substring(baseUriLength = message.containsKey((Object)Message.BASE_PATH) ? message.get((Object)Message.BASE_PATH).toString().length() : 0)).isEmpty()) {
                path = "/";
            }
            return new StringBuffer().append(httpMethod).append('[').append(path).append(']').toString();
        }
        return "";
    }

    private EventType getEventType(Message message) {
        boolean isOutbound;
        boolean isRequestor = MessageUtils.isRequestor((Message)message);
        boolean isFault = MessageUtils.isFault((Message)message);
        if (!isFault) {
            boolean bl = isFault = !this.isSOAPMessage(message) && this.isRESTFault(message);
        }
        if (isOutbound = MessageUtils.isOutbound((Message)message)) {
            if (isFault) {
                return EventType.FAULT_OUT;
            }
            return isRequestor ? EventType.REQ_OUT : EventType.RESP_OUT;
        }
        if (isFault) {
            return EventType.FAULT_IN;
        }
        return isRequestor ? EventType.RESP_IN : EventType.REQ_IN;
    }

    private boolean isRESTFault(Message message) {
        Object opName = message.getExchange().get((Object)"org.apache.cxf.resource.operation.name");
        if (opName == null) {
            return true;
        }
        Integer responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE);
        return responseCode != null && responseCode >= 400;
    }

    private void setEpInfo(Message message, LogEvent event) {
        EndpointInfo endpoint = this.getEPInfo(message);
        event.setPortName(endpoint.getName());
        event.setPortTypeName(endpoint.getName());
        event.setOperationName(this.getRestOperationName(message));
        String opName = this.isSOAPMessage(message) ? this.getOperationName(message) : this.getRestOperationName(message);
        event.setOperationName(opName);
        if (endpoint.getService() != null) {
            this.setServiceInfo(endpoint.getService(), event);
        }
    }

    private void setServiceInfo(ServiceInfo service, LogEvent event) {
        event.setServiceName(service.getName());
        InterfaceInfo iface = service.getInterface();
        event.setPortTypeName(iface.getName());
    }

    private EndpointInfo getEPInfo(Message message) {
        Endpoint ep = message.getExchange().getEndpoint();
        return ep == null ? null : ep.getEndpointInfo();
    }

    static {
        BINARY_CONTENT_MEDIA_TYPES.add("application/octet-stream");
        BINARY_CONTENT_MEDIA_TYPES.add("image/png");
        BINARY_CONTENT_MEDIA_TYPES.add("image/jpeg");
        BINARY_CONTENT_MEDIA_TYPES.add("image/gif");
    }
}

