/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.ext.logging.LoggingInInterceptor;
import org.apache.cxf.ext.logging.LoggingOutInterceptor;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.PrettyLoggingFilter;
import org.apache.cxf.ext.logging.slf4j.Slf4jEventSender;
import org.apache.cxf.ext.logging.slf4j.Slf4jVerboseEventSender;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;

@NoJSR250Annotations
@Provider(value=Provider.Type.Feature)
public class LoggingFeature
extends AbstractFeature {
    private LogEventSender sender = new Slf4jVerboseEventSender();
    private LoggingInInterceptor in;
    private LoggingOutInterceptor out;
    private PrettyLoggingFilter prettyFilter = new PrettyLoggingFilter(this.sender);

    public LoggingFeature() {
        this.in = new LoggingInInterceptor(this.prettyFilter);
        this.out = new LoggingOutInterceptor(this.prettyFilter);
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        provider.getInInterceptors().add(this.in);
        provider.getInFaultInterceptors().add(this.in);
        provider.getOutInterceptors().add(this.out);
        provider.getOutFaultInterceptors().add(this.out);
    }

    public void setLimit(int limit) {
        this.in.setLimit(limit);
        this.out.setLimit(limit);
    }

    public void setInMemThreshold(long inMemThreshold) {
        this.in.setInMemThreshold(inMemThreshold);
        this.out.setInMemThreshold(inMemThreshold);
    }

    public void setSender(LogEventSender sender) {
        this.prettyFilter.setNext(sender);
    }

    public void setPrettyLogging(boolean prettyLogging) {
        this.prettyFilter.setPrettyLogging(prettyLogging);
    }

    public void setLogBinary(boolean logBinary) {
        this.in.setLogBinary(logBinary);
        this.out.setLogBinary(logBinary);
    }

    public void setLogMultipart(boolean logMultipart) {
        this.in.setLogMultipart(logMultipart);
        this.out.setLogMultipart(logMultipart);
    }

    public void setVerbose(boolean verbose) {
        this.sender = verbose ? new Slf4jVerboseEventSender() : new Slf4jEventSender();
        this.prettyFilter.setNext(this.sender);
    }
}

